/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.compat;

import cech12.extendedmushrooms.ExtendedMushrooms;
import cech12.extendedmushrooms.compat.ILikeWood;
import cech12.extendedmushrooms.compat.Quark;
import cech12.extendedmushrooms.compat.VanillaThings;
import cech12.extendedmushrooms.config.Config;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;

public class ModCompat {
    public static final Mod[] MODS = new Mod[]{new ILikeWood(), new Quark(), new VanillaThings()};

    private static boolean inDevMode() {
        return ExtendedMushrooms.DEVELOPMENT_MODE;
    }

    private static boolean checkValue(Class<?> clazz, ForgeConfigSpec.IntValue config) {
        int configValue = (Integer)config.get();
        if (configValue == 1 || ModCompat.inDevMode() && configValue != 0) {
            return true;
        }
        if (configValue == 2) {
            for (Mod mod : MODS) {
                if (!clazz.isInstance(mod) || !mod.isLoaded()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isVariantBookshelvesModLoaded() {
        return ModCompat.checkValue(VariantBookshelfMod.class, Config.VARIANT_BOOKSHELF_ENABLED);
    }

    public static boolean isVariantChestsModLoaded() {
        return ModCompat.checkValue(VariantChestsMod.class, Config.VARIANT_CHESTS_ENABLED);
    }

    public static boolean isVariantTrappedChestsModLoaded() {
        return ModCompat.checkValue(VariantTrappedChestsMod.class, Config.VARIANT_TRAPPED_CHESTS_ENABLED);
    }

    public static boolean isVariantLaddersModLoaded() {
        return ModCompat.checkValue(VariantLadderMod.class, Config.VARIANT_LADDER_ENABLED);
    }

    public static boolean isVerticalPlanksModLoaded() {
        return ModCompat.checkValue(VerticalPlanksMod.class, Config.VERTICAL_PLANKS_ENABLED);
    }

    public static boolean isVerticalSlabsModLoaded() {
        return ModCompat.checkValue(VerticalSlabsMod.class, Config.VERTICAL_SLABS_ENABLED);
    }

    public static interface VerticalSlabsMod {
    }

    public static interface VerticalPlanksMod {
    }

    public static interface VariantLadderMod {
    }

    public static interface VariantTrappedChestsMod {
    }

    public static interface VariantChestsMod {
    }

    public static interface VariantBookshelfMod {
    }

    public static class Mod {
        protected String name;

        public Mod(String name) {
            this.name = name;
        }

        public boolean isLoaded() {
            return ModList.get().isLoaded(this.name);
        }
    }
}

