/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.client.jei;

import cech12.extendedmushrooms.api.recipe.ExtendedMushroomsRecipeTypes;
import cech12.extendedmushrooms.api.recipe.FairyRingRecipe;
import cech12.extendedmushrooms.client.jei.ExtendedMushroomsJEIPlugin;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;

public class FairyRingCategory
implements IRecipeCategory<FairyRingRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName = I18n.func_135052_a((String)"jei.extendedmushrooms.fairy_ring", (Object[])new Object[0]);
    private final int regularCookTime;
    private final LoadingCache<Integer, IDrawableAnimated> cachedBubbles;

    public FairyRingCategory(final IGuiHelper guiHelper) {
        this.regularCookTime = 200;
        this.background = guiHelper.createDrawable(ExtendedMushroomsJEIPlugin.RECIPE_GUI_FAIRY_RING, 0, 0, 112, 61);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)Items.field_221694_bi));
        this.cachedBubbles = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(@Nonnull Integer cookTime) {
                return guiHelper.drawableBuilder(ExtendedMushroomsJEIPlugin.RECIPE_GUI_FAIRY_RING, 112, 0, 11, 20).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.BOTTOM, false);
            }
        });
    }

    protected IDrawableAnimated getBubbles(FairyRingRecipe recipe) {
        int cookTime = recipe.getRecipeTime();
        if (cookTime <= 0) {
            cookTime = this.regularCookTime;
        }
        return (IDrawableAnimated)this.cachedBubbles.getUnchecked((Object)cookTime);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return ExtendedMushroomsRecipeTypes.FAIRY_RING_ID;
    }

    @Nonnull
    public Class<? extends FairyRingRecipe> getRecipeClass() {
        return FairyRingRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(FairyRingRecipe recipe, @Nonnull IIngredients ingredients) {
        ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>();
        for (Ingredient ingr : recipe.func_192400_c()) {
            list.add(Arrays.asList(ingr.func_193365_a()));
        }
        ingredients.setInputLists(VanillaTypes.ITEM, list);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void draw(@Nonnull FairyRingRecipe recipe, @Nonnull MatrixStack matrixStack, double mouseX, double mouseY) {
        IDrawableAnimated arrow = this.getBubbles(recipe);
        arrow.draw(matrixStack, 69, 24);
        this.drawRecipeTime(recipe, matrixStack, 52);
    }

    protected void drawRecipeTime(FairyRingRecipe recipe, MatrixStack matrixStack, int y) {
        int cookTime = recipe.getRecipeTime();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            TranslationTextComponent timeString = new TranslationTextComponent("gui.jei.category.smelting.time.seconds", new Object[]{cookTimeSeconds});
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            int stringWidth = fontRenderer.func_238414_a_((ITextProperties)timeString);
            fontRenderer.func_243248_b(matrixStack, (ITextComponent)timeString, (float)(this.background.getWidth() - stringWidth), (float)y, -8355712);
        }
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull FairyRingRecipe recipe, @Nonnull IIngredients ingredients) {
        int index = 0;
        Vector2f center = new Vector2f(23.0f, 19.0f);
        if (ingredients.getInputs(VanillaTypes.ITEM).size() > 1) {
            double angleBetweenEach = 360.0 / (double)ingredients.getInputs(VanillaTypes.ITEM).size();
            Vector2f point = new Vector2f(center.field_189982_i, 4.0f);
            for (List o : ingredients.getInputs(VanillaTypes.ITEM)) {
                recipeLayout.getItemStacks().init(index, true, (int)point.field_189982_i, (int)point.field_189983_j);
                recipeLayout.getItemStacks().set(index, o);
                point = FairyRingCategory.rotatePointAbout(point, center, angleBetweenEach);
                ++index;
            }
        } else {
            recipeLayout.getItemStacks().init(index, true, (int)center.field_189982_i, (int)center.field_189983_j);
            recipeLayout.getItemStacks().set(index, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
            ++index;
        }
        recipeLayout.getItemStacks().init(index, false, 90, 25);
        recipeLayout.getItemStacks().set(index, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }

    public static Vector2f rotatePointAbout(Vector2f in, Vector2f about, double degrees) {
        double rad = degrees * Math.PI / 180.0;
        double newX = Math.cos(rad) * (double)(in.field_189982_i - about.field_189982_i) - Math.sin(rad) * (double)(in.field_189983_j - about.field_189983_j) + (double)about.field_189982_i;
        double newY = Math.sin(rad) * (double)(in.field_189982_i - about.field_189982_i) + Math.cos(rad) * (double)(in.field_189983_j - about.field_189983_j) + (double)about.field_189983_j;
        return new Vector2f((float)newX, (float)newY);
    }
}

