/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.block.mushrooms;

import cech12.extendedmushrooms.MushroomUtils;
import cech12.extendedmushrooms.block.mushrooms.BigMushroom;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.server.ServerWorld;

public abstract class MegaMushroom
extends BigMushroom {
    @Override
    public boolean growMushroom(ServerWorld world, ChunkGenerator chunkGenerator, BlockPos blockPos, BlockState blockState, Random random) {
        if (!MushroomUtils.isValidMushroomPosition((IWorldReader)world, blockPos)) {
            return false;
        }
        for (int x = 0; x >= -1; --x) {
            for (int z = 0; z >= -1; --z) {
                if (!MegaMushroom.canMegaMushroomSpawnAt(blockState, (IBlockReader)world, blockPos, x, z)) continue;
                return this.growMegaMushroom(world, chunkGenerator, blockPos, blockState, random, x, z);
            }
        }
        return super.growMushroom(world, chunkGenerator, blockPos, blockState, random);
    }

    @Nonnull
    protected abstract ConfiguredFeature<?, ?> getMegaMushroomFeature();

    protected boolean growMegaMushroom(ServerWorld world, ChunkGenerator chunkGenerator, BlockPos blockPos, BlockState blockState, Random random, int x, int z) {
        ConfiguredFeature<?, ?> feature = this.getMegaMushroomFeature();
        BlockState lvt_9_1_ = Blocks.field_150350_a.func_176223_P();
        world.func_180501_a(blockPos.func_177982_a(x, 0, z), lvt_9_1_, 4);
        world.func_180501_a(blockPos.func_177982_a(x + 1, 0, z), lvt_9_1_, 4);
        world.func_180501_a(blockPos.func_177982_a(x, 0, z + 1), lvt_9_1_, 4);
        world.func_180501_a(blockPos.func_177982_a(x + 1, 0, z + 1), lvt_9_1_, 4);
        if (feature.func_242765_a((ISeedReader)world, chunkGenerator, random, blockPos.func_177982_a(x, 0, z))) {
            return true;
        }
        world.func_180501_a(blockPos.func_177982_a(x, 0, z), blockState, 4);
        world.func_180501_a(blockPos.func_177982_a(x + 1, 0, z), blockState, 4);
        world.func_180501_a(blockPos.func_177982_a(x, 0, z + 1), blockState, 4);
        world.func_180501_a(blockPos.func_177982_a(x + 1, 0, z + 1), blockState, 4);
        return false;
    }

    public static boolean canMegaMushroomSpawnAt(BlockState blockState, IBlockReader blockReader, BlockPos blockPos, int x, int z) {
        Block block = blockState.func_177230_c();
        return block == blockReader.func_180495_p(blockPos.func_177982_a(x, 0, z)).func_177230_c() && block == blockReader.func_180495_p(blockPos.func_177982_a(x + 1, 0, z)).func_177230_c() && block == blockReader.func_180495_p(blockPos.func_177982_a(x, 0, z + 1)).func_177230_c() && block == blockReader.func_180495_p(blockPos.func_177982_a(x + 1, 0, z + 1)).func_177230_c();
    }
}

