/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.block;

import cech12.extendedmushrooms.api.block.ExtendedMushroomsBlocks;
import cech12.extendedmushrooms.tileentity.FairyRingTileEntity;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.MushroomBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FairyRingBlock
extends AirBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    public static final Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public FairyRingBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151579_a).func_200942_a().func_222380_e());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, LIT});
    }

    @Nonnull
    @Deprecated
    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    @Nonnull
    @Deprecated
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)LIT) != false ? 15 : 0;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    @Nonnull
    @Deprecated
    public BlockRenderType func_149645_b(@Nullable BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FairyRingTileEntity();
    }

    @Deprecated
    public void func_196262_a(@Nullable BlockState blockState, World world, @Nonnull BlockPos blockPos, @Nonnull Entity entity) {
        TileEntity tileentity = world.func_175625_s(blockPos);
        if (tileentity instanceof FairyRingTileEntity) {
            ((FairyRingTileEntity)tileentity).onEntityCollision(entity);
        }
    }

    @Deprecated
    public void func_196243_a(BlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof FairyRingTileEntity) {
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((FairyRingTileEntity)tileentity));
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(@Nonnull BlockState stateIn, World worldIn, @Nonnull BlockPos pos, @Nonnull Random rand) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof FairyRingTileEntity) {
            ((FairyRingTileEntity)tileentity).animateTick(worldIn, rand);
        }
    }

    @Deprecated
    public boolean func_189539_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, int id, int param) {
        super.func_189539_a(state, world, pos, id, param);
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(id, param);
    }

    @Deprecated
    public void func_220069_a(@Nonnull BlockState blockState, @Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull Block block, @Nonnull BlockPos neighbourPos, boolean isMoving) {
        boolean mushroomSeen = false;
        int mushrooms = 0;
        boolean fairyRingBlockSeen = false;
        int fairyRingBlocks = 0;
        boolean neighboursFound = false;
        for (Direction direction : DIRECTIONS) {
            Block neighbourBlock = world.func_180495_p(blockPos.func_177972_a(direction)).func_177230_c();
            if (neighbourBlock instanceof MushroomBlock) {
                ++mushrooms;
                if (mushroomSeen) {
                    neighboursFound = true;
                    continue;
                }
                mushroomSeen = true;
                fairyRingBlockSeen = false;
                continue;
            }
            if (neighbourBlock != ExtendedMushroomsBlocks.FAIRY_RING) break;
            ++fairyRingBlocks;
            if (fairyRingBlockSeen) {
                neighboursFound = true;
                continue;
            }
            mushroomSeen = false;
            fairyRingBlockSeen = true;
        }
        if (!neighboursFound || mushrooms != 2 || fairyRingBlocks != 2 || !world.func_180495_p(blockPos.func_177977_b()).func_200132_m()) {
            world.func_175656_a(blockPos, Blocks.field_150350_a.func_176223_P());
        }
        super.func_220069_a(blockState, world, blockPos, block, neighbourPos, isMoving);
    }

    public static void fairyRingPlaceCheck(IWorld world, BlockPos pos) {
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        boolean[] clockwises = new boolean[]{true, false};
        for (Direction direction : DIRECTIONS) {
            for (boolean clockwise : clockwises) {
                try {
                    FairyRing fairyRing = new FairyRing(world, direction, clockwise, mutablePos.func_189533_g((Vector3i)pos));
                    fairyRing.placeBlocks(world);
                }
                catch (FairyRing.CannotFormFairyRingException cannotFormFairyRingException) {
                    // empty catch block
                }
            }
        }
    }

    private static class FairyRing {
        LinkedList<BlockPos> ringPositions;

        FairyRing(IWorld world, Direction direction, boolean clockwise, BlockPos.Mutable mutablePos) throws CannotFormFairyRingException {
            this.ringPositions = FairyRing.getFairyRingPositions(world, new LinkedList<BlockPos>(), direction, clockwise, mutablePos);
            if (this.ringPositions == null || this.ringPositions.size() != 12) {
                throw new CannotFormFairyRingException();
            }
        }

        private static LinkedList<BlockPos> getFairyRingPositions(IWorld world, LinkedList<BlockPos> positions, Direction direction, boolean clockwise, BlockPos.Mutable mutablePos) {
            Direction rotatedDirection = clockwise ? direction.func_176746_e() : direction.func_176735_f();
            Direction newDirection = direction;
            if (positions.size() < 8 && !(world.func_180495_p((BlockPos)mutablePos).func_177230_c() instanceof MushroomBlock)) {
                return null;
            }
            if (!(positions.size() < 8 || world.func_180495_p((BlockPos)mutablePos).func_177230_c() == Blocks.field_150350_a && world.func_180495_p(mutablePos.func_177977_b()).func_200132_m())) {
                return null;
            }
            positions.add(new BlockPos((Vector3i)mutablePos));
            if (positions.size() != 8) {
                mutablePos.func_189536_c(direction);
            }
            if (positions.size() >= 8 || positions.size() % 2 == 0) {
                newDirection = rotatedDirection;
            }
            if (positions.size() == 8 || positions.size() < 8 && positions.size() % 2 == 0) {
                mutablePos.func_189536_c(newDirection);
            }
            if (positions.size() < 12) {
                return FairyRing.getFairyRingPositions(world, positions, newDirection, clockwise, mutablePos);
            }
            return positions;
        }

        private List<BlockPos> getSortedCenterPositions() {
            List<BlockPos> list = this.ringPositions.subList(8, 12);
            list.sort((o1, o2) -> {
                int result = o1.func_177958_n() - o2.func_177958_n();
                if (result == 0) {
                    return o1.func_177952_p() - o2.func_177952_p();
                }
                return result;
            });
            return list;
        }

        void placeBlocks(IWorld world) {
            List<BlockPos> list = this.getSortedCenterPositions();
            for (int i = 0; i < 4; ++i) {
                BlockState state = (BlockState)ExtendedMushroomsBlocks.FAIRY_RING.func_176223_P().func_206870_a((Property)FACING, (Comparable)DIRECTIONS[i]);
                world.func_180501_a(list.get(i), state, 2);
            }
        }

        static class CannotFormFairyRingException
        extends Exception {
            CannotFormFairyRingException() {
            }
        }
    }
}

