/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.api.recipe;

import cech12.extendedmushrooms.api.recipe.ExtendedMushroomsRecipeTypes;
import cech12.extendedmushrooms.api.recipe.FairyRingMode;
import cech12.extendedmushrooms.api.recipe.IFairyRingRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class FairyRingRecipe
implements IFairyRingRecipe,
IRecipe<IInventory> {
    public static final Serializer SERIALIZER = new Serializer();
    protected ResourceLocation resourceLocation;
    protected NonNullList<Ingredient> ingredients;
    protected FairyRingMode requiredMode;
    protected int recipeTime;
    protected ItemStack resultStack;
    protected FairyRingMode resultMode;

    public FairyRingRecipe(ResourceLocation resourceLocation, FairyRingMode requiredMode, NonNullList<Ingredient> ingredients, int recipeTime, FairyRingMode resultMode, ItemStack resultStack) {
        this.resourceLocation = resourceLocation;
        this.requiredMode = requiredMode;
        this.ingredients = ingredients;
        this.recipeTime = recipeTime;
        this.resultMode = resultMode;
        this.resultStack = resultStack;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.resourceLocation;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    @Nonnull
    public IRecipeType<?> func_222127_g() {
        return ExtendedMushroomsRecipeTypes.FAIRY_RING;
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    @Override
    public int getRecipeTime() {
        return this.recipeTime;
    }

    @Override
    @Nonnull
    public FairyRingMode getRequiredMode() {
        return this.requiredMode;
    }

    @Override
    @Nullable
    public ItemStack getResultItemStack() {
        return this.resultStack.func_77946_l();
    }

    @Override
    @Nonnull
    public FairyRingMode getResultMode() {
        return this.resultMode;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.resultStack.func_77946_l();
    }

    @Nonnull
    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)Items.field_221694_bi);
    }

    public boolean isValid(FairyRingMode mode, IInventory inv) {
        if (inv.func_70297_j_() != 1) {
            return false;
        }
        if (mode != this.getRequiredMode()) {
            return false;
        }
        ArrayList<Ingredient> ingredientsMissing = new ArrayList<Ingredient>((Collection<Ingredient>)this.ingredients);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack input = inv.func_70301_a(i);
            if (input.func_190926_b()) continue;
            int index = -1;
            for (int j = 0; j < ingredientsMissing.size(); ++j) {
                Ingredient ingredient = (Ingredient)ingredientsMissing.get(j);
                if (!ingredient.test(input)) continue;
                index = j;
                break;
            }
            if (index == -1) {
                return false;
            }
            ingredientsMissing.remove(index);
        }
        return ingredientsMissing.isEmpty();
    }

    @Deprecated
    public boolean func_194133_a(int width, int height) {
        return false;
    }

    @Deprecated
    public boolean func_77569_a(@Nonnull IInventory inv, @Nonnull World worldIn) {
        return false;
    }

    @Nonnull
    @Deprecated
    public ItemStack func_77572_b(@Nonnull IInventory inv) {
        return this.resultStack.func_77946_l();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<FairyRingRecipe> {
        Serializer() {
            this.setRegistryName(new ResourceLocation("extendedmushrooms", "fairy_ring_recipe"));
        }

        @Nonnull
        public FairyRingRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            FairyRingMode requiredMode = Serializer.readMode(json, FairyRingMode.NORMAL);
            NonNullList<Ingredient> ingredients = Serializer.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for fairy ring recipe");
            }
            if (ingredients.size() > 16) {
                throw new JsonParseException("Too many ingredients for fairy ring recipe the max is 16");
            }
            int time = JSONUtils.func_151203_m((JsonObject)json, (String)"recipeTime");
            JsonObject resultJson = JSONUtils.func_152754_s((JsonObject)json, (String)"result");
            FairyRingMode resultMode = Serializer.readMode(resultJson, requiredMode);
            ItemStack resultStack = ItemStack.field_190927_a;
            if (JSONUtils.func_151204_g((JsonObject)resultJson, (String)"item")) {
                resultStack = ShapedRecipe.func_199798_a((JsonObject)resultJson);
            }
            return new FairyRingRecipe(recipeId, requiredMode, ingredients, time, resultMode, resultStack);
        }

        public FairyRingRecipe fromNetwork(@Nonnull ResourceLocation recipeId, PacketBuffer buffer) {
            FairyRingMode requiredMode = FairyRingMode.byName(buffer.func_150789_c(Short.MAX_VALUE));
            int size = buffer.func_150792_a();
            NonNullList ingredients = NonNullList.func_191197_a((int)size, (Object)Ingredient.field_193370_a);
            ingredients.replaceAll(ignored -> Ingredient.func_199566_b((PacketBuffer)buffer));
            int time = buffer.func_150792_a();
            FairyRingMode resultMode = FairyRingMode.byName(buffer.func_150789_c(Short.MAX_VALUE));
            ItemStack resultStack = buffer.func_150791_c();
            return new FairyRingRecipe(recipeId, requiredMode, (NonNullList<Ingredient>)ingredients, time, resultMode, resultStack);
        }

        public void toNetwork(PacketBuffer buffer, FairyRingRecipe recipe) {
            buffer.func_180714_a(recipe.requiredMode.getName());
            buffer.func_150787_b(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150787_b(recipe.recipeTime);
            buffer.func_180714_a(recipe.resultMode.getName());
            buffer.func_150788_a(recipe.resultStack);
        }

        private static FairyRingMode readMode(@Nonnull JsonObject jsonObject, @Nonnull FairyRingMode defaultMode) {
            FairyRingMode mode = defaultMode;
            try {
                String modeString = JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"mode");
                mode = FairyRingMode.byName(modeString);
                if (mode == null) {
                    throw new JsonParseException("Mode " + modeString + " does not exist");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return mode;
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray jsonArray) {
            NonNullList nonnulllist = NonNullList.func_191196_a();
            for (int i = 0; i < jsonArray.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)jsonArray.get(i));
                if (ingredient.func_203189_d()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }
    }
}

