/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms;

import cech12.extendedmushrooms.api.block.ExtendedMushroomsBlocks;
import cech12.extendedmushrooms.api.recipe.ExtendedMushroomsRecipeTypes;
import cech12.extendedmushrooms.api.recipe.FairyRingRecipe;
import cech12.extendedmushrooms.block.FairyRingBlock;
import cech12.extendedmushrooms.compat.ModFeatureEnabledCondition;
import cech12.extendedmushrooms.config.Config;
import cech12.extendedmushrooms.entity.ai.goal.EatMushroomGoal;
import cech12.extendedmushrooms.entity.passive.MushroomSheepEntity;
import cech12.extendedmushrooms.init.ModBlocks;
import cech12.extendedmushrooms.init.ModEntities;
import cech12.extendedmushrooms.init.ModFeatures;
import cech12.extendedmushrooms.init.ModTags;
import cech12.extendedmushrooms.init.ModTileEntities;
import cech12.extendedmushrooms.init.ModVanillaCompat;
import cech12.extendedmushrooms.item.crafting.MushroomArrowRecipe;
import cech12.extendedmushrooms.item.crafting.MushroomBrewingRecipe;
import cech12.extendedmushrooms.loot_modifiers.MushroomCapLootModifier;
import cech12.extendedmushrooms.loot_modifiers.MushroomStemLootModifier;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.block.MushroomBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.potion.Potions;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="extendedmushrooms")
@Mod.EventBusSubscriber
public class ExtendedMushrooms {
    public static final String MOD_ID = "extendedmushrooms";
    public static final boolean DEVELOPMENT_MODE = Boolean.parseBoolean(System.getProperty("extendedmushrooms.developmentMode", "false"));

    public ExtendedMushrooms() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.COMMON, "extendedmushrooms-common.toml");
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::clientSetup);
        eventBus.addGenericListener(GlobalLootModifierSerializer.class, this::onRegisterModifierSerializers);
        eventBus.addGenericListener(IRecipeSerializer.class, this::registerRecipeSerializers);
        ModBlocks.registerBlocks(eventBus);
    }

    private void setup(FMLCommonSetupEvent event) {
        ModVanillaCompat.setup();
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new MushroomBrewingRecipe((ITag<Item>)ModTags.ForgeItems.MUSHROOMS_JUMP_BOOSTING, Potions.field_185238_j));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new MushroomBrewingRecipe((ITag<Item>)ModTags.ForgeItems.MUSHROOMS_POISONOUS, Potions.field_185254_z));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new MushroomBrewingRecipe((ITag<Item>)ModTags.ForgeItems.MUSHROOMS_SLOWING_DOWN, Potions.field_185246_r));
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ModBlocks.setupRenderLayers();
        ModEntities.setupRenderers();
        ModTileEntities.setupRenderers(event);
    }

    private void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        CraftingHelper.register((IConditionSerializer)ModFeatureEnabledCondition.Serializer.INSTANCE);
        ExtendedMushroomsRecipeTypes.FAIRY_RING = (IRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)ExtendedMushroomsRecipeTypes.FAIRY_RING_ID, (Object)new IRecipeType<FairyRingRecipe>(){});
        event.getRegistry().register(MushroomArrowRecipe.SERIALIZER);
        event.getRegistry().register((IForgeRegistryEntry)FairyRingRecipe.SERIALIZER);
    }

    public void onRegisterModifierSerializers(@Nonnull RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)new MushroomCapLootModifier.Serializer().setRegistryName(MOD_ID, "mushroom_cap_harvest"));
        event.getRegistry().register((IForgeRegistryEntry)new MushroomStemLootModifier.Serializer().setRegistryName(MOD_ID, "mushroom_stem_harvest"));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBiomeLoadingEvent(BiomeLoadingEvent event) {
        ModEntities.addEntitiesToBiomes(event);
        ModFeatures.addFeaturesToBiomes(event);
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Block strippedBlock;
        BlockState blockState = event.getWorld().func_180495_p(event.getPos());
        ItemStack itemStack = event.getPlayer().func_184586_b(event.getHand());
        if (itemStack.getToolTypes().contains(ToolType.AXE) && (strippedBlock = ModBlocks.BLOCK_STRIPPING_MAP.get(blockState.func_177230_c())) != null) {
            event.getWorld().func_184133_a(event.getPlayer(), event.getPos(), SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!event.getWorld().field_72995_K) {
                BlockState strippedBlockState = strippedBlock.func_176223_P();
                if (blockState.func_235901_b_((Property)HugeMushroomBlock.field_196465_z)) {
                    strippedBlockState = (BlockState)strippedBlockState.func_206870_a((Property)HugeMushroomBlock.field_196465_z, blockState.func_177229_b((Property)HugeMushroomBlock.field_196465_z));
                }
                if (blockState.func_235901_b_((Property)HugeMushroomBlock.field_196460_A)) {
                    strippedBlockState = (BlockState)strippedBlockState.func_206870_a((Property)HugeMushroomBlock.field_196460_A, blockState.func_177229_b((Property)HugeMushroomBlock.field_196460_A));
                }
                if (blockState.func_235901_b_((Property)HugeMushroomBlock.field_196459_a)) {
                    strippedBlockState = (BlockState)strippedBlockState.func_206870_a((Property)HugeMushroomBlock.field_196459_a, blockState.func_177229_b((Property)HugeMushroomBlock.field_196459_a));
                }
                if (blockState.func_235901_b_((Property)HugeMushroomBlock.field_196461_b)) {
                    strippedBlockState = (BlockState)strippedBlockState.func_206870_a((Property)HugeMushroomBlock.field_196461_b, blockState.func_177229_b((Property)HugeMushroomBlock.field_196461_b));
                }
                if (blockState.func_235901_b_((Property)HugeMushroomBlock.field_196463_c)) {
                    strippedBlockState = (BlockState)strippedBlockState.func_206870_a((Property)HugeMushroomBlock.field_196463_c, blockState.func_177229_b((Property)HugeMushroomBlock.field_196463_c));
                }
                if (blockState.func_235901_b_((Property)HugeMushroomBlock.field_196464_y)) {
                    strippedBlockState = (BlockState)strippedBlockState.func_206870_a((Property)HugeMushroomBlock.field_196464_y, blockState.func_177229_b((Property)HugeMushroomBlock.field_196464_y));
                }
                event.getWorld().func_180501_a(event.getPos(), strippedBlockState, 11);
                if (event.getPlayer() != null) {
                    itemStack.func_222118_a(1, (LivingEntity)event.getPlayer(), p_220040_1_ -> p_220040_1_.func_213334_d(event.getHand()));
                }
            }
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.SUCCESS);
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ItemStack itemStack = event.getPlayer().func_184586_b(event.getHand());
        Entity entity = event.getTarget();
        if (entity instanceof MushroomSheepEntity && itemStack.func_77973_b() instanceof DyeItem) {
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.FAIL);
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (((Boolean)Config.SHEEP_EAT_MUSHROOM_FROM_GROUND_ENABLED.get()).booleanValue() && event.getEntity() instanceof SheepEntity) {
            SheepEntity sheep = (SheepEntity)event.getEntity();
            sheep.field_70714_bg.func_75776_a(5, (Goal)new EatMushroomGoal((MobEntity)sheep));
        }
    }

    @SubscribeEvent
    public static void onNeighbourChanged(BlockEvent.NeighborNotifyEvent event) {
        BlockPos blockPos;
        IWorld world = event.getWorld();
        BlockState blockState = world.func_180495_p(blockPos = event.getPos());
        if (blockState.func_177230_c() != ExtendedMushroomsBlocks.FAIRY_RING) {
            for (Direction direction : event.getNotifiedSides()) {
                BlockPos neighbourPos = blockPos.func_177972_a(direction);
                if (world.func_180495_p(neighbourPos).func_177230_c() instanceof MushroomBlock) {
                    FairyRingBlock.fairyRingPlaceCheck(world, neighbourPos);
                    continue;
                }
                if (!(world.func_180495_p(neighbourPos.func_177984_a()).func_177230_c() instanceof MushroomBlock)) continue;
                FairyRingBlock.fairyRingPlaceCheck(world, neighbourPos.func_177984_a());
            }
        }
    }
}

