/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.entityculling;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.logisticscraft.occlusionculling.OcclusionCullingInstance;
import dev.tr7zw.entityculling.Config;
import dev.tr7zw.entityculling.ConfigUpgrader;
import dev.tr7zw.entityculling.CullTask;
import dev.tr7zw.entityculling.Provider;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public abstract class EntityCullingModBase {
    public static EntityCullingModBase instance;
    public OcclusionCullingInstance culling;
    public Set<TileEntityType<?>> blockEntityWhitelist = new HashSet();
    public Set<EntityType<?>> entityWhistelist = new HashSet();
    public Set<EntityType<?>> tickCullWhistelist = new HashSet();
    public boolean debugHitboxes = false;
    public static boolean enabled;
    public CullTask cullTask;
    private Thread cullThread;
    protected KeyBinding keybind = new KeyBinding("key.entityculling.toggle", -1, "EntityCulling");
    protected boolean pressed = false;
    private boolean configKeysLoaded = false;
    private Set<Function<TileEntity, Boolean>> dynamicBlockEntityWhitelist = new HashSet<Function<TileEntity, Boolean>>();
    private Set<Function<Entity, Boolean>> dynamicEntityWhitelist = new HashSet<Function<Entity, Boolean>>();
    public Config config;
    private final File settingsFile = new File("config", "entityculling.json");
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public int renderedBlockEntities = 0;
    public int skippedBlockEntities = 0;
    public int renderedEntities = 0;
    public int skippedEntities = 0;
    public int tickedEntities = 0;
    public int skippedEntityTicks = 0;

    public void onInitialize() {
        instance = this;
        if (this.settingsFile.exists()) {
            try {
                this.config = (Config)this.gson.fromJson(new String(Files.readAllBytes(this.settingsFile.toPath()), StandardCharsets.UTF_8), Config.class);
            }
            catch (Exception ex2) {
                System.out.println("Error while loading config! Creating a new one!");
                ex2.printStackTrace();
            }
        }
        if (this.config == null) {
            this.config = new Config();
            this.writeConfig();
        } else if (ConfigUpgrader.upgradeConfig(this.config)) {
            this.writeConfig();
        }
        this.culling = new OcclusionCullingInstance(this.config.tracingDistance, new Provider());
        this.cullTask = new CullTask(this.culling, this.blockEntityWhitelist, this.entityWhistelist);
        this.cullThread = new Thread((Runnable)this.cullTask, "CullThread");
        this.cullThread.setUncaughtExceptionHandler((thread, ex) -> {
            System.out.println("The CullingThread has crashed! Please report the following stacktrace!");
            ex.printStackTrace();
        });
        this.cullThread.start();
        this.initModloader();
    }

    public void writeConfig() {
        if (this.settingsFile.exists()) {
            this.settingsFile.delete();
        }
        try {
            Files.write(this.settingsFile.toPath(), this.gson.toJson((Object)this.config).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void worldTick() {
        this.cullTask.requestCull = true;
    }

    public void clientTick() {
        if (!this.configKeysLoaded) {
            Optional entity;
            for (String blockId : this.config.blockEntityWhitelist) {
                Optional block = Registry.field_212626_o.func_241873_b(new ResourceLocation(blockId));
                block.ifPresent(b -> this.blockEntityWhitelist.add((TileEntityType<?>)b));
            }
            for (String entityType : this.config.tickCullingWhitelist) {
                entity = Registry.field_212629_r.func_241873_b(new ResourceLocation(entityType));
                entity.ifPresent(e -> this.entityWhistelist.add((EntityType<?>)e));
            }
            for (String entityType : this.config.entityWhitelist) {
                entity = Registry.field_212629_r.func_241873_b(new ResourceLocation(entityType));
                entity.ifPresent(e -> this.entityWhistelist.add((EntityType<?>)e));
            }
        }
        if (this.keybind.func_151470_d()) {
            if (this.pressed) {
                return;
            }
            this.pressed = true;
            enabled = !enabled;
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (enabled) {
                if (player != null) {
                    player.func_145747_a((ITextComponent)new StringTextComponent("Culling on").func_240699_a_(TextFormatting.GREEN), Util.field_240973_b_);
                }
            } else if (player != null) {
                player.func_145747_a((ITextComponent)new StringTextComponent("Culling off").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            }
        } else {
            this.pressed = false;
        }
        this.cullTask.requestCull = true;
    }

    public abstract void initModloader();

    public abstract AxisAlignedBB setupAABB(TileEntity var1, BlockPos var2);

    public boolean isDynamicWhitelisted(TileEntity entity) {
        for (Function<TileEntity, Boolean> fun : this.dynamicBlockEntityWhitelist) {
            if (!fun.apply(entity).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isDynamicWhitelisted(Entity entity) {
        for (Function<Entity, Boolean> fun : this.dynamicEntityWhitelist) {
            if (!fun.apply(entity).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public void addDynamicBlockEntityWhitelist(Function<TileEntity, Boolean> function) {
        this.dynamicBlockEntityWhitelist.add(function);
    }

    public void addDynamicEntityWhitelist(Function<Entity, Boolean> function) {
        this.dynamicEntityWhitelist.add(function);
    }

    static {
        enabled = true;
    }
}

