/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.enhancedcelestials.Main;
import corgitaco.enhancedcelestials.api.client.ColorSettings;
import corgitaco.enhancedcelestials.mixin.access.ColorAccess;
import corgitaco.enhancedcelestials.mixin.access.StyleAccess;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;

public class CodecUtil {
    public static final Codec<ClickEvent.Action> CLICK_EVENT_ACTION_CODEC = Codec.STRING.comapFlatMap(s -> {
        try {
            return DataResult.success((Object)ClickEvent.Action.valueOf((String)s));
        }
        catch (Exception e) {
            Main.LOGGER.error(e.getMessage());
            return DataResult.error((String)e.getMessage());
        }
    }, Enum::name);
    public static final Codec<ClickEvent> CLICK_EVENT_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CLICK_EVENT_ACTION_CODEC.fieldOf("action").forGetter(clickEvent -> clickEvent.func_150669_a()), (App)Codec.STRING.fieldOf("value").forGetter(clickEvent -> clickEvent.func_150668_b())).apply((Applicative)builder, ClickEvent::new));
    public static final Codec<Style> STYLE_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.optionalFieldOf("color", (Object)"").forGetter(style -> style.func_240711_a_() != null ? Integer.toHexString(((ColorAccess)style.func_240711_a_()).getColorRaw()) : Integer.toHexString(TextFormatting.WHITE.func_211163_e())), (App)Codec.BOOL.optionalFieldOf("bold", (Object)false).forGetter(style -> style.func_150223_b()), (App)Codec.BOOL.optionalFieldOf("italic", (Object)false).forGetter(style -> style.func_150242_c()), (App)Codec.BOOL.optionalFieldOf("underlined", (Object)false).forGetter(style -> style.func_150234_e()), (App)Codec.BOOL.optionalFieldOf("strikethrough", (Object)false).forGetter(style -> style.func_150236_d()), (App)Codec.BOOL.optionalFieldOf("obfuscated", (Object)false).forGetter(style -> style.func_150233_f()), (App)CLICK_EVENT_CODEC.optionalFieldOf("clickEvent").forGetter(style -> style.func_150235_h() != null ? Optional.of(style.func_150235_h()) : Optional.empty())).apply((Applicative)builder, (color, bold, italic, underlined, strikethrough, obfuscated, clickEvent) -> StyleAccess.create(ColorAccess.create(ColorSettings.tryParseColor(color)), bold, italic, underlined, strikethrough, obfuscated, clickEvent.orElse(null), null, null, null)));

    public static class LazyCodec<TYPE>
    implements Codec<TYPE> {
        private final Supplier<Codec<TYPE>> delegate;

        public LazyCodec(Supplier<Codec<TYPE>> delegate) {
            this.delegate = delegate;
        }

        public <T> DataResult<T> encode(TYPE input, DynamicOps<T> ops, T prefix) {
            return this.delegate().get().encode(input, ops, prefix);
        }

        public <T> DataResult<Pair<TYPE, T>> decode(DynamicOps<T> ops, T input) {
            return this.delegate().get().decode(ops, input);
        }

        public Supplier<Codec<TYPE>> delegate() {
            return this.delegate;
        }
    }
}

