/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import corgitaco.enhancedcelestials.EnhancedCelestialsWorldData;
import corgitaco.enhancedcelestials.LunarContext;
import corgitaco.enhancedcelestials.LunarEventInstance;
import corgitaco.enhancedcelestials.LunarForecast;
import corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import corgitaco.enhancedcelestials.save.LunarEventSavedData;
import corgitaco.enhancedcelestials.util.CustomTranslationTextComponent;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;

public class LunarForecastCommand {
    public static final TextFormatting[] TEXT_FORMATTINGS = new TextFormatting[]{TextFormatting.WHITE, TextFormatting.BLUE};

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"lunarForecast").executes(cs -> LunarForecastCommand.setLunarEvent((CommandSource)cs.getSource()))).then(Commands.func_197057_a((String)"recompute").executes(cs -> LunarForecastCommand.recompute((CommandSource)cs.getSource())));
    }

    public static int recompute(CommandSource source) {
        ServerWorld world = source.func_197023_e();
        LunarContext lunarContext = ((EnhancedCelestialsWorldData)world).getLunarContext();
        if (lunarContext == null) {
            source.func_197021_a((ITextComponent)new TranslationTextComponent("enhancedcelestials.commands.disabled"));
            return 0;
        }
        LunarForecast lunarForecast = lunarContext.getLunarForecast();
        lunarForecast.getForecast().clear();
        lunarForecast.setLastCheckedGameTime(Long.MIN_VALUE);
        lunarContext.computeLunarForecast(world, lunarForecast, world.func_82737_E());
        LunarEventSavedData.get((IWorld)world).setForecast(lunarContext.getLunarForecast());
        source.func_197030_a((ITextComponent)new TranslationTextComponent("enhancedcelestials.lunarforecast.recompute"), true);
        return 1;
    }

    public static int setLunarEvent(CommandSource source) {
        ServerWorld world = source.func_197023_e();
        LunarContext lunarContext = ((EnhancedCelestialsWorldData)world).getLunarContext();
        if (lunarContext == null) {
            source.func_197021_a((ITextComponent)new TranslationTextComponent("enhancedcelestials.commands.disabled"));
            return 0;
        }
        long dayLength = lunarContext.getLunarTimeSettings().getDayLength();
        long currentDay = world.func_72820_D() / dayLength;
        TranslationTextComponent textComponent = null;
        LunarForecast lunarForecast = lunarContext.getLunarForecast();
        for (int i = Math.min(100, lunarForecast.getForecast().size() - 1); i > 0; --i) {
            LunarEventInstance lunarEventInstance = lunarForecast.getForecast().get(i);
            LunarEvent event = lunarEventInstance.getEvent(lunarContext.getLunarEvents());
            CustomTranslationTextComponent name = event.getTextComponents().getName();
            TextFormatting style = TEXT_FORMATTINGS[i % TEXT_FORMATTINGS.length];
            if (textComponent == null) {
                textComponent = new TranslationTextComponent(name.func_150268_i());
            } else {
                textComponent.func_240702_b_(", ").func_230529_a_((ITextComponent)new TranslationTextComponent(name.func_150268_i()));
            }
            textComponent.func_230529_a_((ITextComponent)new TranslationTextComponent("enhancedcelestials.lunarforecast.days_left", new Object[]{lunarEventInstance.getDaysUntil(currentDay)}));
        }
        if (textComponent != null) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("enhancedcelestials.lunarforecast.header", new Object[]{textComponent.func_240702_b_(".")}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("enhancedcelestials.lunarforecast.empty", new Object[]{textComponent}).func_240699_a_(TextFormatting.YELLOW), true);
        }
        return 1;
    }
}

