/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.network.packet;

import corgitaco.enhancedcelestials.EnhancedCelestialsWorldData;
import corgitaco.enhancedcelestials.LunarContext;
import java.io.IOException;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class LunarContextConstructionPacket {
    private final LunarContext lunarContext;

    public LunarContextConstructionPacket(LunarContext lunarContext) {
        this.lunarContext = lunarContext;
    }

    public static void writeToPacket(LunarContextConstructionPacket packet, PacketBuffer buf) {
        try {
            buf.func_240629_a_(LunarContext.PACKET_CODEC, (Object)packet.lunarContext);
        }
        catch (IOException e) {
            throw new IllegalStateException("Lunar Context packet could not be written to. This is really really bad...\n\n" + e.getMessage());
        }
    }

    public static LunarContextConstructionPacket readFromPacket(PacketBuffer buf) {
        try {
            return new LunarContextConstructionPacket((LunarContext)buf.func_240628_a_(LunarContext.PACKET_CODEC));
        }
        catch (IOException e) {
            throw new IllegalStateException("Lunar Context packet could not be read. This is really really bad...\n\n" + e.getMessage());
        }
    }

    public static void handle(LunarContextConstructionPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                LunarContext lunarContext;
                Minecraft minecraft = Minecraft.func_71410_x();
                ClientWorld world = minecraft.field_71441_e;
                if (world != null && minecraft.field_71439_g != null && (lunarContext = ((EnhancedCelestialsWorldData)world).getLunarContext()) == null) {
                    ((EnhancedCelestialsWorldData)world).setLunarContext(new LunarContext(message.lunarContext.getLunarForecast(), message.lunarContext.getLunarTimeSettings(), world.func_234923_W_().func_240901_a_(), message.lunarContext.getLunarEvents(), true));
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

