/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.mixin;

import corgitaco.enhancedcelestials.EnhancedCelestialsWorldData;
import corgitaco.enhancedcelestials.LunarContext;
import corgitaco.enhancedcelestials.api.lunarevent.LunarMobSpawnInfo;
import corgitaco.enhancedcelestials.mixin.access.ChunkAccess;
import corgitaco.enhancedcelestials.mixin.access.MobSpawnInfoAccess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.List;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WorldEntitySpawner.class})
public class MixinWorldEntitySpawner {
    @Inject(method={"mobsAt"}, at={@At(value="RETURN")}, cancellable=true)
    private static void useLunarSpawner(ServerWorld world, StructureManager structureManager, ChunkGenerator generator, EntityClassification classification, BlockPos pos, Biome biome, CallbackInfoReturnable<List<MobSpawnInfo.Spawners>> cir) {
        LunarMobSpawnInfo lunarSpawner;
        LunarContext lunarContext = ((EnhancedCelestialsWorldData)world).getLunarContext();
        if (lunarContext != null && (lunarSpawner = lunarContext.getCurrentEvent().getLunarSpawner()) != null) {
            MobSpawnInfo mobSpawnInfo = lunarSpawner.getSpawnInfo();
            if (lunarSpawner.useBiomeSpawnSettings()) {
                ArrayList spawners = new ArrayList(mobSpawnInfo.func_242559_a(classification));
                spawners.addAll((Collection)cir.getReturnValue());
                cir.setReturnValue(spawners);
            } else {
                cir.setReturnValue((Object)mobSpawnInfo.func_242559_a(classification));
            }
        }
    }

    @Inject(method={"getRoughBiome"}, at={@At(value="RETURN")}, cancellable=true)
    private static void useLunarSpawner(BlockPos pos, IChunk chunk, CallbackInfoReturnable<Biome> cir) {
        LunarMobSpawnInfo lunarSpawner;
        World world;
        LunarContext lunarContext;
        if (chunk instanceof Chunk && (lunarContext = ((EnhancedCelestialsWorldData)(world = ((ChunkAccess)chunk).getLevel())).getLunarContext()) != null && (lunarSpawner = lunarContext.getCurrentEvent().getLunarSpawner()) != null) {
            MobSpawnInfo lunarMobSpawnInfo = lunarSpawner.getSpawnInfo();
            Biome.Builder fakeBiome = new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.NONE).func_205421_a(0.1f).func_205420_b(0.2f).func_205414_c(0.5f).func_205417_d(0.5f).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_242539_d(1).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_());
            if (lunarSpawner.useBiomeSpawnSettings()) {
                MobSpawnInfo biomeMobSpawnInfo = ((Biome)cir.getReturnValue()).func_242433_b();
                EnumMap<EntityClassification, List<MobSpawnInfo.Spawners>> mergedSpawnersMap = new EnumMap<EntityClassification, List<MobSpawnInfo.Spawners>>(((MobSpawnInfoAccess)biomeMobSpawnInfo).getSpawners());
                mergedSpawnersMap.putAll(((MobSpawnInfoAccess)lunarMobSpawnInfo).getSpawners());
                IdentityHashMap mergedSpawnCosts = new IdentityHashMap(((MobSpawnInfoAccess)biomeMobSpawnInfo).getMobSpawnCosts());
                mergedSpawnCosts.putAll(((MobSpawnInfoAccess)lunarMobSpawnInfo).getMobSpawnCosts());
                MobSpawnInfo mobSpawnInfo = MobSpawnInfoAccess.create(Math.max(lunarMobSpawnInfo.func_242557_a(), biomeMobSpawnInfo.func_242557_a()), mergedSpawnersMap, mergedSpawnCosts, biomeMobSpawnInfo.func_242562_b());
                fakeBiome.func_242458_a(mobSpawnInfo);
            } else {
                fakeBiome.func_242458_a(lunarMobSpawnInfo);
            }
            fakeBiome.func_242457_a(BiomeGenerationSettings.field_242480_b);
            cir.setReturnValue((Object)fakeBiome.func_242455_a());
        }
    }

    @Inject(method={"getRandomPosWithin"}, at={@At(value="RETURN")}, cancellable=true)
    private static void forceSurface(World world, Chunk chunk, CallbackInfoReturnable<BlockPos> cir) {
        BlockPos closestPlayerPosition;
        BlockPos returnValue;
        PlayerEntity closestPlayer;
        LunarMobSpawnInfo lunarSpawner;
        LunarContext lunarContext = ((EnhancedCelestialsWorldData)world).getLunarContext();
        if (lunarContext != null && (lunarSpawner = lunarContext.getCurrentEvent().getLunarSpawner()) != null && lunarSpawner.isForceSurfaceSpawning() && (closestPlayer = world.func_217366_a((double)(returnValue = (BlockPos)cir.getReturnValue()).func_177958_n(), (double)returnValue.func_177956_o(), (double)returnValue.func_177952_p(), -1.0, false)) != null && (closestPlayerPosition = closestPlayer.func_233580_cy_()).func_177956_o() > world.func_201676_a(Heightmap.Type.WORLD_SURFACE, closestPlayerPosition.func_177958_n(), closestPlayerPosition.func_177952_p())) {
            cir.setReturnValue((Object)new BlockPos(returnValue.func_177958_n(), world.func_201676_a(Heightmap.Type.WORLD_SURFACE, returnValue.func_177958_n(), returnValue.func_177952_p()) + 1, returnValue.func_177952_p()));
        }
    }
}

