/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.lunarevent;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.enhancedcelestials.Main;
import corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import corgitaco.enhancedcelestials.api.lunarevent.LunarTextComponents;
import corgitaco.enhancedcelestials.api.lunarevent.client.LunarEventClientSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.server.ServerWorld;

public class HarvestMoon
extends LunarEvent {
    public static final Codec<HarvestMoon> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)LunarEventClientSettings.CODEC.fieldOf("clientSettings").forGetter(clientSettings -> clientSettings.getClientSettings()), (App)Codec.INT.fieldOf("minNumberOfNightsBetween").forGetter(clientSettings -> clientSettings.getMinNumberOfNightsBetween()), (App)Codec.DOUBLE.fieldOf("chance").forGetter(clientSettings -> clientSettings.getChance()), (App)Codec.list((Codec)Codec.INT).fieldOf("validMoonPhases").forGetter(clientSettings -> new ArrayList<Integer>(clientSettings.getValidMoonPhases())), (App)LunarTextComponents.CODEC.fieldOf("textComponents").forGetter(blueMoon -> blueMoon.getTextComponents()), (App)Codec.BOOL.fieldOf("blockSleeping").forGetter(clientSettings -> clientSettings.blockSleeping()), (App)Codec.list((Codec)ResourceLocation.field_240908_a_).fieldOf("enhancedCrops").forGetter(clientSettings -> new ArrayList<ResourceLocation>(clientSettings.cropTags)), (App)Codec.DOUBLE.fieldOf("cropDropMultiplier").orElse((Object)2.5).forGetter(clientSettings -> clientSettings.cropDropMultiplier)).apply((Applicative)builder, HarvestMoon::new));
    private final List<Object> enhancedCrops = new ArrayList<Object>();
    private final Collection<ResourceLocation> cropTags;
    private final double cropDropMultiplier;

    public HarvestMoon(LunarEventClientSettings clientSettings, int minNumberOfNightsBetween, double chance, Collection<Integer> validMoonPhases, LunarTextComponents lunarTextComponents, boolean blockSleeping, Collection<ResourceLocation> cropTags, double cropDropMultiplier) {
        this(clientSettings, minNumberOfNightsBetween, chance, validMoonPhases, lunarTextComponents, blockSleeping, cropTags, cropDropMultiplier, true);
    }

    public HarvestMoon(LunarEventClientSettings clientSettings, int minNumberOfNightsBetween, double chance, Collection<Integer> validMoonPhases, LunarTextComponents lunarTextComponents, boolean blockSleeping, Collection<ResourceLocation> cropTags, double cropDropMultiplier, boolean serializeCrops) {
        super(clientSettings, minNumberOfNightsBetween, chance, validMoonPhases, lunarTextComponents, blockSleeping);
        this.cropTags = cropTags;
        this.cropDropMultiplier = cropDropMultiplier;
        if (serializeCrops) {
            for (ResourceLocation tagID : cropTags) {
                if (tagID.func_110623_a().contains("item_tag_")) {
                    tagID = new ResourceLocation(tagID.func_110624_b(), tagID.func_110623_a().replace("item_tag_", ""));
                    Map allTags = ItemTags.func_199903_a().func_241833_a();
                    if (allTags.containsKey(tagID)) {
                        this.enhancedCrops.add(allTags.get(tagID));
                        continue;
                    }
                    Main.LOGGER.error("\"" + tagID + "\" is not a valid item tag!");
                    continue;
                }
                Optional optional = Registry.field_212630_s.func_241873_b(tagID = new ResourceLocation(tagID.func_110624_b(), tagID.func_110623_a()));
                if (optional.isPresent()) {
                    this.enhancedCrops.add(optional.get());
                    continue;
                }
                Main.LOGGER.error("\"" + tagID + "\" is not a valid item ID!");
            }
        }
    }

    @Override
    public void onBlockItemDrop(ServerWorld world, ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        for (Object enhancedCrop : this.enhancedCrops) {
            if (enhancedCrop instanceof ITag) {
                if (!((ITag)enhancedCrop).func_230235_a_((Object)item)) continue;
                itemStack.func_190920_e((int)((double)itemStack.func_190916_E() * this.cropDropMultiplier));
                break;
            }
            if (!(enhancedCrop instanceof Item) || enhancedCrop != item) continue;
            itemStack.func_190920_e((int)((double)itemStack.func_190916_E() * this.cropDropMultiplier));
            break;
        }
        super.onBlockItemDrop(world, itemStack);
    }

    @Override
    public Codec<? extends LunarEvent> codec() {
        return CODEC;
    }
}

