/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.api.lunarevent;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.enhancedcelestials.util.CustomTranslationTextComponent;
import javax.annotation.Nullable;
import net.minecraft.util.IStringSerializable;

public class LunarTextComponents {
    public static final Codec<LunarTextComponents> LEGACY_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CustomTranslationTextComponent.CODEC.fieldOf("name").forGetter(textComponents -> textComponents.name), (App)CustomTranslationTextComponent.CODEC.optionalFieldOf("startNotification", (Object)CustomTranslationTextComponent.DEFAULT).forGetter(clientSettings -> clientSettings.riseNotification.getCustomTranslationTextComponent()), (App)CustomTranslationTextComponent.CODEC.optionalFieldOf("endNotification", (Object)CustomTranslationTextComponent.DEFAULT).forGetter(clientSettings -> clientSettings.setNotification.getCustomTranslationTextComponent())).apply((Applicative)builder, LunarTextComponents::new));
    public static final Codec<LunarTextComponents> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CustomTranslationTextComponent.CODEC.fieldOf("name").forGetter(textComponents -> textComponents.name), (App)Codec.either(CustomTranslationTextComponent.CODEC, Notification.CODEC).xmap(e -> (Notification)e.map(textComponent -> new Notification((CustomTranslationTextComponent)((Object)((Object)((Object)textComponent))), NotificationType.CHAT), notification -> notification), Either::right).optionalFieldOf("startNotification", (Object)Notification.DEFAULT).forGetter(clientSettings -> clientSettings.riseNotification), (App)Codec.either(CustomTranslationTextComponent.CODEC, Notification.CODEC).xmap(e -> (Notification)e.map(textComponent -> new Notification((CustomTranslationTextComponent)((Object)((Object)((Object)textComponent))), NotificationType.CHAT), notification -> notification), Either::right).optionalFieldOf("endNotification", (Object)Notification.DEFAULT).forGetter(clientSettings -> clientSettings.setNotification)).apply((Applicative)builder, LunarTextComponents::new));
    private final CustomTranslationTextComponent name;
    @Nullable
    private final Notification riseNotification;
    @Nullable
    private final Notification setNotification;

    public LunarTextComponents(CustomTranslationTextComponent name, CustomTranslationTextComponent startNotificationComponent, CustomTranslationTextComponent endNotificationComponent) {
        this(name, new Notification(startNotificationComponent, NotificationType.CHAT), new Notification(endNotificationComponent, NotificationType.CHAT));
    }

    public LunarTextComponents(CustomTranslationTextComponent name, Notification riseNotification, Notification setNotification) {
        this.name = name;
        this.riseNotification = riseNotification == Notification.DEFAULT || riseNotification.customTranslationTextComponent.func_150268_i().isEmpty() ? null : riseNotification;
        this.setNotification = setNotification == Notification.DEFAULT || setNotification.customTranslationTextComponent.func_150268_i().isEmpty() ? null : setNotification;
    }

    public CustomTranslationTextComponent getName() {
        return this.name;
    }

    @Nullable
    public Notification getRiseNotification() {
        return this.riseNotification;
    }

    @Nullable
    public Notification getSetNotification() {
        return this.setNotification;
    }

    public static enum NotificationType implements IStringSerializable
    {
        CHAT,
        HOT_BAR;

        public static final Codec<NotificationType> CODEC;

        public static NotificationType byName(String name) {
            return NotificationType.valueOf(name.toUpperCase());
        }

        public String func_176610_l() {
            return this.name();
        }

        static {
            CODEC = IStringSerializable.func_233023_a_(NotificationType::values, NotificationType::byName);
        }
    }

    public static class Notification {
        public static final Notification DEFAULT = new Notification(CustomTranslationTextComponent.DEFAULT, NotificationType.CHAT);
        public static final Codec<Notification> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CustomTranslationTextComponent.CODEC.fieldOf("component").forGetter(notification -> notification.customTranslationTextComponent), (App)NotificationType.CODEC.fieldOf("type").forGetter(notification -> notification.notificationType)).apply((Applicative)builder, Notification::new));
        private final CustomTranslationTextComponent customTranslationTextComponent;
        private final NotificationType notificationType;

        public Notification(CustomTranslationTextComponent customTranslationTextComponent, NotificationType notificationType) {
            this.customTranslationTextComponent = customTranslationTextComponent;
            this.notificationType = notificationType;
        }

        public CustomTranslationTextComponent getCustomTranslationTextComponent() {
            return this.customTranslationTextComponent;
        }

        public NotificationType getNotificationType() {
            return this.notificationType;
        }
    }
}

