/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.common.items;

import com.minecraftabnormals.abnormals_core.core.util.item.ItemStackUtil;
import com.minecraftabnormals.endergetic.common.entities.booflo.BoofloEntity;
import com.minecraftabnormals.endergetic.common.entities.puffbug.PuffBugEntity;
import com.minecraftabnormals.endergetic.core.registry.EEEntities;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PuffBugBottleItem
extends Item {
    public PuffBugBottleItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        ItemStack itemstack = context.func_195996_i();
        BlockPos blockpos = context.func_195995_a();
        Direction direction = context.func_196000_l();
        BlockState blockstate = world.func_180495_p(blockpos);
        BlockPos blockpos1 = blockstate.func_196952_d((IBlockReader)world, blockpos).func_197766_b() ? blockpos : blockpos.func_177972_a(direction);
        EntityType entitytype = (EntityType)EEEntities.PUFF_BUG.get();
        if (entitytype.func_220331_a((ServerWorld)world, itemstack, context.func_195999_j(), blockpos1, SpawnReason.BUCKET, true, !Objects.equals(blockpos, blockpos1) && direction == Direction.UP) != null) {
            this.emptyBottle(context.func_195999_j(), context.func_221531_n());
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        BoofloEntity booflo;
        World world = player.field_70170_p;
        if (world instanceof ServerWorld && target instanceof BoofloEntity && !(booflo = (BoofloEntity)target).hasCaughtFruit() && !booflo.hasCaughtPuffBug() && booflo.isTamed()) {
            PuffBugEntity puffbug = (PuffBugEntity)((EntityType)EEEntities.PUFF_BUG.get()).func_200721_a(world);
            if (puffbug != null) {
                puffbug.func_70107_b(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
                EntityType.func_208048_a((World)world, (PlayerEntity)player, (Entity)puffbug, (CompoundNBT)stack.func_196082_o());
                puffbug.func_213386_a((IServerWorld)((ServerWorld)world), world.func_175649_E(puffbug.func_233580_cy_()), SpawnReason.BUCKET, null, stack.func_196082_o());
                world.func_217376_c((Entity)puffbug);
                booflo.catchPuffBug(puffbug);
                if (!player.field_71075_bZ.field_75098_d) {
                    this.emptyBottle(player, hand);
                }
            }
            return ActionResultType.CONSUME;
        }
        return super.func_111207_a(stack, player, target, hand);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            return new ActionResult(ActionResultType.PASS, (Object)itemstack);
        }
        BlockRayTraceResult raytraceresult = PuffBugBottleItem.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return new ActionResult(ActionResultType.PASS, (Object)itemstack);
        }
        BlockRayTraceResult blockraytraceresult = raytraceresult;
        BlockPos blockpos = blockraytraceresult.func_216350_a();
        if (!(worldIn.func_180495_p(blockpos).func_177230_c() instanceof FlowingFluidBlock)) {
            return new ActionResult(ActionResultType.PASS, (Object)itemstack);
        }
        if (worldIn.func_175660_a(playerIn, blockpos) && playerIn.func_175151_a(blockpos, blockraytraceresult.func_216354_b(), itemstack)) {
            EntityType entitytype = (EntityType)EEEntities.PUFF_BUG.get();
            if (entitytype.func_220331_a((ServerWorld)worldIn, itemstack, playerIn, blockpos, SpawnReason.SPAWN_EGG, false, false) == null) {
                return new ActionResult(ActionResultType.PASS, (Object)itemstack);
            }
            if (!playerIn.field_71075_bZ.field_75098_d) {
                this.emptyBottle(playerIn, handIn);
            }
            playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("CustomPotionEffects")) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.endergetic.activePotions").func_240699_a_(TextFormatting.DARK_PURPLE));
            for (EffectInstance effects : PotionUtils.func_185192_b((CompoundNBT)nbt)) {
                TextFormatting[] potionTextFormat = new TextFormatting[]{TextFormatting.ITALIC, this.getEffectTextColor(effects)};
                tooltip.add((ITextComponent)new StringTextComponent(" " + I18n.func_135052_a((String)effects.func_76453_d(), (Object[])new Object[0]) + " " + ItemStackUtil.intToRomanNumerals((int)(effects.func_76458_c() + 1))).func_240701_a_(potionTextFormat));
            }
        }
    }

    private TextFormatting getEffectTextColor(EffectInstance effect) {
        Map map = effect.func_188419_a().func_111186_k();
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                AttributeModifier entryValue = (AttributeModifier)entry.getValue();
                AttributeModifier modifier = new AttributeModifier(entryValue.func_111166_b(), effect.func_188419_a().func_111183_a(effect.func_76458_c(), entryValue), entryValue.func_220375_c());
                if (!(modifier.func_111164_d() <= 0.0)) continue;
                return TextFormatting.RED;
            }
        }
        return effect.func_188419_a().func_188408_i() ? TextFormatting.BLUE : TextFormatting.RED;
    }

    private void emptyBottle(PlayerEntity player, Hand hand) {
        if (!player.func_184812_l_()) {
            EquipmentSlotType slot = hand == Hand.MAIN_HAND ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND;
            player.func_184201_a(slot, new ItemStack((IItemProvider)Items.field_151069_bo));
        }
    }

    public static class PuffBugBottleDispenseBehavior
    extends DefaultDispenseItemBehavior {
        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            Direction direction = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
            if (!source.func_197524_h().func_180495_p(source.func_180699_d().func_177972_a(direction)).func_196952_d((IBlockReader)source.func_197524_h(), source.func_180699_d().func_177972_a(direction)).func_197766_b()) {
                return super.func_82487_b(source, stack);
            }
            EntityType entitytype = (EntityType)EEEntities.PUFF_BUG.get();
            entitytype.func_220331_a(source.func_197524_h(), stack, null, source.func_180699_d().func_177972_a(direction), SpawnReason.DISPENSER, direction != Direction.UP, false);
            stack = new ItemStack((IItemProvider)Items.field_151069_bo);
            return stack;
        }
    }
}

