/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.common.entities.bolloom;

import com.minecraftabnormals.endergetic.common.blocks.poise.BolloomBudBlock;
import com.minecraftabnormals.endergetic.common.entities.bolloom.AbstractBolloomEntity;
import com.minecraftabnormals.endergetic.core.registry.EEBlocks;
import com.minecraftabnormals.endergetic.core.registry.EEEntities;
import com.minecraftabnormals.endergetic.core.registry.EEItems;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;

public class BolloomFruitEntity
extends AbstractBolloomEntity {
    private static final DataParameter<BlockPos> BUD_POS = EntityDataManager.func_187226_a(BolloomFruitEntity.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Integer> VINE_HEIGHT = EntityDataManager.func_187226_a(BolloomFruitEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public BolloomFruitEntity(EntityType<? extends BolloomFruitEntity> type, World world) {
        super((EntityType)EEEntities.BOLLOOM_FRUIT.get(), world);
        this.func_189654_d(true);
    }

    public BolloomFruitEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this((EntityType<? extends BolloomFruitEntity>)((EntityType)EEEntities.BOLLOOM_FRUIT.get()), world);
    }

    public BolloomFruitEntity(World world, BlockPos budPos, BlockPos origin, int height, Direction direction) {
        this((EntityType<? extends BolloomFruitEntity>)((EntityType)EEEntities.BOLLOOM_FRUIT.get()), world);
        float xPos = (float)origin.func_177958_n() + 0.5f + (direction.func_176740_k() == Direction.Axis.Z ? 0.0f : -0.2f * (float)direction.func_176743_c().func_179524_a());
        float zPos = (float)origin.func_177952_p() + 0.5f + (direction.func_176740_k() == Direction.Axis.X ? 0.0f : -0.2f * (float)direction.func_176743_c().func_179524_a());
        float yPos = (float)origin.func_177956_o() + 1.15f;
        this.func_70107_b(xPos, yPos, zPos);
        this.setOrigin(xPos, yPos, zPos);
        this.setBudPos(budPos);
        this.setVineHeight(height);
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VINE_HEIGHT, (Object)1);
        this.field_70180_af.func_187214_a(BUD_POS, (Object)BlockPos.field_177992_a);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74772_a("BudPosition", this.getBudPos().func_218275_a());
        compound.func_74768_a("VineHeight", this.getVineHeight());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setBudPos(BlockPos.func_218283_e((long)compound.func_74763_f("BudPosition")));
        if (compound.func_150297_b("VineHeight", 3)) {
            this.setVineHeight(compound.func_74762_e("VineHeight"));
        } else {
            this.setVineHeight(1);
        }
    }

    private void setBudPos(BlockPos budPos) {
        this.field_70180_af.func_187227_b(BUD_POS, (Object)budPos);
    }

    private BlockPos getBudPos() {
        return (BlockPos)this.field_70180_af.func_187225_a(BUD_POS);
    }

    @Override
    public float getVineAngle() {
        return (float)Math.atan(this.getSway() / (float)this.getVineHeight());
    }

    public void setVineHeight(int height) {
        this.field_70180_af.func_187227_b(VINE_HEIGHT, (Object)height);
    }

    public int getVineHeight() {
        return (Integer)this.field_70180_af.func_187225_a(VINE_HEIGHT);
    }

    @Override
    public void updatePositionAndMotion(double angleX, double angleZ) {
        if (!this.isUntied()) {
            this.func_70107_b((double)this.getOriginX() + (double)this.getSway() * angleX, this.getOriginY(), (double)this.getOriginZ() + (double)this.getSway() * angleZ);
        } else {
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213293_j(angleX * (double)0.05f, 0.07f, angleZ * (double)0.05f);
        }
    }

    @Override
    public void updateUntied() {
        BlockPos budPos = this.getBudPos();
        if (this.field_70170_p.isAreaLoaded(budPos, 1) && (this.field_70170_p.func_180495_p(budPos).func_177230_c() != EEBlocks.BOLLOOM_BUD.get() || !((Boolean)this.field_70170_p.func_180495_p(budPos).func_177229_b((Property)BolloomBudBlock.OPENED)).booleanValue())) {
            this.setUntied(true);
        }
        if (!this.isOpenPathBelowFruit()) {
            this.setUntied(true);
        }
    }

    @Override
    public void onBroken(boolean dropFruit) {
        super.onBroken(dropFruit);
        if (dropFruit) {
            Block.func_180635_a((World)this.field_70170_p, (BlockPos)this.func_233580_cy_(), (ItemStack)new ItemStack((IItemProvider)EEItems.BOLLOOM_FRUIT.get()));
        }
    }

    public boolean isOpenPathBelowFruit() {
        BlockPos.Mutable mutable = this.func_233580_cy_().func_239590_i_();
        for (int i = 0; i < this.getVineHeight(); ++i) {
            BlockPos pos = mutable.func_177979_c(i);
            if (!this.field_70170_p.isAreaLoaded(pos, 1) || this.field_70170_p.func_180495_p(pos).func_196958_f()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)EEItems.BOLLOOM_FRUIT.get());
    }

    public void func_70108_f(Entity entity) {
        if (entity instanceof BolloomFruitEntity) {
            if (entity.func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e) {
                super.func_70108_f(entity);
            }
        } else if (entity.func_226278_cu_() >= this.func_174813_aQ().field_72338_b) {
            super.func_70108_f(entity);
        }
    }

    public boolean func_70112_a(double distance) {
        return true;
    }

    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }
}

