/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.common.entities.bolloom;

import com.minecraftabnormals.endergetic.api.entity.util.EntityItemStackHelper;
import com.minecraftabnormals.endergetic.common.entities.bolloom.AbstractBolloomEntity;
import com.minecraftabnormals.endergetic.common.entities.bolloom.BalloonColor;
import com.minecraftabnormals.endergetic.common.entities.bolloom.BolloomKnotEntity;
import com.minecraftabnormals.endergetic.core.EndergeticExpansion;
import com.minecraftabnormals.endergetic.core.interfaces.BalloonHolder;
import com.minecraftabnormals.endergetic.core.interfaces.CustomBalloonPositioner;
import com.minecraftabnormals.endergetic.core.registry.EEEntities;
import com.minecraftabnormals.endergetic.core.registry.other.EEDataSerializers;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.FMLPlayMessages;

public class BolloomBalloonEntity
extends AbstractBolloomEntity {
    private static final DataParameter<Optional<UUID>> KNOT_UNIQUE_ID = EntityDataManager.func_187226_a(BolloomBalloonEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<BlockPos> FENCE_POS = EntityDataManager.func_187226_a(BolloomBalloonEntity.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<BalloonColor> COLOR = EntityDataManager.func_187226_a(BolloomBalloonEntity.class, EEDataSerializers.BALLOON_COLOR);
    public boolean hasModifiedBoatOrder;
    @Nullable
    private Entity attachedEntity;
    @Nullable
    private UUID attachedEntityUUID;

    public BolloomBalloonEntity(EntityType<? extends BolloomBalloonEntity> entityType, World world) {
        super(entityType, world);
    }

    public BolloomBalloonEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this((EntityType<? extends BolloomBalloonEntity>)((EntityType)EEEntities.BOLLOOM_BALLOON.get()), world);
    }

    public BolloomBalloonEntity(World world, UUID ownerKnot, BlockPos pos, float offset) {
        this((EntityType<? extends BolloomBalloonEntity>)((EntityType)EEEntities.BOLLOOM_BALLOON.get()), world);
        float posX = (float)pos.func_177958_n() + 0.5f + (this.field_70146_Z.nextBoolean() ? -offset : offset);
        float posY = pos.func_177956_o() + 3;
        float posZ = (float)pos.func_177952_p() + 0.5f + (this.field_70146_Z.nextBoolean() ? -offset : offset);
        this.func_70107_b(posX, posY, posZ);
        this.setOrigin(posX, posY, posZ);
        this.field_70169_q = posX;
        this.field_70167_r = posY;
        this.field_70166_s = posZ;
        this.setFencePos(pos);
        this.setKnotId(ownerKnot);
    }

    public BolloomBalloonEntity(World world, BlockPos pos) {
        this((EntityType<? extends BolloomBalloonEntity>)((EntityType)EEEntities.BOLLOOM_BALLOON.get()), world);
        float posX = (float)pos.func_177958_n() + 0.5f;
        float posY = pos.func_177956_o();
        float posZ = (float)pos.func_177952_p() + 0.5f;
        this.func_70107_b(posX, posY, posZ);
        this.setOrigin(posX, posY, posZ);
        this.field_70169_q = posX;
        this.field_70167_r = posY;
        this.field_70166_s = posZ;
        this.setUntied(true);
        this.setDesiredAngle((float)(this.field_70146_Z.nextDouble() * 2.0 * Math.PI));
        this.setAngle((float)(this.field_70146_Z.nextDouble() * 2.0 * Math.PI));
    }

    @Override
    public void func_70071_h_() {
        if (this.isAttachedToEntity() && (!this.attachedEntity.func_70089_S() || this.attachedEntity.func_175149_v())) {
            this.detachFromEntity();
        } else if (!this.field_70170_p.field_72995_K && this.attachedEntityUUID != null) {
            Entity entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.attachedEntityUUID);
            if (entity != null) {
                this.attachToEntity(entity);
            } else {
                EndergeticExpansion.LOGGER.warn("Could not find entity the balloon was attached to with UUID: {}", (Object)this.attachedEntityUUID);
            }
            this.attachedEntityUUID = null;
        }
        super.func_70071_h_();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(KNOT_UNIQUE_ID, Optional.empty());
        this.field_70180_af.func_187214_a(FENCE_POS, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(COLOR, (Object)BalloonColor.DEFAULT);
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.getKnotId() != null) {
            compound.func_186854_a("KnotUUID", this.getKnotId());
        }
        compound.func_74772_a("FENCE_POS", this.getFencePos().func_218275_a());
        compound.func_74774_a("Color", (byte)this.getColor().ordinal());
        if (this.isAttachedToEntity() && !(this.attachedEntity instanceof PlayerEntity)) {
            compound.func_218657_a("Pos", (INBT)this.func_70087_a(new double[]{this.attachedEntity.func_226277_ct_(), this.attachedEntity.func_226278_cu_(), this.attachedEntity.func_226281_cx_()}));
            compound.func_186854_a("AttachedUUID", this.attachedEntity.func_110124_au());
        }
    }

    @Override
    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setKnotId(compound.func_74764_b("KnotUUID") ? compound.func_186857_a("KnotUUID") : null);
        this.setFencePos(BlockPos.func_218283_e((long)compound.func_74763_f("FENCE_POS")));
        this.setColor(BalloonColor.byOrdinal(compound.func_74771_c("Color")));
        if (compound.func_186855_b("AttachedUUID")) {
            this.attachedEntityUUID = compound.func_186857_a("AttachedUUID");
        }
    }

    public void setKnotId(@Nullable UUID knotUUID) {
        this.field_70180_af.func_187227_b(KNOT_UNIQUE_ID, Optional.ofNullable(knotUUID));
    }

    @Nullable
    public UUID getKnotId() {
        return ((Optional)this.field_70180_af.func_187225_a(KNOT_UNIQUE_ID)).orElse(null);
    }

    @Nullable
    public Entity getKnot() {
        return ((ServerWorld)this.field_70170_p).func_217461_a(this.getKnotId());
    }

    private void setFencePos(BlockPos fencePos) {
        this.field_70180_af.func_187227_b(FENCE_POS, (Object)fencePos);
    }

    private BlockPos getFencePos() {
        return (BlockPos)this.field_70180_af.func_187225_a(FENCE_POS);
    }

    public BalloonColor getColor() {
        return (BalloonColor)((Object)this.field_70180_af.func_187225_a(COLOR));
    }

    public void setColor(BalloonColor color) {
        this.field_70180_af.func_187227_b(COLOR, (Object)color);
    }

    public void attachToEntity(Entity entity) {
        this.attachedEntity = entity;
        if (entity instanceof CustomBalloonPositioner) {
            ((CustomBalloonPositioner)entity).onBalloonAttached(this);
        }
        ((BalloonHolder)entity).attachBalloon(this);
    }

    public void detachFromEntity() {
        if (this.attachedEntity != null) {
            ((BalloonHolder)this.attachedEntity).detachBalloon(this);
            if (this.attachedEntity instanceof CustomBalloonPositioner) {
                ((CustomBalloonPositioner)this.attachedEntity).onBalloonDetached(this);
            }
            this.attachedEntity = null;
        }
    }

    @Nullable
    public Entity getAttachedEntity() {
        return this.attachedEntity;
    }

    public boolean isAttachedToEntity() {
        return this.attachedEntity != null;
    }

    public void updateAttachedPosition() {
        this.func_213317_d(Vector3d.field_186680_a);
        if (this.canUpdate()) {
            this.func_70071_h_();
            this.incrementTicksExisted();
            if (this.attachedEntity instanceof CustomBalloonPositioner) {
                ((CustomBalloonPositioner)this.attachedEntity).updateAttachedPosition(this);
            } else if (this.attachedEntity != null) {
                this.func_70107_b(this.attachedEntity.func_226277_ct_() + (double)(this.getSway() * MathHelper.func_76126_a((float)(-this.getAngle()))), this.attachedEntity.func_226278_cu_() + this.func_70042_X() + (double)this.attachedEntity.func_70047_e(), this.attachedEntity.func_226281_cx_() + (double)(this.getSway() * MathHelper.func_76134_b((float)(-this.getAngle()))));
            }
        }
    }

    @Override
    public void updatePositionAndMotion(double angleX, double angleZ) {
        if (this.field_70170_p.isAreaLoaded(this.func_233580_cy_(), 1)) {
            if (!this.isUntied()) {
                this.func_70107_b((double)this.getOriginX() + (double)this.getSway() * angleX, this.getOriginY(), (double)this.getOriginZ() + (double)this.getSway() * angleZ);
            } else if (!this.isAttachedToEntity()) {
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                this.func_213293_j(angleX * (double)0.05f, 0.07f, angleZ * (double)0.05f);
            }
        }
    }

    @Override
    public void updateUntied() {
        BolloomKnotEntity knotEntity;
        if (this.field_70170_p.isAreaLoaded(this.getFencePos(), 1) && !this.isUntied() && !this.field_70170_p.func_180495_p(this.getFencePos()).func_177230_c().func_203417_a((ITag)BlockTags.field_219748_G)) {
            if (!this.field_70170_p.field_72995_K && this.getKnot() != null) {
                knotEntity = (BolloomKnotEntity)this.getKnot();
                knotEntity.setBalloonsTied(knotEntity.getBalloonsTied() - 1);
            }
            this.setUntied(true);
        }
        if (this.isAttachmentBlocked()) {
            if (!this.field_70170_p.field_72995_K && this.getKnot() != null && !this.isUntied()) {
                knotEntity = (BolloomKnotEntity)this.getKnot();
                knotEntity.setBalloonsTied(knotEntity.getBalloonsTied() - 1);
            }
            this.setUntied(true);
        }
    }

    @Override
    public boolean shouldIncrementTicksExisted() {
        return !this.isAttachedToEntity();
    }

    @Override
    public void onBroken(boolean dropFruit) {
        super.onBroken(dropFruit);
        Entity knot = this.getKnot();
        if (knot instanceof BolloomKnotEntity) {
            BolloomKnotEntity bolloomKnot = (BolloomKnotEntity)knot;
            bolloomKnot.setBalloonsTied(bolloomKnot.getBalloonsTied() - 1);
        }
    }

    public boolean isAttachmentBlocked() {
        BlockPos.Mutable mutable = this.getFencePos().func_177981_b(3).func_239590_i_();
        for (int i = 0; i < 3; ++i) {
            BlockPos pos = mutable.func_177979_c(i);
            if (!this.field_70170_p.isAreaLoaded(pos, 1) || this.field_70170_p.func_180495_p(pos).func_185904_a().func_76222_j() && this.field_70170_p.func_180495_p(pos).func_177230_c() != Blocks.field_150353_l) continue;
            return true;
        }
        return false;
    }

    public void func_174812_G() {
        Entity knot;
        if (!this.field_70170_p.field_72995_K && (knot = this.getKnot()) instanceof BolloomKnotEntity) {
            BolloomKnotEntity bolloomKnot = (BolloomKnotEntity)knot;
            bolloomKnot.setBalloonsTied(bolloomKnot.getBalloonsTied() - 1);
        }
        super.func_174812_G();
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() instanceof DyeItem && this.getColor().color != ((DyeItem)itemstack.func_77973_b()).func_195962_g()) {
            if (!this.field_70170_p.field_72995_K) {
                this.setColor(BalloonColor.byDyeColor(((DyeItem)itemstack.func_77973_b()).func_195962_g()));
                EntityItemStackHelper.consumeItemFromStack(player, itemstack);
            }
            return ActionResultType.CONSUME;
        }
        return super.func_184199_a(player, vec, hand);
    }

    public double func_70042_X() {
        return 1.75;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)this.getColor().balloonItem.get());
    }

    public boolean func_70112_a(double distance) {
        if (this.isAttachedToEntity()) {
            return this.attachedEntity.func_70112_a(distance);
        }
        return super.func_70112_a(distance);
    }
}

