/*
 * Decompiled with CFR 0.152.
 */
package me.lambdaurora.lambdynlights.mixin;

import me.lambdaurora.lambdynlights.DynamicLightSource;
import me.lambdaurora.lambdynlights.DynamicLightsReforged;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={PlayerEntity.class})
public abstract class PlayerEntityMixin
extends LivingEntity
implements DynamicLightSource {
    private int lambdynlights_luminance;
    private World lambdynlights_lastWorld;

    @Shadow
    public abstract boolean func_175149_v();

    protected PlayerEntityMixin(EntityType<? extends LivingEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    public void dynamicLightTick() {
        if (this.func_70027_ad() || this.func_225510_bt_()) {
            this.lambdynlights_luminance = 15;
        } else {
            int luminance = 0;
            BlockPos eyePos = new BlockPos(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
            boolean submergedInFluid = !this.field_70170_p.func_204610_c(eyePos).func_206888_e();
            for (ItemStack equipped : this.func_184209_aF()) {
                if (equipped.func_190926_b()) continue;
                luminance = Math.max(luminance, DynamicLightsReforged.getLuminanceFromItemStack(equipped, submergedInFluid));
            }
            this.lambdynlights_luminance = luminance;
        }
        if (this.func_175149_v()) {
            this.lambdynlights_luminance = 0;
        }
        if (this.lambdynlights_lastWorld != this.func_130014_f_()) {
            this.lambdynlights_lastWorld = this.func_130014_f_();
            this.lambdynlights_luminance = 0;
        }
    }

    @Override
    public int getLuminance() {
        return this.lambdynlights_luminance;
    }
}

