/*
 * Decompiled with CFR 0.152.
 */
package me.lambdaurora.lambdynlights.mixin;

import me.lambdaurora.lambdynlights.DynamicLightSource;
import me.lambdaurora.lambdynlights.DynamicLightsReforged;
import me.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import me.lambdaurora.lambdynlights.config.DynamicLightsConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements DynamicLightSource {
    private int lambdynlights_luminance;

    public LivingEntityMixin(EntityType<?> type, World world) {
        super(type, world);
    }

    @Override
    public void dynamicLightTick() {
        int luminance;
        if (this.func_70027_ad() || this.func_225510_bt_()) {
            this.lambdynlights_luminance = 15;
        } else {
            luminance = 0;
            BlockPos eyePos = new BlockPos(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
            boolean submergedInFluid = !this.field_70170_p.func_204610_c(eyePos).func_206888_e();
            for (ItemStack equipped : this.func_184209_aF()) {
                if (equipped.func_190926_b()) continue;
                luminance = Math.max(luminance, DynamicLightsReforged.getLuminanceFromItemStack(equipped, submergedInFluid));
            }
            this.lambdynlights_luminance = luminance;
        }
        luminance = DynamicLightHandlers.getLuminanceFrom(this);
        if (luminance > this.lambdynlights_luminance) {
            this.lambdynlights_luminance = luminance;
        }
        if (!((Boolean)DynamicLightsConfig.EntityLighting.get()).booleanValue() && this.func_200600_R() != EntityType.field_200729_aH) {
            this.lambdynlights_luminance = 0;
        }
    }

    @Override
    public int getLuminance() {
        return this.lambdynlights_luminance;
    }
}

