/*
 * Decompiled with CFR 0.152.
 */
package me.lambdaurora.lambdynlights.api.item;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.lambdaurora.lambdynlights.DynamicLightsReforged;
import me.lambdaurora.lambdynlights.api.item.ItemLightSource;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.aperlambda.lambdacommon.LambdaConstants;
import org.jetbrains.annotations.NotNull;

public final class ItemLightSources {
    private static final List<ItemLightSource> ITEM_LIGHT_SOURCES = new ArrayList<ItemLightSource>();
    private static final List<ItemLightSource> STATIC_ITEM_LIGHT_SOURCES = new ArrayList<ItemLightSource>();

    private ItemLightSources() {
        throw new UnsupportedOperationException("ItemLightSources only contains static definitions.");
    }

    public static void load(@NotNull IResourceManager resourceManager) {
        ITEM_LIGHT_SOURCES.clear();
        resourceManager.func_199003_a("dynamiclights/item", path -> path.endsWith(".json")).forEach(id -> ItemLightSources.load(resourceManager, id));
        ITEM_LIGHT_SOURCES.addAll(STATIC_ITEM_LIGHT_SOURCES);
    }

    private static void load(@NotNull IResourceManager resourceManager, @NotNull ResourceLocation resourceId) {
        ResourceLocation id = new ResourceLocation(resourceId.func_110624_b(), resourceId.func_110623_a().replace(".json", ""));
        try {
            InputStream stream = resourceManager.func_199002_a(resourceId).func_199027_b();
            JsonObject json = LambdaConstants.JSON_PARSER.parse((Reader)new InputStreamReader(stream)).getAsJsonObject();
            Optional<ItemLightSource> result = ItemLightSource.fromJson(id, json);
            if (!result.isPresent()) {
                return;
            }
            ItemLightSource data = result.get();
            if (STATIC_ITEM_LIGHT_SOURCES.contains(data)) {
                return;
            }
            ItemLightSources.register(data);
        }
        catch (IOException | IllegalStateException e) {
            DynamicLightsReforged.warn("Failed to load item light source \"" + id + "\".");
        }
    }

    private static void register(@NotNull ItemLightSource data) {
        for (ItemLightSource other : ITEM_LIGHT_SOURCES) {
            if (other.item != data.item) continue;
            DynamicLightsReforged.warn("Failed to register item light source \"" + data.id + "\", duplicates item found in \"" + other.id + "\".");
            return;
        }
        ITEM_LIGHT_SOURCES.add(data);
    }

    public static void registerItemLightSource(@NotNull ItemLightSource data) {
        for (ItemLightSource other : STATIC_ITEM_LIGHT_SOURCES) {
            if (other.item != data.item) continue;
            DynamicLightsReforged.warn("Failed to register item light source \"" + data.id + "\", duplicates item found in \"" + other.id + "\".");
            return;
        }
        STATIC_ITEM_LIGHT_SOURCES.add(data);
    }

    public static int getLuminance(@NotNull ItemStack stack, boolean submergedInWater) {
        for (ItemLightSource data : ITEM_LIGHT_SOURCES) {
            if (data.item != stack.func_77973_b()) continue;
            return data.getLuminance(stack, submergedInWater);
        }
        if (stack.func_77973_b() instanceof BlockItem) {
            return ((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P().func_185906_d();
        }
        return 0;
    }
}

