/*
 * Decompiled with CFR 0.152.
 */
package me.lambdaurora.lambdynlights.api.item;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Objects;
import java.util.Optional;
import me.lambdaurora.lambdynlights.DynamicLightsReforged;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.jetbrains.annotations.NotNull;

public class ItemLightSource {
    public final ResourceLocation id;
    public final Item item;
    public final int luminance;
    public final boolean waterSensitive;

    public ItemLightSource(@NotNull ResourceLocation id, @NotNull Item item, int luminance) {
        this(id, item, luminance, false);
    }

    public ItemLightSource(@NotNull ResourceLocation id, @NotNull Item item, int luminance, boolean waterSensitive) {
        this.id = id;
        this.item = item;
        this.luminance = luminance;
        this.waterSensitive = waterSensitive;
    }

    public int getLuminance(@NotNull ItemStack stack, boolean submergedInWater) {
        if (this.waterSensitive && submergedInWater) {
            return 0;
        }
        return this.luminance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemLightSource that = (ItemLightSource)o;
        return this.luminance == that.luminance && this.waterSensitive == that.waterSensitive && Objects.equals(this.id, that.id) && Objects.equals(this.item, that.item);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.item, this.luminance, this.waterSensitive);
    }

    public String toString() {
        return "ItemLightSource{item=" + this.item + ", luminance=" + this.luminance + ", water_sensitive=" + this.waterSensitive + '}';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static Optional<ItemLightSource> fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
        int luminance;
        if (!json.has("item") || !json.has("luminance")) {
            DynamicLightsReforged.warn("Failed to parse item light source \"" + id + "\", invalid format: missing required fields.");
            return Optional.empty();
        }
        ResourceLocation affectId = new ResourceLocation(json.get("item").getAsString());
        Item item = (Item)Registry.field_212630_s.func_82594_a(affectId);
        if (item == Items.field_190931_a) {
            return Optional.empty();
        }
        JsonPrimitive luminanceElement = json.get("luminance").getAsJsonPrimitive();
        if (luminanceElement.isNumber()) {
            luminance = luminanceElement.getAsInt();
        } else if (luminanceElement.isString()) {
            String luminanceStr = luminanceElement.getAsString();
            if (luminanceStr.equals("block")) {
                if (!(item instanceof BlockItem)) return Optional.empty();
                luminance = ((BlockItem)item).func_179223_d().func_176223_P().func_185906_d();
            } else {
                Block block = (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation(luminanceStr));
                if (block == Blocks.field_150350_a) {
                    return Optional.empty();
                }
                luminance = block.func_176223_P().func_185906_d();
            }
        } else {
            DynamicLightsReforged.warn("Failed to parse item light source \"" + id + "\", invalid format: \"luminance\" field value isn't string or integer.");
            return Optional.empty();
        }
        boolean waterSensitive = false;
        if (!json.has("water_sensitive")) return Optional.of(new ItemLightSource(id, item, luminance, waterSensitive));
        waterSensitive = json.get("water_sensitive").getAsBoolean();
        return Optional.of(new ItemLightSource(id, item, luminance, waterSensitive));
    }
}

