/*
 * Decompiled with CFR 0.152.
 */
package me.lambdaurora.lambdynlights;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import me.lambdaurora.lambdynlights.DynamicLightSource;
import me.lambdaurora.lambdynlights.ExecutorHelper;
import me.lambdaurora.lambdynlights.accessor.WorldRendererAccessor;
import me.lambdaurora.lambdynlights.api.item.ItemLightSources;
import me.lambdaurora.lambdynlights.config.DynamicLightsConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod(value="dynamiclightsreforged")
public class DynamicLightsReforged {
    public static final String MODID = "dynamiclightsreforged";
    private static final double MAX_RADIUS = 7.75;
    private static final double MAX_RADIUS_SQUARED = 60.0625;
    private static DynamicLightsReforged INSTANCE;
    public static final Logger logger;
    private static final Set<DynamicLightSource> dynamicLightSources;
    private static final ReentrantReadWriteLock lightSourcesLock;
    private static long lastUpdate;
    private static int lastUpdateCount;
    private static long lambdynlights_lastUpdate;

    public static boolean isEnabled() {
        return !Objects.equals(DynamicLightsConfig.Quality.get(), "OFF");
    }

    public DynamicLightsReforged() {
        INSTANCE = this;
        DynamicLightsReforged.log("Initializing Dynamic Lights Reforged...");
        DynamicLightsConfig.loadConfig(FMLPaths.CONFIGDIR.get().resolve("dynamic_lights_reforged.toml"));
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ExecutorHelper::onInitializeClient);
    }

    public static boolean ShouldUpdateDynamicLights() {
        String mode = (String)DynamicLightsConfig.Quality.get();
        if (Objects.equals(mode, "OFF")) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (Objects.equals(mode, "SLOW") && currentTime < lambdynlights_lastUpdate + 500L) {
            return false;
        }
        if (Objects.equals(mode, "FAST") && currentTime < lambdynlights_lastUpdate + 200L) {
            return false;
        }
        lambdynlights_lastUpdate = currentTime;
        return true;
    }

    public static void updateAll(@NotNull WorldRenderer renderer) {
        if (!DynamicLightsReforged.isEnabled()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now >= lastUpdate + 50L) {
            lastUpdate = now;
            lastUpdateCount = 0;
            lightSourcesLock.readLock().lock();
            for (DynamicLightSource lightSource : dynamicLightSources) {
                if (!lightSource.lambdynlights_updateDynamicLight(renderer)) continue;
                ++lastUpdateCount;
            }
            lightSourcesLock.readLock().unlock();
        }
    }

    public static int getLastUpdateCount() {
        return lastUpdateCount;
    }

    public static int getLightmapWithDynamicLight(@NotNull BlockPos pos, int lightmap) {
        return DynamicLightsReforged.getLightmapWithDynamicLight(DynamicLightsReforged.getDynamicLightLevel(pos), lightmap);
    }

    public static int getLightmapWithDynamicLight(@NotNull Entity entity, int lightmap) {
        int posLightLevel = (int)DynamicLightsReforged.getDynamicLightLevel(entity.func_233580_cy_());
        int entityLuminance = ((DynamicLightSource)entity).getLuminance();
        return DynamicLightsReforged.getLightmapWithDynamicLight(Math.max(posLightLevel, entityLuminance), lightmap);
    }

    public static int getLightmapWithDynamicLight(double dynamicLightLevel, int lightmap) {
        int blockLevel;
        if (dynamicLightLevel > 0.0 && dynamicLightLevel > (double)(blockLevel = LightTexture.func_228450_a_((int)lightmap))) {
            int luminance = (int)(dynamicLightLevel * 16.0);
            lightmap &= 0xFFF00000;
            lightmap |= luminance & 0xFFFFF;
        }
        return lightmap;
    }

    public static double getDynamicLightLevel(@NotNull BlockPos pos) {
        double result = 0.0;
        lightSourcesLock.readLock().lock();
        for (DynamicLightSource lightSource : dynamicLightSources) {
            result = DynamicLightsReforged.maxDynamicLightLevel(pos, lightSource, result);
        }
        lightSourcesLock.readLock().unlock();
        return MathHelper.func_151237_a((double)result, (double)0.0, (double)15.0);
    }

    public static double maxDynamicLightLevel(@NotNull BlockPos pos, @NotNull DynamicLightSource lightSource, double currentLightLevel) {
        int luminance = lightSource.getLuminance();
        if (luminance > 0) {
            double multiplier;
            double lightLevel;
            double dx = (double)pos.func_177958_n() - lightSource.getDynamicLightX() + 0.5;
            double dy = (double)pos.func_177956_o() - lightSource.getDynamicLightY() + 0.5;
            double dz = (double)pos.func_177952_p() - lightSource.getDynamicLightZ() + 0.5;
            double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            double distanceSquared = dx * dx + dy * dy + dz * dz;
            if (distanceSquared <= 60.0625 && (lightLevel = (multiplier = 1.0 - Math.sqrt(distanceSquared) / 7.75) * (double)luminance) > currentLightLevel) {
                return lightLevel;
            }
        }
        return currentLightLevel;
    }

    public static void addLightSource(@NotNull DynamicLightSource lightSource) {
        if (!lightSource.getDynamicLightWorld().func_201670_d()) {
            return;
        }
        if (!DynamicLightsReforged.isEnabled()) {
            return;
        }
        if (DynamicLightsReforged.containsLightSource(lightSource)) {
            return;
        }
        lightSourcesLock.readLock().lock();
        dynamicLightSources.add(lightSource);
        lightSourcesLock.readLock().unlock();
    }

    public static boolean containsLightSource(@NotNull DynamicLightSource lightSource) {
        if (!lightSource.getDynamicLightWorld().func_201670_d()) {
            return false;
        }
        lightSourcesLock.readLock().lock();
        boolean result = dynamicLightSources.contains(lightSource);
        lightSourcesLock.readLock().unlock();
        return result;
    }

    public static int getLightSourcesCount() {
        int result = 0;
        lightSourcesLock.readLock().lock();
        result = dynamicLightSources.size();
        lightSourcesLock.readLock().unlock();
        return result;
    }

    public static void removeLightSource(@NotNull DynamicLightSource lightSource) {
        lightSourcesLock.readLock().lock();
        Iterator<DynamicLightSource> LightSources = dynamicLightSources.iterator();
        while (LightSources.hasNext()) {
            DynamicLightSource it = LightSources.next();
            if (!it.equals(lightSource)) continue;
            LightSources.remove();
            if (Minecraft.func_71410_x().field_71438_f == null) break;
            lightSource.lambdynlights_scheduleTrackedChunksRebuild(Minecraft.func_71410_x().field_71438_f);
            break;
        }
        lightSourcesLock.readLock().unlock();
    }

    public static void clearLightSources() {
        lightSourcesLock.readLock().lock();
        Iterator<DynamicLightSource> LightSources = dynamicLightSources.iterator();
        while (LightSources.hasNext()) {
            DynamicLightSource it = LightSources.next();
            LightSources.remove();
            if (Minecraft.func_71410_x().field_71438_f == null) continue;
            if (it.getLuminance() > 0) {
                it.resetDynamicLight();
            }
            it.lambdynlights_scheduleTrackedChunksRebuild(Minecraft.func_71410_x().field_71438_f);
        }
        lightSourcesLock.readLock().unlock();
    }

    public static void removeLightSources(@NotNull Predicate<DynamicLightSource> filter) {
        lightSourcesLock.readLock().lock();
        Iterator<DynamicLightSource> LightSources = dynamicLightSources.iterator();
        while (LightSources.hasNext()) {
            DynamicLightSource it = LightSources.next();
            if (!filter.test(it)) continue;
            LightSources.remove();
            if (Minecraft.func_71410_x().field_71438_f == null) break;
            if (it.getLuminance() > 0) {
                it.resetDynamicLight();
            }
            it.lambdynlights_scheduleTrackedChunksRebuild(Minecraft.func_71410_x().field_71438_f);
            break;
        }
        lightSourcesLock.readLock().unlock();
    }

    public static void removeEntitiesLightSource() {
        DynamicLightsReforged.removeLightSources(lightSource -> lightSource instanceof Entity && !(lightSource instanceof PlayerEntity));
    }

    public static void removeCreeperLightSources() {
        DynamicLightsReforged.removeLightSources(entity -> entity instanceof CreeperEntity);
    }

    public static void removeTntLightSources() {
        DynamicLightsReforged.removeLightSources(entity -> entity instanceof TNTEntity);
    }

    public static void removeBlockEntitiesLightSource() {
        DynamicLightsReforged.removeLightSources(lightSource -> lightSource instanceof TileEntity);
    }

    public static void log(String info) {
        logger.info("[LambDynLights] " + info);
    }

    public static void warn(String info) {
        logger.warn("[LambDynLights] " + info);
    }

    public static void scheduleChunkRebuild(@NotNull WorldRenderer renderer, @NotNull BlockPos chunkPos) {
        DynamicLightsReforged.scheduleChunkRebuild(renderer, chunkPos.func_177958_n(), chunkPos.func_177956_o(), chunkPos.func_177952_p());
    }

    public static void scheduleChunkRebuild(@NotNull WorldRenderer renderer, long chunkPos) {
        DynamicLightsReforged.scheduleChunkRebuild(renderer, BlockPos.func_218290_b((long)chunkPos), BlockPos.func_218274_c((long)chunkPos), BlockPos.func_218282_d((long)chunkPos));
    }

    public static void scheduleChunkRebuild(@NotNull WorldRenderer renderer, int x, int y, int z) {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            ((WorldRendererAccessor)renderer).dynlights_setSectionDirty(x, y, z, false);
        }
    }

    public static void updateTrackedChunks(@NotNull BlockPos chunkPos, @Nullable LongOpenHashSet old, @Nullable LongOpenHashSet newPos) {
        if (old != null || newPos != null) {
            long pos = chunkPos.func_218275_a();
            if (old != null) {
                old.remove(pos);
            }
            if (newPos != null) {
                newPos.add(pos);
            }
        }
    }

    public static void updateTracking(@NotNull DynamicLightSource lightSource) {
        boolean enabled = lightSource.isDynamicLightEnabled();
        int luminance = lightSource.getLuminance();
        if (!enabled && luminance > 0) {
            lightSource.setDynamicLightEnabled(true);
        } else if (enabled && luminance < 1) {
            lightSource.setDynamicLightEnabled(false);
        }
    }

    public static int getLuminanceFromItemStack(@NotNull ItemStack stack, boolean submergedInWater) {
        return ItemLightSources.getLuminance(stack, submergedInWater);
    }

    static {
        logger = LogManager.getLogger((String)MODID);
        dynamicLightSources = new HashSet<DynamicLightSource>();
        lightSourcesLock = new ReentrantReadWriteLock();
        lastUpdate = System.currentTimeMillis();
        lastUpdateCount = 0;
        lambdynlights_lastUpdate = 0L;
    }
}

