/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus;

import com.google.common.collect.ImmutableMap;
import com.legacy.dungeons_plus.DPLoot;
import com.legacy.dungeons_plus.DungeonsPlus;
import com.legacy.structure_gel.access_helpers.BiomeAccessHelper;
import com.legacy.structure_gel.access_helpers.EntityAccessHelper;
import com.legacy.structure_gel.registrars.StructureRegistrar2;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.loot.LootTables;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DPEvents {
    private static final NonNullLazy<Map<EntityType<?>, ResourceLocation>> TOWER_ENTITY_LOOT = NonNullLazy.of(() -> ImmutableMap.of((Object)EntityType.field_200725_aD, (Object)DPLoot.Tower.ZOMBIE, (Object)EntityType.field_200748_an, (Object)DPLoot.Tower.SPIDER, (Object)EntityType.field_200741_ag, (Object)DPLoot.Tower.SKELETON));
    private static final NonNullLazy<Map<EntityType<?>, ResourceLocation>> BURIED_ENTITY_LOOT = NonNullLazy.of(() -> ImmutableMap.of((Object)EntityType.field_200725_aD, (Object)DPLoot.BiggerDungeon.ZOMBIE, (Object)EntityType.field_200741_ag, (Object)DPLoot.BiggerDungeon.SKELETON));

    @SubscribeEvent
    protected static void onEntitySpawn(EntityJoinWorldEvent event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            Entity entity = event.getEntity();
            ((Map)TOWER_ENTITY_LOOT.get()).forEach((type, loot) -> DPEvents.ifInStructure(entity, type, DungeonsPlus.Structures.TOWER, e -> EntityAccessHelper.setDeathLootTable((MobEntity)((MobEntity)e), (ResourceLocation)loot)));
            ((Map)BURIED_ENTITY_LOOT.get()).forEach((type, loot) -> DPEvents.ifInStructure(entity, type, DungeonsPlus.Structures.BIGGER_DUNGEON, e -> EntityAccessHelper.setDeathLootTable((MobEntity)((MobEntity)e), (ResourceLocation)loot)));
            DPEvents.ifInStructure(entity, EntityType.field_200763_C, DungeonsPlus.Structures.LEVIATHAN, e -> EntityAccessHelper.setDeathLootTable((MobEntity)((MobEntity)e), (ResourceLocation)DPLoot.Leviathan.HUSK));
            DPEvents.ifInStructure(entity, EntityType.field_200750_ap, DungeonsPlus.Structures.SNOWY_TEMPLE, e -> EntityAccessHelper.setDeathLootTable((MobEntity)((MobEntity)e), (ResourceLocation)DPLoot.SnowyTemple.STRAY));
            DPEvents.ifInStructure(entity, EntityType.field_200803_q, DungeonsPlus.Structures.END_RUINS, e -> ((EndermanEntity)e).field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)((EndermanEntity)e), PlayerEntity.class, true, false)));
            DPEvents.ifInStructure(entity, EntityType.field_200811_y, DungeonsPlus.Structures.SOUL_PRISON, e -> ((GhastEntity)e).field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)((GhastEntity)e), PlayerEntity.class, true, false)));
        }
    }

    private static void ifInStructure(Entity entity, EntityType<?> entityTest, StructureRegistrar2<?, ?> structure, Consumer<Entity> consumer) {
        if (entity.func_200600_R().equals(entityTest) && ((ServerWorld)entity.field_70170_p).func_241112_a_().func_235010_a_(entity.func_233580_cy_(), false, structure.getStructure()).func_75069_d()) {
            consumer.accept(entity);
        }
    }

    @SubscribeEvent
    protected static void biomeLoad(BiomeLoadingEvent event) {
        BiomeAccessHelper.addStructureIfAllowed((BiomeLoadingEvent)event, (StructureFeature)DungeonsPlus.Structures.TOWER.getStructureFeature());
        BiomeAccessHelper.addStructureIfAllowed((BiomeLoadingEvent)event, (StructureFeature)DungeonsPlus.Structures.BIGGER_DUNGEON.getStructureFeature());
        BiomeAccessHelper.addStructureIfAllowed((BiomeLoadingEvent)event, (StructureFeature)DungeonsPlus.Structures.LEVIATHAN.getStructureFeature());
        BiomeAccessHelper.addStructureIfAllowed((BiomeLoadingEvent)event, (StructureFeature)DungeonsPlus.Structures.SNOWY_TEMPLE.getStructureFeature());
        BiomeAccessHelper.addStructureIfAllowed((BiomeLoadingEvent)event, (StructureFeature)DungeonsPlus.Structures.END_RUINS.getStructureFeature());
        BiomeAccessHelper.addStructureIfAllowed((BiomeLoadingEvent)event, (StructureFeature)DungeonsPlus.Structures.WARPED_GARDEN.getStructureFeature());
        BiomeAccessHelper.addStructureIfAllowed((BiomeLoadingEvent)event, (StructureFeature)DungeonsPlus.Structures.SOUL_PRISON.getStructureFeature());
    }

    @SubscribeEvent
    protected static void lootTableLoad(LootTableLoadEvent event) {
        LootTableLoadEvent newEvent;
        if (DPLoot.CHESTS_SIMPLE_DUNGEON.equals((Object)event.getName()) && !MinecraftForge.EVENT_BUS.post((Event)(newEvent = new LootTableLoadEvent(LootTables.field_186422_d, event.getTable(), event.getLootTableManager()))) && newEvent.getTable() != null) {
            event.setTable(newEvent.getTable());
        }
    }
}

