/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.mixin;

import com.infamous.dungeons_mobs.DungeonsGearCompat;
import com.infamous.dungeons_mobs.goals.SmartZombieAttackGoal;
import com.infamous.dungeons_mobs.interfaces.ISmartCrossbowUser;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShootableItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ZombifiedPiglinEntity.class})
public abstract class ZombifiedPiglinEntityMixin
extends ZombieEntity
implements ISmartCrossbowUser {
    private static final DataParameter<Boolean> DATA_IS_CROSSBOW_USER = EntityDataManager.func_187226_a(ZombifiedPiglinEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DATA_IS_CHARGING_CROSSBOW = EntityDataManager.func_187226_a(ZombifiedPiglinEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public ZombifiedPiglinEntityMixin(EntityType<? extends ZombieEntity> entityType, World world) {
        super(entityType, world);
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/entity/ai/goal/GoalSelector;addGoal(ILnet/minecraft/entity/ai/goal/Goal;)V"), method={"addBehaviourGoals"})
    private void addCustomGoal(GoalSelector goalSelector, int priority, Goal originalGoal) {
        if (goalSelector == this.field_70714_bg && priority == 2 && originalGoal instanceof ZombieAttackGoal) {
            goalSelector.func_75776_a(priority, (Goal)new SmartZombieAttackGoal(this, 1.0, false));
            goalSelector.func_75776_a(priority, (Goal)new RangedCrossbowAttackGoal((MonsterEntity)this, 1.0, 8.0f));
        } else {
            goalSelector.func_75776_a(priority, originalGoal);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"populateDefaultEquipmentSlots"}, cancellable=true)
    private void spawnWeapon(DifficultyInstance p_180481_1_, CallbackInfo ci) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, this.createSpawnWeapon());
    }

    @Inject(at={@At(value="TAIL")}, method={"readAdditionalSaveData"})
    private void readAdditional(CompoundNBT compoundNBT, CallbackInfo ci) {
        this.readCrossbowUserNBT(compoundNBT);
    }

    @Inject(at={@At(value="TAIL")}, method={"addAdditionalSaveData"})
    private void writeAdditional(CompoundNBT compoundNBT, CallbackInfo ci) {
        this.writeCrossbowUserNBT(compoundNBT);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, @Nullable ILivingEntityData p_213386_4_, @Nullable CompoundNBT p_213386_5_) {
        ILivingEntityData spawnData = super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
        this.setCrossbowUser(this.func_233634_a_(item -> item instanceof CrossbowItem));
        return spawnData;
    }

    private ItemStack createSpawnWeapon() {
        ItemStack meleeWeapon = DungeonsGearCompat.isLoaded() ? new ItemStack((IItemProvider)DungeonsGearCompat.getGoldAxe().get()) : new ItemStack((IItemProvider)Items.field_151010_B);
        return (double)this.field_70146_Z.nextFloat() < 0.5 ? new ItemStack((IItemProvider)Items.field_222114_py) : meleeWeapon;
    }

    public boolean func_230280_a_(ShootableItem shootableItem) {
        return shootableItem instanceof CrossbowItem;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_IS_CHARGING_CROSSBOW, (Object)false);
        this.field_70180_af.func_187214_a(DATA_IS_CROSSBOW_USER, (Object)false);
    }

    @Override
    public boolean isCrossbowUser() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_IS_CROSSBOW_USER);
    }

    @Override
    public void setCrossbowUser(boolean crossbowUser) {
        this.field_70180_af.func_187227_b(DATA_IS_CROSSBOW_USER, (Object)crossbowUser);
    }

    @Override
    public boolean _isChargingCrossbow() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_IS_CHARGING_CROSSBOW);
    }

    public void func_213671_a(boolean chargingCrossbow) {
        this.field_70180_af.func_187227_b(DATA_IS_CHARGING_CROSSBOW, (Object)chargingCrossbow);
    }

    public void func_230284_a_(LivingEntity target, ItemStack weapon, ProjectileEntity projectile, float inaccuracy) {
        this.func_234279_a_((LivingEntity)this, target, projectile, inaccuracy, 1.6f);
    }

    public void func_230283_U__() {
        this.field_70708_bq = 0;
    }

    public void func_82196_d(LivingEntity target, float velocity) {
        this.func_234281_b_((LivingEntity)this, 1.6f);
    }
}

