/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.mixin;

import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.TridentItem;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DrownedEntity.class})
public abstract class DrownedEntityMixin
extends ZombieEntity {
    public DrownedEntityMixin(EntityType<? extends ZombieEntity> entityType, World world) {
        super(entityType, world);
    }

    @Inject(at={@At(value="RETURN")}, method={"canReplaceCurrentItem"}, cancellable=true)
    private void checkForAnyTrident(ItemStack replacement, ItemStack current, CallbackInfoReturnable<Boolean> cir) {
        if (current.func_77973_b() == Items.field_205157_eZ) {
            cir.setReturnValue((Object)false);
        } else if (current.func_77973_b() instanceof TridentItem) {
            if (replacement.func_77973_b() instanceof TridentItem) {
                cir.setReturnValue((Object)(replacement.func_77952_i() < current.func_77952_i() ? 1 : 0));
            } else {
                cir.setReturnValue((Object)false);
            }
        } else {
            cir.setReturnValue((Object)(replacement.func_77973_b() instanceof TridentItem || super.func_208003_a(replacement, current) ? 1 : 0));
        }
    }

    @ModifyVariable(at=@At(value="STORE"), method={"performRangedAttack"})
    private TridentEntity createTrident(TridentEntity original) {
        Hand tridentHoldingHand = ProjectileHelper.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof TridentItem);
        ItemStack tridentStack = this.func_184586_b(tridentHoldingHand);
        return new TridentEntity(this.field_70170_p, (LivingEntity)this, tridentStack);
    }
}

