/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.interfaces;

import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;

public interface IAquaticMob {
    public static boolean isDeepEnoughToSpawn(IWorld world, BlockPos blockPos) {
        return blockPos.func_177956_o() < world.func_181545_F() - 5;
    }

    default public <T extends LivingEntity> boolean okTarget(T aquaticMob, @Nullable LivingEntity target) {
        if (aquaticMob != this) {
            throw new IllegalArgumentException("Supplied aquaticMob is not this instance!");
        }
        if (target != null) {
            return !aquaticMob.field_70170_p.func_72935_r() || target.func_70090_H();
        }
        return false;
    }

    default public <T extends MobEntity> boolean wantsToSwim(T aquaticMob) {
        if (aquaticMob != this) {
            throw new IllegalArgumentException("Supplied aquaticMob is not this instance!");
        }
        if (this.isSearchingForLand()) {
            return true;
        }
        LivingEntity target = aquaticMob.func_70638_az();
        return target != null && target.func_70090_H();
    }

    public void setSearchingForLand(boolean var1);

    default public <T extends MobEntity> boolean closeToNextPos(T aquaticMob) {
        if (aquaticMob != this) {
            throw new IllegalArgumentException("Supplied aquaticMob is not this instance!");
        }
        Path path = aquaticMob.func_70661_as().func_75505_d();
        if (path != null) {
            BlockPos blockpos = path.func_224770_k();
            double distanceToSqr = aquaticMob.func_70092_e((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p());
            return distanceToSqr < 4.0;
        }
        return false;
    }

    default public <T extends MobEntity> void updateNavigation(T aquaticMob) {
        if (aquaticMob != this) {
            throw new IllegalArgumentException("Supplied aquaticMob is not this instance!");
        }
        if (!aquaticMob.field_70170_p.field_72995_K) {
            if (aquaticMob.func_70613_aW() && aquaticMob.func_70090_H() && this.wantsToSwim(aquaticMob)) {
                ((IAquaticMob)aquaticMob).setNavigation((PathNavigator)((IAquaticMob)aquaticMob).getWaterNavigation());
                aquaticMob.func_204711_a(true);
            } else {
                ((IAquaticMob)aquaticMob).setNavigation((PathNavigator)((IAquaticMob)aquaticMob).getGroundNavigation());
                aquaticMob.func_204711_a(false);
            }
        }
    }

    default public <T extends MobEntity> void checkAquaticTravel(T aquaticMob, Vector3d travelVec) {
        if (aquaticMob != this) {
            throw new IllegalArgumentException("Supplied aquaticMob is not this instance!");
        }
        if (aquaticMob.func_70613_aW() && aquaticMob.func_70090_H() && this.wantsToSwim(aquaticMob)) {
            aquaticMob.func_213309_a(0.01f, travelVec);
            aquaticMob.func_213315_a(MoverType.SELF, aquaticMob.func_213322_ci());
            aquaticMob.func_213317_d(aquaticMob.func_213322_ci().func_186678_a(0.9));
        } else {
            this.normalTravel(travelVec);
        }
    }

    public void normalTravel(Vector3d var1);

    public boolean isSearchingForLand();

    public void setNavigation(PathNavigator var1);

    public GroundPathNavigator getGroundNavigation();

    public SwimmerPathNavigator getWaterNavigation();
}

