/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.goals.magic;

import com.infamous.dungeons_mobs.entities.magic.MagicType;
import com.infamous.dungeons_mobs.interfaces.IMagicUser;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.SoundEvent;

public abstract class UseMagicGoal<T extends MobEntity>
extends Goal {
    private int magicWarmup;
    private int magicCooldown;
    private T hostMobEntity;

    protected UseMagicGoal(T magicUserMob) {
        this.hostMobEntity = magicUserMob;
    }

    public boolean func_75250_a() {
        LivingEntity livingentity = this.hostMobEntity.func_70638_az();
        if (livingentity != null && livingentity.func_70089_S()) {
            if (((IMagicUser)this.hostMobEntity).isUsingMagic()) {
                return false;
            }
            return ((MobEntity)this.hostMobEntity).field_70173_aa >= this.magicCooldown;
        }
        return false;
    }

    public boolean func_75253_b() {
        LivingEntity livingentity = this.hostMobEntity.func_70638_az();
        return livingentity != null && livingentity.func_70089_S() && this.magicWarmup > 0;
    }

    public void func_75249_e() {
        this.magicWarmup = this.getMagicWarmupTime();
        ((IMagicUser)this.hostMobEntity).setMagicUseTicks(this.getMagicUseTime());
        this.magicCooldown = ((MobEntity)this.hostMobEntity).field_70173_aa + this.getMagicUseInterval();
        SoundEvent soundevent = this.getMagicPrepareSound();
        if (soundevent != null) {
            this.hostMobEntity.func_184185_a(soundevent, 1.0f, 1.0f);
        }
        ((IMagicUser)this.hostMobEntity).setMagicType(this.getMagicType());
    }

    public void func_75246_d() {
        --this.magicWarmup;
        if (this.magicWarmup == 0) {
            this.useMagic();
            this.hostMobEntity.func_184185_a(((IMagicUser)this.hostMobEntity).getMagicSound(), 1.0f, 1.0f);
        }
    }

    protected abstract void useMagic();

    private int getMagicWarmupTime() {
        return 20;
    }

    protected abstract int getMagicUseTime();

    protected abstract int getMagicUseInterval();

    @Nullable
    protected abstract SoundEvent getMagicPrepareSound();

    protected abstract MagicType getMagicType();
}

