/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.goals;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;

public class AvoidBaseEntityGoal<T extends Entity>
extends Goal {
    private final CreatureEntity hostCreature;
    private final double farSpeed;
    private final double nearSpeed;
    private T avoidTarget;
    private final float avoidDistance;
    private Path path;
    private final PathNavigator navigation;
    private final Class<T> classToAvoid;

    public AvoidBaseEntityGoal(CreatureEntity entityIn, Class<T> avoidClass, float distance, double farSpeedIn, double nearSpeedIn) {
        this.hostCreature = entityIn;
        this.classToAvoid = avoidClass;
        this.avoidDistance = distance;
        this.farSpeed = farSpeedIn;
        this.nearSpeed = nearSpeedIn;
        this.navigation = entityIn.func_70661_as();
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        this.avoidTarget = this.getNearestEntity(this.classToAvoid, (LivingEntity)this.hostCreature, this.hostCreature.func_226277_ct_(), this.hostCreature.func_226278_cu_(), this.hostCreature.func_226281_cx_(), this.hostCreature.func_174813_aQ().func_72314_b((double)this.avoidDistance, 3.0, (double)this.avoidDistance));
        if (this.avoidTarget == null) {
            return false;
        }
        Vector3d vector3d = RandomPositionGenerator.func_75461_b((CreatureEntity)this.hostCreature, (int)16, (int)7, (Vector3d)this.avoidTarget.func_213303_ch());
        if (vector3d == null) {
            return false;
        }
        if (this.avoidTarget.func_70092_e(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c) < this.avoidTarget.func_70068_e((Entity)this.hostCreature)) {
            return false;
        }
        this.path = this.navigation.func_225466_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, 0);
        return this.path != null;
    }

    public boolean func_75253_b() {
        return !this.navigation.func_75500_f();
    }

    public void func_75249_e() {
        this.navigation.func_75484_a(this.path, this.farSpeed);
    }

    public void func_75251_c() {
        this.avoidTarget = null;
    }

    public void func_75246_d() {
        if (this.hostCreature.func_70068_e(this.avoidTarget) < 49.0) {
            this.hostCreature.func_70661_as().func_75489_a(this.nearSpeed);
        } else {
            this.hostCreature.func_70661_as().func_75489_a(this.farSpeed);
        }
    }

    @Nullable
    private <T extends Entity> T getNearestEntity(Class<? extends T> entityClass, LivingEntity livingEntity, double xPos, double yPos, double zPos, AxisAlignedBB axisAlignedBB) {
        return this.getClosestEntity(livingEntity.field_70170_p.func_225316_b(entityClass, axisAlignedBB, (Predicate)null), livingEntity, xPos, yPos, zPos);
    }

    @Nullable
    private <T extends Entity> T getClosestEntity(List<? extends T> nearbyEntities, LivingEntity livingEntity, double xPos, double yPos, double zPos) {
        double closestDistanceSq = -1.0;
        Entity closestEntity = null;
        for (Entity nearbyEntity : nearbyEntities) {
            if (!this.canDetect(livingEntity, nearbyEntity)) continue;
            double distanceSq = nearbyEntity.func_70092_e(xPos, yPos, zPos);
            if (closestDistanceSq != -1.0 && !(distanceSq < closestDistanceSq)) continue;
            closestDistanceSq = distanceSq;
            closestEntity = nearbyEntity;
        }
        return (T)closestEntity;
    }

    private boolean canDetect(@Nullable LivingEntity detector, Entity target) {
        if (detector == target) {
            return false;
        }
        if (target.func_175149_v()) {
            return false;
        }
        if (!target.func_70089_S()) {
            return false;
        }
        if (detector != null) {
            if (detector.func_184191_r(target)) {
                return false;
            }
            return !(detector instanceof MobEntity) || ((MobEntity)detector).func_70635_at().func_75522_a(target);
        }
        return true;
    }
}

