/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.water;

import com.infamous.dungeons_mobs.capabilities.teamable.TeamableHelper;
import com.infamous.dungeons_mobs.config.DungeonsMobsConfig;
import com.infamous.dungeons_mobs.entities.magic.MagicType;
import com.infamous.dungeons_mobs.entities.projectiles.TridentFumeEntity;
import com.infamous.dungeons_mobs.goals.SimpleRangedAttackGoal;
import com.infamous.dungeons_mobs.goals.magic.UseMagicGoal;
import com.infamous.dungeons_mobs.goals.magic.UsingMagicGoal;
import com.infamous.dungeons_mobs.interfaces.IMagicUser;
import com.infamous.dungeons_mobs.items.NecromancerTridentItem;
import com.infamous.dungeons_mobs.mixin.GoalSelectorAccessor;
import com.infamous.dungeons_mobs.mod.ModItems;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class DrownedNecromancerEntity
extends DrownedEntity
implements IMagicUser {
    private static final DataParameter<Byte> MAGIC = EntityDataManager.func_187226_a(DrownedNecromancerEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    public static final Predicate<Item> TRIDENT_STAFF_PREDICATE = item -> item instanceof NecromancerTridentItem;
    private int magicUseTicks;
    private MagicType activeMagic = MagicType.NONE;

    public DrownedNecromancerEntity(EntityType<? extends DrownedNecromancerEntity> entityType, World world) {
        super(entityType, world);
    }

    protected boolean func_204609_dp() {
        return false;
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return ZombieEntity.func_234342_eQ_();
    }

    protected void func_175456_n() {
        super.func_175456_n();
        ((GoalSelectorAccessor)this.field_70714_bg).getAvailableGoals().removeIf(pg -> pg.func_220770_h() == 2 && (pg.func_220772_j() instanceof ZombieAttackGoal || pg.func_220772_j() instanceof RangedAttackGoal));
        this.field_70714_bg.func_75776_a(1, (Goal)new UsingOceanMagic());
        this.field_70714_bg.func_75776_a(4, (Goal)new UseHydromancy());
        this.field_70714_bg.func_75776_a(4, (Goal)new UseNeptunesWrath());
        this.field_70714_bg.func_75776_a(5, new SimpleRangedAttackGoal<DrownedNecromancerEntity>(this, TRIDENT_STAFF_PREDICATE, DrownedNecromancerEntity::performRangedAttack, 1.25, 20, 20.0f));
    }

    private static void performRangedAttack(LivingEntity shooter, LivingEntity target) {
        shooter.func_184609_a(ProjectileHelper.getWeaponHoldingHand((LivingEntity)shooter, TRIDENT_STAFF_PREDICATE));
        double scale = 1.0;
        Vector3d viewVector = shooter.func_70676_i(1.0f);
        double xAccel = target.func_226277_ct_() - (shooter.func_226277_ct_() + viewVector.field_72450_a * scale);
        double yAccel = target.func_226283_e_(0.5) - (0.5 + shooter.func_226283_e_(0.5));
        double zAccel = target.func_226281_cx_() - (shooter.func_226281_cx_() + viewVector.field_72449_c * scale);
        float euclidDist = MathHelper.func_76133_a((double)(xAccel * xAccel + yAccel * yAccel + zAccel * zAccel));
        TridentFumeEntity tridentFumeEntity = new TridentFumeEntity(shooter.field_70170_p, shooter, xAccel, yAccel, zAccel);
        tridentFumeEntity.func_70107_b(shooter.func_226277_ct_() + viewVector.field_72450_a * scale, shooter.func_226283_e_(0.5) + 0.5, tridentFumeEntity.func_226281_cx_() + viewVector.field_72449_c * scale);
        tridentFumeEntity.func_70186_c(xAccel, yAccel, zAccel, euclidDist, 0.0f);
        shooter.field_70170_p.func_217376_c((Entity)tridentFumeEntity);
    }

    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, @Nullable ILivingEntityData p_213386_4_, @Nullable CompoundNBT p_213386_5_) {
        ILivingEntityData spawnData = super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
        if (this.func_184582_a(EquipmentSlotType.OFFHAND).func_77973_b() == Items.field_205157_eZ) {
            this.func_184201_a(EquipmentSlotType.OFFHAND, ItemStack.field_190927_a);
        }
        return spawnData;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ModItems.NECROMANCER_TRIDENT.get()));
    }

    protected void func_180483_b(DifficultyInstance difficulty) {
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MAGIC, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        IMagicUser.spawnMagicParticles(this);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.magicUseTicks > 0) {
            --this.magicUseTicks;
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.magicUseTicks = compound.func_74762_e("MagicUseTicks");
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("MagicUseTicks", this.magicUseTicks);
    }

    @Override
    public boolean isUsingMagic() {
        if (this.field_70170_p.field_72995_K) {
            return (Byte)this.field_70180_af.func_187225_a(MAGIC) > 0;
        }
        return this.magicUseTicks > 0;
    }

    @Override
    public int getMagicUseTicks() {
        return this.magicUseTicks;
    }

    @Override
    public void setMagicUseTicks(int magicUseTicksIn) {
        this.magicUseTicks = magicUseTicksIn;
    }

    @Override
    public MagicType getMagicType() {
        return !this.field_70170_p.field_72995_K ? this.activeMagic : MagicType.getFromId(((Byte)this.field_70180_af.func_187225_a(MAGIC)).byteValue());
    }

    @Override
    public void setMagicType(MagicType magicType) {
        this.activeMagic = magicType;
        this.field_70180_af.func_187227_b(MAGIC, (Object)((byte)magicType.getId()));
    }

    @Override
    public SoundEvent getMagicSound() {
        return SoundEvents.field_191244_bn;
    }

    public boolean func_70097_a(DamageSource damageSource, float amount) {
        if (damageSource == DamageSource.field_180137_b && this.getMagicType() == MagicType.SUMMON_LIGHTNING) {
            return false;
        }
        return super.func_70097_a(damageSource, amount);
    }

    class UseNeptunesWrath
    extends UseMagicGoal<DrownedNecromancerEntity> {
        UseNeptunesWrath() {
            super(DrownedNecromancerEntity.this);
        }

        @Override
        public boolean func_75250_a() {
            LivingEntity targetEntity = DrownedNecromancerEntity.this.func_70638_az();
            if (targetEntity == null) {
                return false;
            }
            boolean canTargetBeSeen = DrownedNecromancerEntity.this.func_70685_l((Entity)targetEntity);
            if (canTargetBeSeen && targetEntity.func_70089_S() && (double)DrownedNecromancerEntity.this.func_70032_d((Entity)targetEntity) < 16.0) {
                return super.func_75250_a();
            }
            return false;
        }

        @Override
        public boolean func_75253_b() {
            LivingEntity targetEntity = DrownedNecromancerEntity.this.func_70638_az();
            if (targetEntity == null) {
                return false;
            }
            boolean canTargetBeSeen = DrownedNecromancerEntity.this.func_70685_l((Entity)targetEntity);
            if (canTargetBeSeen && targetEntity.func_70089_S()) {
                return super.func_75253_b();
            }
            return false;
        }

        @Override
        protected void useMagic() {
            LivingEntity targetEntity = DrownedNecromancerEntity.this.func_70638_az();
            if (targetEntity != null) {
                this.summonLightning(targetEntity);
            }
        }

        private void summonLightning(LivingEntity targetEntity) {
            float atan2 = (float)MathHelper.func_181159_b((double)(targetEntity.func_226281_cx_() - DrownedNecromancerEntity.this.func_226281_cx_()), (double)(targetEntity.func_226277_ct_() - DrownedNecromancerEntity.this.func_226277_ct_()));
            double minY = Math.min(targetEntity.func_226278_cu_(), DrownedNecromancerEntity.this.func_226278_cu_());
            double maxY = Math.max(targetEntity.func_226278_cu_(), DrownedNecromancerEntity.this.func_226278_cu_()) + 1.0;
            for (int boltCounter = 0; boltCounter < 5; ++boltCounter) {
                float randomShift = atan2 + (float)boltCounter * (float)Math.PI * 0.4f;
                this.createSpellEntity(DrownedNecromancerEntity.this.func_226277_ct_() + (double)MathHelper.func_76134_b((float)randomShift) * 1.5, DrownedNecromancerEntity.this.func_226281_cx_() + (double)MathHelper.func_76126_a((float)randomShift) * 1.5, minY, maxY);
            }
        }

        private void createSpellEntity(double x, double z, double minY, double maxY) {
            LightningBoltEntity lightningboltentity;
            BlockPos blockpos = new BlockPos(x, maxY, z);
            boolean doSummon = false;
            double yShift = 0.0;
            World level = DrownedNecromancerEntity.this.field_70170_p;
            do {
                BlockState stateAtPos;
                VoxelShape shapeAtPos;
                BlockPos below;
                BlockState stateAtBelowPos;
                if (!(stateAtBelowPos = level.func_180495_p(below = blockpos.func_177977_b())).func_224755_d((IBlockReader)level, below, Direction.UP)) continue;
                if (!level.func_175623_d(blockpos) && !(shapeAtPos = (stateAtPos = level.func_180495_p(blockpos)).func_196952_d((IBlockReader)level, blockpos)).func_197766_b()) {
                    yShift = shapeAtPos.func_197758_c(Direction.Axis.Y);
                }
                doSummon = true;
                break;
            } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)minY) - 1);
            if (doSummon && (lightningboltentity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(level)) != null) {
                Vector3d targetPosVec = new Vector3d(x, (double)blockpos.func_177956_o() + yShift, z);
                lightningboltentity.func_233576_c_(targetPosVec);
                lightningboltentity.func_204809_d(null);
                level.func_217376_c((Entity)lightningboltentity);
            }
        }

        @Override
        protected int getMagicUseTime() {
            return 100;
        }

        @Override
        protected int getMagicUseInterval() {
            return 340;
        }

        @Override
        @Nullable
        protected SoundEvent getMagicPrepareSound() {
            return SoundEvents.field_187754_de;
        }

        @Override
        protected MagicType getMagicType() {
            return MagicType.SUMMON_LIGHTNING;
        }
    }

    class UseHydromancy
    extends UseMagicGoal<DrownedNecromancerEntity> {
        private final EntityPredicate entityPredicate;

        UseHydromancy() {
            super(DrownedNecromancerEntity.this);
            this.entityPredicate = new EntityPredicate().func_221013_a(16.0).func_221014_c().func_221010_e().func_221008_a().func_221011_b();
        }

        @Override
        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            int i = DrownedNecromancerEntity.this.field_70170_p.func_217374_a(DrownedEntity.class, this.entityPredicate, (LivingEntity)DrownedNecromancerEntity.this, DrownedNecromancerEntity.this.func_174813_aQ().func_186662_g(16.0)).size();
            return DrownedNecromancerEntity.this.field_70146_Z.nextInt(16) + 1 > i;
        }

        @Override
        public boolean func_75253_b() {
            LivingEntity targetEntity = DrownedNecromancerEntity.this.func_70638_az();
            if (targetEntity == null) {
                return false;
            }
            boolean canTargetBeSeen = DrownedNecromancerEntity.this.func_70685_l((Entity)targetEntity);
            if (canTargetBeSeen && targetEntity.func_70089_S()) {
                return super.func_75253_b();
            }
            return false;
        }

        @Override
        protected void useMagic() {
            LivingEntity targetEntity = DrownedNecromancerEntity.this.func_70638_az();
            if (targetEntity != null) {
                this.summonUndead();
            }
        }

        private void summonUndead() {
            int difficultyAsInt = DrownedNecromancerEntity.this.field_70170_p.func_175659_aa().func_151525_a();
            int mobsToSummon = difficultyAsInt * 2;
            for (int i = 0; i < mobsToSummon; ++i) {
                BlockPos blockpos = DrownedNecromancerEntity.this.func_233580_cy_().func_177982_a(-2 + DrownedNecromancerEntity.this.field_70146_Z.nextInt(5), 1, -2 + DrownedNecromancerEntity.this.field_70146_Z.nextInt(5));
                boolean summonedMobFromConfig = this.summonMobFromConfig(blockpos);
                if (summonedMobFromConfig) continue;
                this.summonedDrowned(blockpos);
            }
        }

        private boolean summonMobFromConfig(BlockPos blockpos) {
            List necromancerMobSummons = (List)DungeonsMobsConfig.Common.DROWNED_NECROMANCER_MOB_SUMMONS.get();
            if (necromancerMobSummons.isEmpty()) {
                return false;
            }
            Collections.shuffle(necromancerMobSummons);
            int randomIndex = DrownedNecromancerEntity.this.func_70681_au().nextInt(necromancerMobSummons.size());
            String randomMobID = (String)necromancerMobSummons.get(randomIndex);
            EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(randomMobID));
            if (entityType == null) {
                return false;
            }
            Entity entity = entityType.func_200721_a(DrownedNecromancerEntity.this.field_70170_p);
            if (!(entity instanceof MobEntity)) {
                return false;
            }
            MobEntity mobEntity = (MobEntity)entity;
            DifficultyInstance difficultyForLocation = DrownedNecromancerEntity.this.field_70170_p.func_175649_E(blockpos);
            mobEntity.func_174828_a(blockpos, 0.0f, 0.0f);
            ModifiableAttributeInstance spawnReinforcementsAttribute = mobEntity.func_110148_a(Attributes.field_233829_l_);
            if (spawnReinforcementsAttribute != null) {
                spawnReinforcementsAttribute.func_111128_a(0.0);
            }
            mobEntity.func_213386_a((IServerWorld)DrownedNecromancerEntity.this.field_70170_p, difficultyForLocation, SpawnReason.MOB_SUMMONED, (ILivingEntityData)null, (CompoundNBT)null);
            TeamableHelper.makeTeammates(mobEntity, (MobEntity)DrownedNecromancerEntity.this);
            return DrownedNecromancerEntity.this.field_70170_p.func_217376_c((Entity)mobEntity);
        }

        private void summonedDrowned(BlockPos blockpos) {
            DrownedEntity drownedEntity = (DrownedEntity)EntityType.field_204724_o.func_200721_a(DrownedNecromancerEntity.this.field_70170_p);
            if (drownedEntity != null) {
                DifficultyInstance difficultyForLocation = DrownedNecromancerEntity.this.field_70170_p.func_175649_E(blockpos);
                drownedEntity.func_174828_a(blockpos, 0.0f, 0.0f);
                ModifiableAttributeInstance spawnReinforcementsAttribute = drownedEntity.func_110148_a(Attributes.field_233829_l_);
                if (spawnReinforcementsAttribute != null) {
                    spawnReinforcementsAttribute.func_111128_a(0.0);
                }
                drownedEntity.func_213386_a((IServerWorld)DrownedNecromancerEntity.this.field_70170_p, difficultyForLocation, SpawnReason.MOB_SUMMONED, (ILivingEntityData)null, (CompoundNBT)null);
                TeamableHelper.makeTeammates((MobEntity)drownedEntity, (MobEntity)DrownedNecromancerEntity.this);
                DrownedNecromancerEntity.this.field_70170_p.func_217376_c((Entity)drownedEntity);
            }
        }

        @Override
        protected int getMagicUseTime() {
            return 100;
        }

        @Override
        protected int getMagicUseInterval() {
            return 340;
        }

        @Override
        @Nullable
        protected SoundEvent getMagicPrepareSound() {
            return SoundEvents.field_187855_gD;
        }

        @Override
        protected MagicType getMagicType() {
            return MagicType.SUMMON_UNDEAD;
        }
    }

    class UsingOceanMagic
    extends UsingMagicGoal<DrownedNecromancerEntity> {
        UsingOceanMagic() {
            super(DrownedNecromancerEntity.this);
        }
    }
}

