/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.water;

import com.infamous.dungeons_mobs.DungeonsGearCompat;
import com.infamous.dungeons_mobs.interfaces.IArmoredMob;
import com.infamous.dungeons_mobs.mod.ModItems;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class ArmoredDrownedEntity
extends DrownedEntity
implements IArmoredMob {
    private static final DataParameter<Boolean> STRONG_ARMOR = EntityDataManager.func_187226_a(ArmoredDrownedEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public ArmoredDrownedEntity(EntityType<? extends ArmoredDrownedEntity> entityType, World world) {
        super(entityType, world);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return ZombieEntity.func_234342_eQ_().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233823_f_, 4.0);
    }

    protected void func_180481_a(DifficultyInstance difficultyInstance) {
        if ((double)this.field_70146_Z.nextFloat() > 0.9) {
            this.setRangedWeapon();
        } else {
            this.setMeleeWeapon();
        }
    }

    private void setRangedWeapon() {
        ItemStack purpleTrident = new ItemStack((IItemProvider)ModItems.PURPLE_TRIDENT.get());
        ItemStack yellowTrident = new ItemStack((IItemProvider)ModItems.YELLOW_TRIDENT.get());
        ItemStack mainhandWeapon = this.hasStrongArmor() ? yellowTrident : purpleTrident;
        this.func_184201_a(EquipmentSlotType.MAINHAND, mainhandWeapon);
    }

    private void setMeleeWeapon() {
        if (DungeonsGearCompat.isLoaded()) {
            ItemStack soulKnife = new ItemStack((IItemProvider)DungeonsGearCompat.getSoulKnife().get());
            ItemStack eternalKnife = new ItemStack((IItemProvider)DungeonsGearCompat.getEternalKnife().get());
            ItemStack mainhandWeapon = this.hasStrongArmor() ? eternalKnife : soulKnife;
            this.func_184201_a(EquipmentSlotType.MAINHAND, mainhandWeapon);
        } else {
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151040_l));
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STRONG_ARMOR, (Object)false);
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.readStrongArmorNBT(p_70037_1_);
    }

    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        this.writeStrongArmorNBT(p_213281_1_);
    }

    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, @Nullable ILivingEntityData p_213386_4_, @Nullable CompoundNBT p_213386_5_) {
        this.designateStrongArmor((LivingEntity)this);
        return super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    @Override
    public boolean hasStrongArmor() {
        return (Boolean)this.field_70180_af.func_187225_a(STRONG_ARMOR);
    }

    @Override
    public void setStrongArmor(boolean strongArmor) {
        this.field_70180_af.func_187227_b(STRONG_ARMOR, (Object)strongArmor);
    }

    @Override
    public String getArmorName() {
        return this.hasStrongArmor() ? "seaweed" : "pale";
    }
}

