/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.undead;

import com.infamous.dungeons_mobs.blocks.WraithFireBlock;
import com.infamous.dungeons_mobs.config.DungeonsMobsConfig;
import com.infamous.dungeons_mobs.entities.magic.MagicType;
import com.infamous.dungeons_mobs.entities.projectiles.WraithFireballEntity;
import com.infamous.dungeons_mobs.goals.magic.MagicAttackGoal;
import com.infamous.dungeons_mobs.goals.magic.UseMagicGoal;
import com.infamous.dungeons_mobs.goals.magic.UsingMagicGoal;
import com.infamous.dungeons_mobs.interfaces.IMagicUser;
import com.infamous.dungeons_mobs.mod.ModBlocks;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FleeSunGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RestrictSunGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.eventbus.api.Event;

public class WraithEntity
extends MonsterEntity
implements IMagicUser {
    private static final DataParameter<Byte> MAGIC = EntityDataManager.func_187226_a(WraithEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private int magicUseTicks;
    private MagicType activeMagic = MagicType.NONE;

    public WraithEntity(World worldIn) {
        super((EntityType)ModEntityTypes.WRAITH.get(), worldIn);
    }

    public WraithEntity(EntityType<? extends WraithEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233819_b_, 64.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, new UsingMagicGoal<WraithEntity>(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new RestrictSunGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FleeSunGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new UseWraithFireMagic());
        this.field_70714_bg.func_75776_a(5, new MagicAttackGoal<WraithEntity>(this, 1.0, 6.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, false));
    }

    public void func_70636_d() {
        if (this.func_70089_S()) {
            boolean canBurnFromSunlight;
            boolean bl = canBurnFromSunlight = this.shouldBurnInDay() && this.func_204609_dp();
            if (canBurnFromSunlight && (canBurnFromSunlight = this.checkSunlightBurnProtection(canBurnFromSunlight))) {
                this.func_70015_d(8);
            }
        }
        super.func_70636_d();
    }

    private boolean checkSunlightBurnProtection(boolean canBurnFromSunlight) {
        ItemStack itemstack = this.func_184582_a(EquipmentSlotType.HEAD);
        if (!itemstack.func_190926_b()) {
            if (itemstack.func_77984_f()) {
                itemstack.func_196085_b(itemstack.func_77952_i() + this.field_70146_Z.nextInt(2));
                if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                    this.func_213361_c(EquipmentSlotType.HEAD);
                    this.func_184201_a(EquipmentSlotType.HEAD, ItemStack.field_190927_a);
                }
            }
            canBurnFromSunlight = false;
        }
        return canBurnFromSunlight;
    }

    private boolean shouldBurnInDay() {
        return true;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187551_bH;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187555_bJ;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187553_bI;
    }

    protected SoundEvent getStepSound() {
        return null;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    private boolean teleportRandomly() {
        if (!this.field_70170_p.func_201670_d() && this.func_70089_S()) {
            boolean hasSuccessfullyTeleported = false;
            for (int teleportAttemptCounter = 0; !hasSuccessfullyTeleported && teleportAttemptCounter < Integer.MAX_VALUE; ++teleportAttemptCounter) {
                double d0 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
                double d1 = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(64) - 32);
                double d2 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
                hasSuccessfullyTeleported = this.teleportWraithTo(d0, d1, d2);
            }
        }
        return false;
    }

    private boolean teleportWraithTo(double x, double y, double z) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(x, y, z);
        while (blockpos$mutable.func_177956_o() > 0 && !this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable).func_185904_a().func_76230_c()) {
            blockpos$mutable.func_189536_c(Direction.DOWN);
        }
        BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable);
        boolean flag = blockstate.func_185904_a().func_76230_c();
        boolean flag1 = blockstate.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
        if (flag && !flag1) {
            EnderTeleportEvent event = new EnderTeleportEvent((LivingEntity)this, x, y, z, 0.0f);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return false;
            }
            boolean flag2 = this.func_213373_a(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2 && !this.func_174814_R()) {
                this.field_70170_p.func_184148_a((PlayerEntity)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
                this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    private boolean shouldWraithTeleportAwayFromTarget(double distanceThreshold) {
        LivingEntity targetEntity = this.func_70638_az();
        boolean wraithTooCloseToTarget = false;
        if (targetEntity != null) {
            boolean bl = wraithTooCloseToTarget = (double)this.func_70032_d((Entity)targetEntity) < distanceThreshold;
        }
        if (wraithTooCloseToTarget) {
            this.teleportRandomly();
        }
        return wraithTooCloseToTarget;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MAGIC, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        IMagicUser.spawnMagicParticles(this);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.magicUseTicks > 0) {
            --this.magicUseTicks;
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.magicUseTicks = compound.func_74762_e("MagicUseTicks");
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("MagicUseTicks", this.magicUseTicks);
    }

    @Override
    public boolean isUsingMagic() {
        if (this.field_70170_p.field_72995_K) {
            return (Byte)this.field_70180_af.func_187225_a(MAGIC) > 0;
        }
        return this.magicUseTicks > 0;
    }

    @Override
    public int getMagicUseTicks() {
        return this.magicUseTicks;
    }

    @Override
    public void setMagicUseTicks(int magicUseTicksIn) {
        this.magicUseTicks = magicUseTicksIn;
    }

    @Override
    public MagicType getMagicType() {
        return !this.field_70170_p.field_72995_K ? this.activeMagic : MagicType.getFromId(((Byte)this.field_70180_af.func_187225_a(MAGIC)).byteValue());
    }

    @Override
    public void setMagicType(MagicType magicType) {
        this.activeMagic = magicType;
        this.field_70180_af.func_187227_b(MAGIC, (Object)((byte)magicType.getId()));
    }

    @Override
    public SoundEvent getMagicSound() {
        return SoundEvents.field_191244_bn;
    }

    class UseWraithFireMagic
    extends UseMagicGoal<WraithEntity> {
        UseWraithFireMagic() {
            super(WraithEntity.this);
        }

        @Override
        public boolean func_75250_a() {
            LivingEntity targetEntity = WraithEntity.this.func_70638_az();
            if (targetEntity == null) {
                return false;
            }
            boolean canTargetBeSeen = WraithEntity.this.func_70685_l((Entity)targetEntity);
            if (canTargetBeSeen && targetEntity.func_70089_S() && (double)WraithEntity.this.func_70032_d((Entity)targetEntity) < 16.0) {
                return super.func_75250_a();
            }
            return false;
        }

        @Override
        public boolean func_75253_b() {
            LivingEntity targetEntity = WraithEntity.this.func_70638_az();
            if (targetEntity == null) {
                return false;
            }
            boolean canTargetBeSeen = WraithEntity.this.func_70685_l((Entity)targetEntity);
            if (canTargetBeSeen && targetEntity.func_70089_S()) {
                return super.func_75253_b();
            }
            return false;
        }

        @Override
        protected void useMagic() {
            LivingEntity targetEntity = WraithEntity.this.func_70638_az();
            if (targetEntity != null) {
                if (((Boolean)DungeonsMobsConfig.COMMON.ENABLE_WRAITH_FIRE_SUMMON.get()).booleanValue()) {
                    this.summonWraithFire(targetEntity);
                } else {
                    this.fireWraithFireballs(targetEntity);
                }
            }
        }

        private void summonWraithFire(LivingEntity targetEntity) {
            BlockPos originalWraithPosition = new BlockPos(WraithEntity.this.func_226277_ct_() + 0.5, WraithEntity.this.func_226278_cu_() + 0.5, WraithEntity.this.func_226281_cx_() + 0.5);
            BlockPos originalTargetPosition = new BlockPos(targetEntity.func_226277_ct_() + 0.5, targetEntity.func_226278_cu_() + 0.5, targetEntity.func_226281_cx_() + 0.5);
            boolean wraithTooCloseToPlayer = WraithEntity.this.shouldWraithTeleportAwayFromTarget(3.0);
            for (int i = 0; i < 9; ++i) {
                double xshift = 0.0;
                double zshift = 0.0;
                if (i == 1 || i == 2 || i == 8) {
                    xshift = 2.0;
                }
                if (i == 4 || i == 5 || i == 6) {
                    xshift = -2.0;
                }
                if (i == 2 || i == 3 || i == 4) {
                    zshift = 2.0;
                }
                if (i == 6 || i == 7 || i == 8) {
                    zshift = -2.0;
                }
                World world = targetEntity.func_130014_f_();
                BlockPos targetBlockPos = this.pickBlockPosForAttack(originalTargetPosition, originalWraithPosition, xshift, zshift, wraithTooCloseToPlayer);
                BlockState blockstate = world.func_180495_p(targetBlockPos);
                BlockState soulFireBlockState = ((WraithFireBlock)ModBlocks.WRAITH_FIRE_BLOCK.get()).func_176223_P();
                boolean canLightBlock = blockstate.func_196958_f();
                if (!canLightBlock) continue;
                world.func_180501_a(targetBlockPos, soulFireBlockState, 11);
            }
        }

        private BlockPos pickBlockPosForAttack(BlockPos originalTargetPosition, BlockPos originalWraithPosition, double xshift, double zshift, boolean wraithTooCloseToPlayer) {
            BlockPos targetBlockPos = new BlockPos((double)originalTargetPosition.func_177958_n() + xshift, (double)originalTargetPosition.func_177956_o(), (double)originalTargetPosition.func_177952_p() + zshift);
            if (wraithTooCloseToPlayer) {
                targetBlockPos = new BlockPos((double)originalWraithPosition.func_177958_n() + xshift, (double)originalWraithPosition.func_177956_o(), (double)originalWraithPosition.func_177952_p() + zshift);
            }
            return targetBlockPos;
        }

        private void fireWraithFireballs(LivingEntity targetEntity) {
            double squareDistanceToTarget = WraithEntity.this.func_70068_e((Entity)targetEntity);
            double xDifference = targetEntity.func_226277_ct_() - WraithEntity.this.func_226277_ct_();
            double yDifference = targetEntity.func_226283_e_(0.5) - WraithEntity.this.func_226283_e_(0.5);
            double zDifference = targetEntity.func_226281_cx_() - WraithEntity.this.func_226281_cx_();
            float f = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)squareDistanceToTarget)) * 0.5f;
            for (int i = 0; i < 3; ++i) {
                WraithFireballEntity wraithFireballEntity = new WraithFireballEntity(WraithEntity.this.field_70170_p, (LivingEntity)WraithEntity.this, xDifference + WraithEntity.this.func_70681_au().nextGaussian() * (double)f, yDifference, zDifference + WraithEntity.this.func_70681_au().nextGaussian() * (double)f);
                wraithFireballEntity.func_70107_b(wraithFireballEntity.func_226277_ct_(), WraithEntity.this.func_226283_e_(0.5) + 0.5, wraithFireballEntity.func_226281_cx_());
                WraithEntity.this.field_70170_p.func_217376_c((Entity)wraithFireballEntity);
            }
            WraithEntity.this.shouldWraithTeleportAwayFromTarget(3.0);
        }

        @Override
        protected int getMagicUseTime() {
            return 40;
        }

        @Override
        protected int getMagicUseInterval() {
            return 100;
        }

        @Override
        @Nullable
        protected SoundEvent getMagicPrepareSound() {
            return SoundEvents.field_187606_E;
        }

        @Override
        protected MagicType getMagicType() {
            return MagicType.WRAITH_FIRE;
        }
    }
}

