/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.undead;

import com.infamous.dungeons_mobs.entities.undead.ArmoredSkeletonEntity;
import com.infamous.dungeons_mobs.goals.switchcombat.ShieldAndMeleeAttackGoal;
import com.infamous.dungeons_mobs.interfaces.IShieldUser;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModItems;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class SkeletonVanguardEntity
extends ArmoredSkeletonEntity
implements IShieldUser {
    private int shieldCooldownTime;

    public SkeletonVanguardEntity(World worldIn) {
        super((EntityType<? extends ArmoredSkeletonEntity>)((EntityType)ModEntityTypes.SKELETON_VANGUARD.get()), worldIn);
    }

    public SkeletonVanguardEntity(EntityType<? extends SkeletonVanguardEntity> p_i48555_1_, World p_i48555_2_) {
        super(p_i48555_1_, p_i48555_2_);
        this.shieldCooldownTime = 0;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(4, (Goal)new GuardAndAttackGoal(this, 1.2, false));
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return ArmoredSkeletonEntity.setCustomAttributes().func_233815_a_(Attributes.field_233826_i_, 6.0);
    }

    @Override
    protected void func_180481_a(DifficultyInstance difficultyInstance) {
        if (ModList.get().isLoaded("dungeons_gear")) {
            Item GLAIVE = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("dungeons_gear", "glaive"));
            ItemStack glaive = new ItemStack((IItemProvider)GLAIVE);
            this.func_184201_a(EquipmentSlotType.MAINHAND, glaive);
        } else {
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151040_l));
        }
        this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)ModItems.SKELETON_VANGUARD_HELMET.get()));
        this.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)ModItems.SKELETON_VANGUARD_SHIELD.get()));
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData livingEntityDataIn, @Nullable CompoundNBT compoundNBT) {
        livingEntityDataIn = super.func_213386_a(world, difficultyInstance, spawnReason, livingEntityDataIn, compoundNBT);
        return livingEntityDataIn;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187854_fc;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187864_fh;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187856_fd;
    }

    @Override
    protected SoundEvent func_190727_o() {
        return SoundEvents.field_187868_fj;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.shieldCooldownTime > 0) {
            --this.shieldCooldownTime;
        } else if (this.shieldCooldownTime < 0) {
            this.shieldCooldownTime = 0;
        }
    }

    protected void func_184581_c(DamageSource damageSource) {
        if (this.func_184585_cz()) {
            this.func_184185_a(SoundEvents.field_187767_eL, 1.0f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
        } else {
            super.func_184581_c(damageSource);
        }
    }

    public void func_190629_c(LivingEntity livingEntity) {
        super.func_190629_c(livingEntity);
        if (livingEntity.func_184614_ca().canDisableShield(this.field_184627_bm, (LivingEntity)this, livingEntity)) {
            this.disableShield(true);
        }
    }

    protected void func_184590_k(float amount) {
        if (this.field_184627_bm.isShield((LivingEntity)this) && amount >= 3.0f) {
            int i = 1 + MathHelper.func_76141_d((float)amount);
            Hand hand = this.func_184600_cs();
            this.field_184627_bm.func_222118_a(i, (LivingEntity)this, skeletonVanguardEntity -> skeletonVanguardEntity.func_213334_d(hand));
            if (this.field_184627_bm.func_190926_b()) {
                if (hand == Hand.MAIN_HAND) {
                    this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                } else {
                    this.func_184201_a(EquipmentSlotType.OFFHAND, ItemStack.field_190927_a);
                }
                this.field_184627_bm = ItemStack.field_190927_a;
                this.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
        }
    }

    @Override
    public int getShieldCooldownTime() {
        return this.shieldCooldownTime;
    }

    @Override
    public void setShieldCooldownTime(int shieldCooldownTime) {
        this.shieldCooldownTime = shieldCooldownTime;
    }

    @Override
    public void disableShield(boolean guaranteeDisable) {
        float f = 0.25f + (float)EnchantmentHelper.func_185293_e((LivingEntity)this) * 0.05f;
        if (guaranteeDisable) {
            f += 0.75f;
        }
        if (this.field_70146_Z.nextFloat() < f) {
            this.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            this.shieldCooldownTime = 100;
            this.func_184602_cy();
            this.field_70170_p.func_72960_a((Entity)this, (byte)30);
        }
    }

    @Override
    public boolean isShieldDisabled() {
        return this.shieldCooldownTime > 0;
    }

    static class GuardAndAttackGoal
    extends ShieldAndMeleeAttackGoal {
        GuardAndAttackGoal(SkeletonVanguardEntity skeletonVanguardEntity, double speedTowardsTarget, boolean useLongMemory) {
            super(skeletonVanguardEntity, speedTowardsTarget, useLongMemory, 3.0, 40, 5);
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            if (ModList.get().isLoaded("dungeons_gear")) {
                boolean isHoldingGlaive;
                Item GLAIVE = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("dungeons_gear", "glaive"));
                Item VENOM_GLAIVE = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("dungeons_gear", "venom_glaive"));
                Item GRAVE_BANE = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("dungeons_gear", "grave_bane"));
                boolean bl = isHoldingGlaive = this.field_75441_b.func_184614_ca().func_77973_b() == GLAIVE || this.field_75441_b.func_184614_ca().func_77973_b() == VENOM_GLAIVE || this.field_75441_b.func_184614_ca().func_77973_b() == GRAVE_BANE;
                if (isHoldingGlaive) {
                    float glaiveAttackReach = 3.0f;
                    float attackerWidthSquaredTimes4 = this.field_75441_b.func_213311_cf() * glaiveAttackReach * this.field_75441_b.func_213311_cf() * glaiveAttackReach;
                    return attackerWidthSquaredTimes4 + attackTarget.func_213311_cf();
                }
            }
            return super.func_179512_a(attackTarget);
        }
    }
}

