/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.piglin.ai;

import com.google.common.collect.ImmutableList;
import com.infamous.dungeons_mobs.entities.piglin.FungusThrowerEntity;
import com.infamous.dungeons_mobs.entities.projectiles.BlueNethershroomEntity;
import com.infamous.dungeons_mobs.items.BlueNethershroomItem;
import com.infamous.dungeons_mobs.tasks.ThrowAtTargetTask;
import com.infamous.dungeons_mobs.utils.BrainHelper;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.task.AttackStrafingTask;
import net.minecraft.entity.ai.brain.task.SupplementedTask;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class FungusThrowerAi {
    public static final Predicate<Item> FUNGUS_ITEM_PREDICATE = item -> item instanceof BlueNethershroomItem;

    public static <E extends FungusThrowerEntity> void addFungusThrowerTasks(Brain<E> brain) {
        ImmutableList additionalFightTasks = ImmutableList.of((Object)new SupplementedTask(FungusThrowerAi::hasBlueNethershroom, (Task)new AttackStrafingTask(6, 0.75f)), new ThrowAtTargetTask<FungusThrowerEntity>(FUNGUS_ITEM_PREDICATE, FungusThrowerAi::performFungusThrow));
        int priorityStart = 7;
        ImmutableList prioritizedFightTasks = BrainHelper.createPriorityPairs(priorityStart, additionalFightTasks);
        BrainHelper.addPrioritizedBehaviors(Activity.field_234621_k_, prioritizedFightTasks, brain);
    }

    public static void performFungusThrow(LivingEntity fungusThrower, LivingEntity attackTarget) {
        Vector3d targetDeltaMove = attackTarget.func_213322_ci();
        double xDiff = attackTarget.func_226277_ct_() + targetDeltaMove.field_72450_a - fungusThrower.func_226277_ct_();
        double yDiff = attackTarget.func_226278_cu_() - fungusThrower.func_226278_cu_();
        double zDiff = attackTarget.func_226281_cx_() + targetDeltaMove.field_72449_c - fungusThrower.func_226281_cx_();
        float horizDistSq = MathHelper.func_76133_a((double)(xDiff * xDiff + zDiff * zDiff));
        BlueNethershroomEntity blueNethershroom = new BlueNethershroomEntity(fungusThrower.field_70170_p, fungusThrower);
        ItemStack blueNethershroomStack = blueNethershroom.func_184543_l();
        BlueNethershroomEntity.setLightBluePotionColor(blueNethershroomStack);
        blueNethershroom.func_213884_b(PotionUtils.func_185188_a((ItemStack)blueNethershroomStack, (Potion)Potions.field_185254_z));
        blueNethershroom.field_70125_A -= -20.0f;
        blueNethershroom.func_70186_c(xDiff, yDiff + (double)(horizDistSq * 0.2f), zDiff, 0.75f, 8.0f);
        if (!fungusThrower.func_174814_R()) {
            fungusThrower.field_70170_p.func_184148_a((PlayerEntity)null, fungusThrower.func_226277_ct_(), fungusThrower.func_226278_cu_(), fungusThrower.func_226281_cx_(), SoundEvents.field_232751_iT_, fungusThrower.func_184176_by(), 1.0f, 0.8f + fungusThrower.func_70681_au().nextFloat() * 0.4f);
        }
        fungusThrower.field_70170_p.func_217376_c((Entity)blueNethershroom);
        fungusThrower.func_184609_a(ProjectileHelper.getWeaponHoldingHand((LivingEntity)fungusThrower, FUNGUS_ITEM_PREDICATE));
    }

    private static boolean hasBlueNethershroom(LivingEntity living) {
        return living.func_233634_a_(FUNGUS_ITEM_PREDICATE);
    }

    public static boolean isBlueNethershroom(ItemStack itemStack) {
        return FUNGUS_ITEM_PREDICATE.test(itemStack.func_77973_b());
    }
}

