/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.jungle;

import com.infamous.dungeons_mobs.entities.jungle.PoisonQuillVineEntity;
import com.infamous.dungeons_mobs.entities.jungle.QuickGrowingVineEntity;
import com.infamous.dungeons_mobs.entities.jungle.VineEntity;
import com.infamous.dungeons_mobs.entities.magic.MagicType;
import com.infamous.dungeons_mobs.goals.magic.UseMagicGoal;
import com.infamous.dungeons_mobs.goals.magic.UsingMagicGoal;
import com.infamous.dungeons_mobs.interfaces.IMagicUser;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.utils.GeomancyHelper;
import java.util.Random;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.world.World;

public class WhispererEntity
extends MonsterEntity
implements IMagicUser {
    private static final DataParameter<Byte> MAGIC = EntityDataManager.func_187226_a(WhispererEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private int magicUseTicks;
    private MagicType activeMagic = MagicType.NONE;

    public WhispererEntity(World worldIn) {
        super((EntityType)ModEntityTypes.WHISPERER.get(), worldIn);
    }

    public WhispererEntity(EntityType<? extends WhispererEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.addMovementBehaviors();
        this.field_70714_bg.func_75776_a(1, new UsingMagicGoal<WhispererEntity>(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new SummonVinesGoal());
        this.field_70714_bg.func_75776_a(3, (Goal)new AttackGoal());
        this.field_70714_bg.func_75776_a(4, (Goal)new AvoidEntityGoal((CreatureEntity)this, VineEntity.class, 8.0f, 0.6, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{WhispererEntity.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, false));
    }

    protected void addMovementBehaviors() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.6));
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.5).func_233815_a_(Attributes.field_233819_b_, 12.0).func_233815_a_(Attributes.field_233818_a_, 24.0).func_233815_a_(Attributes.field_233823_f_, 5.0);
    }

    protected EntityType<? extends QuickGrowingVineEntity> getQuickGrowingVineType() {
        return (EntityType)ModEntityTypes.QUICK_GROWING_VINE.get();
    }

    protected EntityType<? extends PoisonQuillVineEntity> getPoisonVineType() {
        return (EntityType)ModEntityTypes.POISON_QUILL_VINE.get();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MAGIC, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        IMagicUser.spawnMagicParticles(this);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.magicUseTicks > 0) {
            --this.magicUseTicks;
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.magicUseTicks = compound.func_74762_e("MagicUseTicks");
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("MagicUseTicks", this.magicUseTicks);
    }

    @Override
    public boolean isUsingMagic() {
        if (this.field_70170_p.field_72995_K) {
            return (Byte)this.field_70180_af.func_187225_a(MAGIC) > 0;
        }
        return this.magicUseTicks > 0;
    }

    @Override
    public int getMagicUseTicks() {
        return this.magicUseTicks;
    }

    @Override
    public void setMagicUseTicks(int magicUseTicksIn) {
        this.magicUseTicks = magicUseTicksIn;
    }

    @Override
    public MagicType getMagicType() {
        return !this.field_70170_p.field_72995_K ? this.activeMagic : MagicType.getFromId(((Byte)this.field_70180_af.func_187225_a(MAGIC)).byteValue());
    }

    @Override
    public void setMagicType(MagicType magicType) {
        this.activeMagic = magicType;
        this.field_70180_af.func_187227_b(MAGIC, (Object)((byte)magicType.getId()));
    }

    @Override
    public SoundEvent getMagicSound() {
        return SoundEvents.field_191244_bn;
    }

    class SummonVinesGoal
    extends UseMagicGoal<WhispererEntity> {
        private SummonVinesGoal() {
            super(WhispererEntity.this);
        }

        @Override
        public boolean func_75250_a() {
            LivingEntity targetEntity = WhispererEntity.this.func_70638_az();
            if (targetEntity != null && WhispererEntity.this.func_70068_e((Entity)targetEntity) >= 16.0) {
                return super.func_75250_a();
            }
            return false;
        }

        @Override
        protected int getMagicUseTime() {
            return 40;
        }

        @Override
        protected int getMagicUseInterval() {
            return 140;
        }

        @Override
        protected void useMagic() {
            LivingEntity targetEntity = WhispererEntity.this.func_70638_az();
            if (targetEntity != null) {
                if (WhispererEntity.this.func_70681_au().nextFloat() < 0.25f) {
                    GeomancyHelper.summonOffensiveVine((LivingEntity)WhispererEntity.this, (LivingEntity)WhispererEntity.this, WhispererEntity.this.getPoisonVineType());
                } else {
                    int[] rowToRemove = (int[])Util.func_240989_a_((Object[])GeomancyHelper.ROWS, (Random)WhispererEntity.this.func_70681_au());
                    GeomancyHelper.summonAreaDenialVineTrap(targetEntity, targetEntity, WhispererEntity.this.getQuickGrowingVineType(), rowToRemove);
                }
            }
        }

        @Override
        protected SoundEvent getMagicPrepareSound() {
            return SoundEvents.field_191248_br;
        }

        @Override
        protected MagicType getMagicType() {
            return MagicType.SUMMON_VINES;
        }
    }

    class AttackGoal
    extends MeleeAttackGoal {
        private AttackGoal() {
            super((CreatureEntity)WhispererEntity.this, 1.0, false);
        }

        public boolean func_75250_a() {
            LivingEntity targetEntity = WhispererEntity.this.func_70638_az();
            if (targetEntity != null && WhispererEntity.this.func_70068_e((Entity)targetEntity) < 16.0) {
                return super.func_75250_a();
            }
            return false;
        }
    }
}

