/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.jungle;

import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import java.util.EnumSet;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.JumpGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LeapleafEntity
extends MonsterEntity {
    private static final DataParameter<Boolean> IS_STALKING = EntityDataManager.func_187226_a(LeapleafEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_CROUCHING = EntityDataManager.func_187226_a(LeapleafEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_LEAPING = EntityDataManager.func_187226_a(LeapleafEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private float primaryCrouchAmount;
    private float secondaryCrouchAmount;

    public LeapleafEntity(World world) {
        super((EntityType)ModEntityTypes.LEAPLEAF.get(), world);
    }

    public LeapleafEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70749_g = new LookHelperController();
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 20;
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 100.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233823_f_, 15.0).func_233815_a_(Attributes.field_233824_g_, 1.5);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(2, (Goal)new StalkGoal());
        this.field_70714_bg.func_75776_a(3, (Goal)new LeapGoal());
        this.field_70714_bg.func_75776_a(4, (Goal)new AttackGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.4f));
        this.field_70714_bg.func_75776_a(6, (Goal)new WatchGoal((MobEntity)this, PlayerEntity.class, 24.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{LeapleafEntity.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_STALKING, (Object)false);
        this.field_70180_af.func_187214_a(IS_CROUCHING, (Object)false);
        this.field_70180_af.func_187214_a(IS_LEAPING, (Object)false);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.tickCrouch();
    }

    private void tickCrouch() {
        this.secondaryCrouchAmount = this.primaryCrouchAmount;
        if (this.func_213453_ef()) {
            this.primaryCrouchAmount += 0.2f;
            if (this.primaryCrouchAmount > 3.0f) {
                this.primaryCrouchAmount = 3.0f;
            }
        } else {
            this.primaryCrouchAmount = 0.0f;
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Crouching", this.func_213453_ef());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setCrouching(compound.func_74767_n("Crouching"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getCrouchRotationPointYAddition(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.secondaryCrouchAmount, (float)this.primaryCrouchAmount);
    }

    public boolean canLeap() {
        return this.primaryCrouchAmount == 3.0f;
    }

    public void setStalking(boolean isStalking) {
        this.field_70180_af.func_187227_b(IS_STALKING, (Object)isStalking);
    }

    public boolean isStalking() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_STALKING);
    }

    public void setCrouching(boolean isCrouching) {
        this.field_70180_af.func_187227_b(IS_CROUCHING, (Object)isCrouching);
    }

    public boolean isLeaping() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_LEAPING);
    }

    public void setLeaping(boolean isLeaping) {
        this.field_70180_af.func_187227_b(IS_LEAPING, (Object)isLeaping);
    }

    public static boolean canLeapTowardsTarget(LeapleafEntity leapleafEntity, LivingEntity targetEntity) {
        double zDifference = targetEntity.func_226281_cx_() - leapleafEntity.func_226281_cx_();
        double xDifference = targetEntity.func_226277_ct_() - leapleafEntity.func_226277_ct_();
        double zToXRatio = zDifference / xDifference;
        int leapDistance = 6;
        int leapHeight = 4;
        for (int horizontalAddition = 0; horizontalAddition < leapDistance; ++horizontalAddition) {
            double zAddition = zToXRatio == 0.0 ? 0.0 : zDifference * (double)((float)horizontalAddition / (float)leapDistance);
            double xAddition = zToXRatio == 0.0 ? xDifference * (double)((float)horizontalAddition / (float)leapDistance) : zAddition / zToXRatio;
            for (int yAddition = 1; yAddition < leapHeight; ++yAddition) {
                if (leapleafEntity.field_70170_p.func_180495_p(new BlockPos(leapleafEntity.func_226277_ct_() + xAddition, leapleafEntity.func_226278_cu_() + (double)yAddition, leapleafEntity.func_226281_cx_() + zAddition)).func_185904_a().func_76222_j()) continue;
                return false;
            }
        }
        return true;
    }

    class WatchGoal
    extends LookAtGoal {
        public WatchGoal(MobEntity p_i50733_2_, Class<? extends LivingEntity> p_i50733_3_, float p_i50733_4_) {
            super(p_i50733_2_, p_i50733_3_, p_i50733_4_);
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !LeapleafEntity.this.isStalking();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && !LeapleafEntity.this.isStalking();
        }
    }

    class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal() {
            super((CreatureEntity)LeapleafEntity.this, (double)1.2f, false);
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            float adjustedAttackerWidth = LeapleafEntity.this.func_213311_cf() - 0.8f;
            float attackerWidthSquaredTimes4 = adjustedAttackerWidth * 2.0f * adjustedAttackerWidth * 2.0f;
            return attackerWidthSquaredTimes4 + attackTarget.func_213311_cf();
        }

        public void func_75249_e() {
            LeapleafEntity.this.setStalking(false);
            super.func_75249_e();
        }

        public boolean func_75250_a() {
            return !LeapleafEntity.this.func_70608_bn() && !LeapleafEntity.this.func_213453_ef() && super.func_75250_a();
        }
    }

    class LeapGoal
    extends JumpGoal {
        LeapGoal() {
        }

        public boolean func_75250_a() {
            if (!LeapleafEntity.this.canLeap()) {
                return false;
            }
            LivingEntity livingentity = LeapleafEntity.this.func_70638_az();
            if (livingentity != null && livingentity.func_70089_S()) {
                if (livingentity.func_184172_bi() != livingentity.func_174811_aO()) {
                    return false;
                }
                boolean canLeapTowardsTarget = LeapleafEntity.canLeapTowardsTarget(LeapleafEntity.this, livingentity);
                if (!canLeapTowardsTarget) {
                    LeapleafEntity.this.func_70661_as().func_75494_a((Entity)livingentity, 0);
                    LeapleafEntity.this.setCrouching(false);
                    LeapleafEntity.this.setStalking(false);
                }
                return canLeapTowardsTarget;
            }
            return false;
        }

        public boolean func_75253_b() {
            LivingEntity livingentity = LeapleafEntity.this.func_70638_az();
            if (livingentity != null && livingentity.func_70089_S()) {
                double d0 = LeapleafEntity.this.func_213322_ci().field_72448_b;
                return !(d0 * d0 < (double)0.05f) || !(Math.abs(LeapleafEntity.this.field_70125_A) < 15.0f) || !LeapleafEntity.this.field_70122_E;
            }
            return false;
        }

        public boolean func_220685_C_() {
            return false;
        }

        public void func_75249_e() {
            LeapleafEntity.this.func_70637_d(true);
            LeapleafEntity.this.setLeaping(true);
            LeapleafEntity.this.setStalking(false);
            LivingEntity attackTarget = LeapleafEntity.this.func_70638_az();
            if (attackTarget != null) {
                LeapleafEntity.this.func_70671_ap().func_75651_a((Entity)attackTarget, 60.0f, 30.0f);
                Vector3d vector3d = new Vector3d(attackTarget.func_226277_ct_() - LeapleafEntity.this.func_226277_ct_(), attackTarget.func_226278_cu_() - LeapleafEntity.this.func_226278_cu_(), attackTarget.func_226281_cx_() - LeapleafEntity.this.func_226281_cx_()).func_72432_b();
                LeapleafEntity.this.func_213317_d(LeapleafEntity.this.func_213322_ci().func_72441_c(vector3d.field_72450_a * 0.8, 0.9, vector3d.field_72449_c * 0.8));
                LeapleafEntity.this.func_70661_as().func_75499_g();
            }
        }

        public void func_75251_c() {
            LeapleafEntity.this.setCrouching(false);
            LeapleafEntity.this.primaryCrouchAmount = 0.0f;
            LeapleafEntity.this.secondaryCrouchAmount = 0.0f;
            LeapleafEntity.this.setStalking(false);
            LeapleafEntity.this.setLeaping(false);
        }

        public void func_75246_d() {
            LivingEntity attackTarget = LeapleafEntity.this.func_70638_az();
            if (attackTarget != null) {
                LeapleafEntity.this.func_70671_ap().func_75651_a((Entity)attackTarget, 60.0f, 30.0f);
            }
            if (attackTarget != null && LeapleafEntity.this.func_70068_e((Entity)attackTarget) <= 4.0) {
                LeapleafEntity.this.func_70652_k((Entity)attackTarget);
            }
        }
    }

    class StalkGoal
    extends Goal {
        public StalkGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            if (LeapleafEntity.this.func_70608_bn()) {
                return false;
            }
            LivingEntity livingentity = LeapleafEntity.this.func_70638_az();
            return livingentity != null && livingentity.func_70089_S() && LeapleafEntity.this.func_70068_e((Entity)livingentity) > 36.0 && !LeapleafEntity.this.func_213453_ef() && !LeapleafEntity.this.isStalking() && !LeapleafEntity.this.field_70703_bu;
        }

        public void func_75249_e() {
        }

        public void func_75251_c() {
            LivingEntity livingentity = LeapleafEntity.this.func_70638_az();
            if (livingentity != null && LeapleafEntity.canLeapTowardsTarget(LeapleafEntity.this, livingentity)) {
                LeapleafEntity.this.setStalking(true);
                LeapleafEntity.this.setCrouching(true);
                LeapleafEntity.this.func_70661_as().func_75499_g();
                LeapleafEntity.this.func_70671_ap().func_75651_a((Entity)livingentity, (float)LeapleafEntity.this.func_184649_cE(), (float)LeapleafEntity.this.func_70646_bf());
            } else {
                LeapleafEntity.this.setStalking(false);
                LeapleafEntity.this.setCrouching(false);
            }
        }

        public void func_75246_d() {
            LivingEntity livingentity = LeapleafEntity.this.func_70638_az();
            if (livingentity != null) {
                LeapleafEntity.this.func_70671_ap().func_75651_a((Entity)livingentity, (float)LeapleafEntity.this.func_184649_cE(), (float)LeapleafEntity.this.func_70646_bf());
                if (LeapleafEntity.this.func_70068_e((Entity)livingentity) <= 36.0) {
                    LeapleafEntity.this.setStalking(true);
                    LeapleafEntity.this.setCrouching(true);
                    LeapleafEntity.this.func_70661_as().func_75499_g();
                } else {
                    LeapleafEntity.this.func_70661_as().func_75497_a((Entity)livingentity, 1.5);
                }
            }
        }
    }

    public class LookHelperController
    extends LookController {
        private LookHelperController() {
            super((MobEntity)LeapleafEntity.this);
        }

        protected boolean func_220680_b() {
            return !LeapleafEntity.this.isStalking() && !LeapleafEntity.this.func_213453_ef() && !LeapleafEntity.this.isLeaping();
        }
    }
}

