/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.illagers;

import com.infamous.dungeons_mobs.capabilities.cloneable.CloneableHelper;
import com.infamous.dungeons_mobs.capabilities.cloneable.ICloneable;
import com.infamous.dungeons_mobs.entities.illagers.IllusionerCloneEntity;
import com.infamous.dungeons_mobs.mixin.GoalSelectorAccessor;
import com.infamous.dungeons_mobs.utils.ModProjectileHelper;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.IllusionerEntity;
import net.minecraft.entity.monster.SpellcastingIllagerEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.item.BowItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DungeonsIllusionerEntity
extends IllusionerEntity
implements IRangedAttackMob {
    public DungeonsIllusionerEntity(EntityType<? extends DungeonsIllusionerEntity> entityType, World world) {
        super(entityType, world);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        ((GoalSelectorAccessor)this.field_70714_bg).getAvailableGoals().removeIf(pg -> pg.func_220770_h() == 4 && pg.func_220772_j() instanceof SpellcastingIllagerEntity.UseSpellGoal);
        this.field_70714_bg.func_75776_a(4, (Goal)new MirrorSpellGoal());
    }

    @OnlyIn(value=Dist.CLIENT)
    public AbstractIllagerEntity.ArmPose func_193077_p() {
        if (this.func_193082_dl()) {
            return AbstractIllagerEntity.ArmPose.SPELLCASTING;
        }
        if (this.func_213398_dR()) {
            if (this.func_233634_a_(item -> item instanceof BowItem)) {
                return AbstractIllagerEntity.ArmPose.BOW_AND_ARROW;
            }
            return AbstractIllagerEntity.ArmPose.ATTACKING;
        }
        return AbstractIllagerEntity.ArmPose.CROSSED;
    }

    public void func_82196_d(LivingEntity target, float p_82196_2_) {
        ItemStack fireworkRocket = ModProjectileHelper.createRocket(DyeColor.PINK);
        FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity(this.field_70170_p, fireworkRocket, (Entity)this, this.func_226277_ct_(), this.func_226280_cw_() - (double)0.15f, this.func_226281_cx_(), true);
        double xDifference = target.func_226277_ct_() - this.func_226277_ct_();
        double yDifference = target.func_226283_e_(0.3333333333333333) - fireworkrocketentity.func_226278_cu_();
        double zDifference = target.func_226281_cx_() - this.func_226281_cx_();
        double horizontalDifference = MathHelper.func_76133_a((double)(xDifference * xDifference + zDifference * zDifference));
        fireworkrocketentity.func_70186_c(xDifference, yDifference + horizontalDifference * (double)0.2f, zDifference, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)fireworkrocketentity);
    }

    public void func_70645_a(DamageSource damageSource) {
        ICloneable cloneable = CloneableHelper.getCloneableCapability((Entity)this);
        if (cloneable != null && this.field_70170_p instanceof ServerWorld) {
            UUID[] cloneUUIDs = cloneable.getClones();
            for (int i = 0; i < cloneUUIDs.length; ++i) {
                UUID currentCloneUUID = cloneUUIDs[i];
                if (currentCloneUUID == null) continue;
                ServerWorld serverWorld = (ServerWorld)this.field_70170_p;
                Entity clone = serverWorld.func_217461_a(currentCloneUUID);
                if (clone != null) {
                    clone.func_70106_y();
                }
                cloneUUIDs[i] = null;
            }
        }
    }

    class MirrorSpellGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        private MirrorSpellGoal() {
            super((SpellcastingIllagerEntity)DungeonsIllusionerEntity.this);
        }

        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            return !DungeonsIllusionerEntity.this.func_70644_a(Effects.field_76441_p);
        }

        protected int func_190869_f() {
            return 20;
        }

        protected int func_190872_i() {
            return 340;
        }

        protected void func_190868_j() {
            DungeonsIllusionerEntity.this.func_195064_c(new EffectInstance(Effects.field_76441_p, 1200));
            this.summonIllusionerClones();
        }

        private void summonIllusionerClones() {
            int difficultyAsInt = DungeonsIllusionerEntity.this.field_70170_p.func_175659_aa().func_151525_a();
            int mobsToSummon = difficultyAsInt * 2 + 1;
            for (int i = 0; i < mobsToSummon; ++i) {
                BlockPos blockpos = DungeonsIllusionerEntity.this.func_233580_cy_().func_177982_a(-2 + DungeonsIllusionerEntity.this.func_70681_au().nextInt(5), 1, -2 + DungeonsIllusionerEntity.this.func_70681_au().nextInt(5));
                IllusionerCloneEntity illusionerCloneEntity = new IllusionerCloneEntity(DungeonsIllusionerEntity.this.field_70170_p, (LivingEntity)DungeonsIllusionerEntity.this, 600);
                DifficultyInstance difficultyForLocation = DungeonsIllusionerEntity.this.field_70170_p.func_175649_E(blockpos);
                illusionerCloneEntity.func_174828_a(blockpos, 0.0f, 0.0f);
                illusionerCloneEntity.func_213386_a((IServerWorld)illusionerCloneEntity.field_70170_p, difficultyForLocation, SpawnReason.MOB_SUMMONED, null, null);
                DungeonsIllusionerEntity.this.field_70170_p.func_217376_c((Entity)illusionerCloneEntity);
                ICloneable cloneable = CloneableHelper.getCloneableCapability((Entity)DungeonsIllusionerEntity.this);
                if (cloneable == null) continue;
                cloneable.addClone(illusionerCloneEntity.func_110124_au());
            }
        }

        @Nullable
        protected SoundEvent func_190871_k() {
            return SoundEvents.field_193790_di;
        }

        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.DISAPPEAR;
        }
    }
}

