/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.layer;

import com.infamous.dungeons_mobs.client.models.FungusSackModel;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class FungusSackLayer<T extends LivingEntity, M extends EntityModel<T>>
extends LayerRenderer<T, M> {
    private static final ResourceLocation SACK_LOCATION = new ResourceLocation("dungeons_mobs", "textures/entity/fungus_sack.png");
    private final FungusSackModel<T> fungusSackModel = new FungusSackModel();

    public FungusSackLayer(IEntityRenderer<T, M> entityRenderer) {
        super(entityRenderer);
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int p_225628_3_, T wearer, float p_225628_5_, float p_225628_6_, float p_225628_7_, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
        ItemStack itemstack = this.getSackItem(wearer);
        if (this.shouldRender(itemstack, wearer)) {
            ResourceLocation resourcelocation = this.getSackTexture(itemstack, wearer);
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.0, 0.0);
            this.func_215332_c().func_217111_a(this.fungusSackModel);
            this.fungusSackModel.setupAnim(wearer, p_225628_5_, p_225628_6_, p_225628_8_, p_225628_9_, p_225628_10_);
            IVertexBuilder ivertexbuilder = ItemRenderer.func_239386_a_((IRenderTypeBuffer)renderTypeBuffer, (RenderType)RenderType.func_239263_a_((ResourceLocation)resourcelocation), (boolean)false, (boolean)false);
            this.fungusSackModel.func_225598_a_(matrixStack, ivertexbuilder, p_225628_3_, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.func_227865_b_();
        }
    }

    private ItemStack getSackItem(T wearer) {
        return ItemStack.field_190927_a;
    }

    public boolean shouldRender(ItemStack stack, T entity) {
        return true;
    }

    public ResourceLocation getSackTexture(ItemStack stack, T entity) {
        return SACK_LOCATION;
    }
}

