/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.models.redstone;

import com.google.common.collect.ImmutableList;
import com.infamous.dungeons_mobs.entities.redstone.RedstoneGolemEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelHelper;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RedstoneGolemModel<T extends RedstoneGolemEntity>
extends SegmentedModel<T> {
    private final ModelRenderer body;
    private final ModelRenderer rightArm;
    private final ModelRenderer leftArm;
    private final ModelRenderer rightLeg;
    private final ModelRenderer leftLeg;

    public RedstoneGolemModel() {
        this.field_78090_t = 256;
        this.field_78089_u = 256;
        this.body = new ModelRenderer((Model)this);
        this.body.func_78793_a(0.0f, 0.5f, 2.0f);
        this.setRotationAngle(this.body, 1.5708f, 0.0f, 0.0f);
        this.body.func_78784_a(0, 28).func_228303_a_(-20.0f, -13.0f, 5.0f, 40.0f, 20.0f, 32.0f, 0.0f, false);
        this.body.func_78784_a(72, 6).func_228303_a_(-11.0f, -9.0f, -3.0f, 22.0f, 14.0f, 8.0f, 0.0f, false);
        this.body.func_78784_a(0, 0).func_228303_a_(-8.0f, -25.0f, 21.0f, 16.0f, 12.0f, 16.0f, 0.0f, false);
        this.body.func_78784_a(132, 16).func_228303_a_(-8.0f, -5.0f, 9.0f, 16.0f, 16.0f, 16.0f, 0.0f, false);
        this.leftLeg = new ModelRenderer((Model)this);
        this.leftLeg.func_78793_a(8.0f, -14.0f, 15.0f);
        this.leftLeg.func_78784_a(192, 48).func_228303_a_(1.0f, 18.0f, -19.5f, 12.0f, 20.0f, 12.0f, 0.0f, false);
        this.rightLeg = new ModelRenderer((Model)this);
        this.rightLeg.func_78793_a(20.0f, -13.0f, 20.0f);
        this.rightLeg.func_78784_a(144, 48).func_228303_a_(-40.0f, 17.0f, -24.5f, 12.0f, 20.0f, 12.0f, 0.0f, false);
        this.leftArm = new ModelRenderer((Model)this);
        this.leftArm.func_78793_a(8.0f, -26.0f, -3.5f);
        this.leftArm.func_78784_a(31, 116).func_228303_a_(12.0f, -9.0f, -2.0f, 14.0f, 24.0f, 12.0f, 0.0f, false);
        this.leftArm.func_78784_a(83, 118).func_228303_a_(17.0f, 15.0f, -2.0f, 11.0f, 22.0f, 12.0f, 0.0f, false);
        this.leftArm.func_78784_a(145, 80).func_228303_a_(23.0f, 37.0f, -1.0f, 3.0f, 10.0f, 5.0f, 0.0f, false);
        this.leftArm.func_78784_a(145, 80).func_228303_a_(23.0f, 37.0f, 5.0f, 3.0f, 10.0f, 5.0f, 0.0f, false);
        this.leftArm.func_78784_a(129, 82).func_228303_a_(17.0f, 37.0f, -1.0f, 3.0f, 8.0f, 5.0f, 0.0f, false);
        this.rightArm = new ModelRenderer((Model)this);
        this.rightArm.func_78793_a(-8.0f, -26.0f, -3.5f);
        this.rightArm.func_78784_a(129, 82).func_228303_a_(-20.0f, 37.0f, -1.0f, 3.0f, 8.0f, 5.0f, 0.0f, false);
        this.rightArm.func_78784_a(83, 82).func_228303_a_(-28.0f, 15.0f, -2.0f, 11.0f, 22.0f, 12.0f, 0.0f, false);
        this.rightArm.func_78784_a(145, 80).func_228303_a_(-26.0f, 37.0f, -1.0f, 3.0f, 10.0f, 5.0f, 0.0f, false);
        this.rightArm.func_78784_a(145, 80).func_228303_a_(-26.0f, 37.0f, 5.0f, 3.0f, 10.0f, 5.0f, 0.0f, false);
        this.rightArm.func_78784_a(31, 80).func_228303_a_(-26.0f, -9.0f, -2.0f, 14.0f, 24.0f, 12.0f, 0.0f, false);
    }

    public Iterable<ModelRenderer> func_225601_a_() {
        return ImmutableList.of((Object)this.body, (Object)this.rightArm, (Object)this.leftArm, (Object)this.rightLeg, (Object)this.leftLeg);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.field_78796_g = 0.0f;
        this.rightArm.field_78798_e = -3.5f;
        this.rightArm.field_78800_c = -8.0f;
        this.leftArm.field_78798_e = -3.5f;
        this.leftArm.field_78800_c = 8.0f;
        this.rightArm.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount;
        this.leftArm.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount;
        this.rightArm.field_78808_h = 0.0f;
        this.leftArm.field_78808_h = 0.0f;
        this.rightLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.leftLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        this.rightLeg.field_78796_g = 0.0f;
        this.leftLeg.field_78796_g = 0.0f;
        this.rightLeg.field_78808_h = 0.0f;
        this.leftLeg.field_78808_h = 0.0f;
        this.rightArm.field_78796_g = 0.0f;
        this.leftArm.field_78796_g = 0.0f;
        this.animateSwingProgress(entity, ageInTicks);
        this.body.field_78795_f = 1.5708f;
        this.rightLeg.field_78798_e = 20.01f;
        this.leftLeg.field_78798_e = 15.01f;
        this.rightLeg.field_78797_d = -13.0f;
        this.leftLeg.field_78797_d = -14.0f;
        this.body.field_78797_d = 0.5f;
        this.leftArm.field_78797_d = -26.0f;
        this.rightArm.field_78797_d = -26.0f;
        ModelHelper.func_239101_a_((ModelRenderer)this.rightArm, (ModelRenderer)this.leftArm, (float)ageInTicks);
    }

    private HandSide getMainHand(T entityIn) {
        HandSide handside = entityIn.func_184591_cq();
        return ((RedstoneGolemEntity)((Object)entityIn)).field_184622_au == Hand.MAIN_HAND ? handside : handside.func_188468_a();
    }

    private ModelRenderer getArmForSide(HandSide side) {
        return side == HandSide.LEFT ? this.leftArm : this.rightArm;
    }

    private void animateSwingProgress(T entity, float ageInTicks) {
        if (!(this.field_217112_c <= 0.0f)) {
            HandSide handside = this.getMainHand(entity);
            ModelRenderer modelrenderer = this.getArmForSide(handside);
            float f = this.field_217112_c;
            this.body.field_78796_g = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)f) * ((float)Math.PI * 2))) * 0.2f;
            if (handside == HandSide.LEFT) {
                this.body.field_78796_g *= -1.0f;
            }
            this.rightArm.field_78798_e = MathHelper.func_76126_a((float)this.body.field_78796_g) * 5.0f;
            this.rightArm.field_78800_c = -MathHelper.func_76134_b((float)this.body.field_78796_g) * 5.0f;
            this.leftArm.field_78798_e = -MathHelper.func_76126_a((float)this.body.field_78796_g) * 5.0f;
            this.leftArm.field_78800_c = MathHelper.func_76134_b((float)this.body.field_78796_g) * 5.0f;
            this.rightArm.field_78796_g += this.body.field_78796_g;
            this.leftArm.field_78796_g += this.body.field_78796_g;
            this.leftArm.field_78795_f += this.body.field_78796_g;
            f = 1.0f - this.field_217112_c;
            f *= f;
            f *= f;
            f = 1.0f - f;
            float f1 = MathHelper.func_76126_a((float)(f * (float)Math.PI));
            float f2 = MathHelper.func_76126_a((float)(this.field_217112_c * (float)Math.PI)) * -(this.body.field_78795_f - 0.7f) * 0.75f;
            modelrenderer.field_78795_f = (float)((double)modelrenderer.field_78795_f - ((double)f1 * 1.2 + (double)f2));
            modelrenderer.field_78796_g += this.body.field_78796_g * 2.0f;
            modelrenderer.field_78808_h += MathHelper.func_76126_a((float)(this.field_217112_c * (float)Math.PI)) * -0.4f;
        }
    }

    public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.func_225601_a_().forEach(part -> part.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay));
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

