/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.models.illager;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.infamous.dungeons_mobs.entities.illagers.WindcallerEntity;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelHelper;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.UseAction;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;

public class WindcallerModel<T extends WindcallerEntity>
extends BipedModel<T> {
    private final ModelRenderer jacket;
    private final ModelRenderer arms;

    public WindcallerModel(float modelSize, float yOffset, int textureWidthIn, int textureHeightIn) {
        super(modelSize);
        this.field_78090_t = textureWidthIn;
        this.field_78089_u = textureHeightIn;
        this.field_78116_c = new ModelRenderer((Model)this);
        this.field_78116_c.func_78793_a(0.0f, 0.0f + yOffset, 0.0f);
        this.field_78116_c.func_78784_a(0, 0).func_228303_a_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, modelSize, false);
        this.field_78116_c.func_78784_a(32, 0).func_228303_a_(-4.0f, -20.0f, -4.0f, 8.0f, 10.0f, 8.0f, modelSize, false);
        ModelRenderer nose = new ModelRenderer((Model)this).func_78787_b(textureWidthIn, textureHeightIn);
        nose.func_78793_a(0.0f, yOffset - 2.0f, 0.0f);
        nose.func_78784_a(24, 0).func_228301_a_(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f, modelSize);
        this.field_78116_c.func_78792_a(nose);
        this.field_178720_f.field_78806_j = false;
        this.field_78115_e = new ModelRenderer((Model)this).func_78787_b(textureWidthIn, textureHeightIn);
        this.field_78115_e.func_78793_a(0.0f, 0.0f + yOffset, 0.0f);
        this.field_78115_e.func_78784_a(16, 20).func_228301_a_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f, modelSize);
        this.jacket = new ModelRenderer((Model)this).func_78787_b(textureWidthIn, textureHeightIn);
        this.jacket.func_78793_a(0.0f, 0.0f + yOffset, 0.0f);
        this.jacket.func_78784_a(0, 38).func_228301_a_(-4.0f, 0.0f, -3.0f, 8.0f, 18.0f, 6.0f, modelSize + 0.5f);
        this.arms = new ModelRenderer((Model)this).func_78787_b(textureWidthIn, textureHeightIn);
        this.arms.func_78793_a(0.0f, 0.0f + yOffset + 2.0f, 0.0f);
        this.arms.func_78784_a(44, 22).func_228301_a_(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, modelSize);
        ModelRenderer upperArm = new ModelRenderer((Model)this, 44, 22).func_78787_b(textureWidthIn, textureHeightIn);
        upperArm.field_78809_i = true;
        upperArm.func_228301_a_(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, modelSize);
        this.arms.func_78792_a(upperArm);
        this.arms.func_78784_a(40, 38).func_228301_a_(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f, modelSize);
        this.field_178721_j = new ModelRenderer((Model)this, 0, 22).func_78787_b(textureWidthIn, textureHeightIn);
        this.field_178721_j.func_78793_a(-2.0f, 12.0f + yOffset, 0.0f);
        this.field_178721_j.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSize);
        this.field_178722_k = new ModelRenderer((Model)this, 0, 22).func_78787_b(textureWidthIn, textureHeightIn);
        this.field_178722_k.field_78809_i = true;
        this.field_178722_k.func_78793_a(2.0f, 12.0f + yOffset, 0.0f);
        this.field_178722_k.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSize);
        this.field_178723_h = new ModelRenderer((Model)this, 40, 46).func_78787_b(textureWidthIn, textureHeightIn);
        this.field_178723_h.func_228301_a_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSize);
        this.field_178723_h.func_78793_a(-5.0f, 2.0f + yOffset, 0.0f);
        this.field_178724_i = new ModelRenderer((Model)this, 40, 46).func_78787_b(textureWidthIn, textureHeightIn);
        this.field_178724_i.field_78809_i = true;
        this.field_178724_i.func_228301_a_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSize);
        this.field_178724_i.func_78793_a(5.0f, 2.0f + yOffset, 0.0f);
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return Iterables.concat((Iterable)super.func_225600_b_(), (Iterable)ImmutableList.of((Object)this.arms, (Object)this.jacket));
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.field_187076_m = BipedModel.ArmPose.EMPTY;
        this.field_187075_l = BipedModel.ArmPose.EMPTY;
        if (entityIn.func_184591_cq() == HandSide.RIGHT) {
            this.giveModelRightArmPoses(Hand.MAIN_HAND, entityIn);
            this.giveModelLeftArmPoses(Hand.OFF_HAND, entityIn);
        } else {
            this.giveModelRightArmPoses(Hand.OFF_HAND, entityIn);
            this.giveModelLeftArmPoses(Hand.MAIN_HAND, entityIn);
        }
        super.func_212843_a_(entityIn, limbSwing, limbSwingAmount, partialTick);
    }

    private void giveModelRightArmPoses(Hand hand, T entityIn) {
        ItemStack itemstack = entityIn.func_184586_b(hand);
        UseAction useaction = itemstack.func_77975_n();
        if (((WindcallerEntity)((Object)entityIn)).func_193077_p() != AbstractIllagerEntity.ArmPose.CROSSED) {
            switch (useaction) {
                case BLOCK: {
                    if (entityIn.func_184585_cz()) {
                        this.field_187076_m = BipedModel.ArmPose.BLOCK;
                        break;
                    }
                    this.field_187076_m = BipedModel.ArmPose.ITEM;
                    break;
                }
                case CROSSBOW: {
                    this.field_187076_m = BipedModel.ArmPose.CROSSBOW_HOLD;
                    if (!entityIn.func_184587_cr()) break;
                    this.field_187076_m = BipedModel.ArmPose.CROSSBOW_CHARGE;
                    break;
                }
                case BOW: {
                    this.field_187076_m = BipedModel.ArmPose.BOW_AND_ARROW;
                    break;
                }
                case SPEAR: {
                    this.field_187075_l = BipedModel.ArmPose.THROW_SPEAR;
                    break;
                }
                default: {
                    this.field_187076_m = BipedModel.ArmPose.EMPTY;
                    if (itemstack.func_190926_b()) break;
                    this.field_187076_m = BipedModel.ArmPose.ITEM;
                }
            }
        }
    }

    private void giveModelLeftArmPoses(Hand hand, T entityIn) {
        ItemStack itemstack = entityIn.func_184586_b(hand);
        UseAction useaction = itemstack.func_77975_n();
        if (((WindcallerEntity)((Object)entityIn)).func_193077_p() != AbstractIllagerEntity.ArmPose.CROSSED) {
            switch (useaction) {
                case BLOCK: {
                    if (entityIn.func_184585_cz()) {
                        this.field_187075_l = BipedModel.ArmPose.BLOCK;
                        break;
                    }
                    this.field_187075_l = BipedModel.ArmPose.ITEM;
                    break;
                }
                case CROSSBOW: {
                    this.field_187075_l = BipedModel.ArmPose.CROSSBOW_HOLD;
                    if (!entityIn.func_184587_cr()) break;
                    this.field_187075_l = BipedModel.ArmPose.CROSSBOW_CHARGE;
                    break;
                }
                case BOW: {
                    this.field_187075_l = BipedModel.ArmPose.BOW_AND_ARROW;
                    break;
                }
                case SPEAR: {
                    this.field_187075_l = BipedModel.ArmPose.THROW_SPEAR;
                    break;
                }
                default: {
                    this.field_187075_l = BipedModel.ArmPose.EMPTY;
                    if (itemstack.func_190926_b()) break;
                    this.field_187075_l = BipedModel.ArmPose.ITEM;
                }
            }
        }
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean flag;
        super.func_225597_a_(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        AbstractIllagerEntity.ArmPose armpose = ((WindcallerEntity)((Object)entityIn)).func_193077_p();
        this.arms.field_78797_d = 3.0f;
        this.arms.field_78798_e = -1.0f;
        this.arms.field_78795_f = -0.75f;
        this.jacket.func_217177_a(this.field_78115_e);
        boolean isWearingChestplateOrLeggings = entityIn.func_184582_a(EquipmentSlotType.CHEST).func_77973_b() instanceof ArmorItem || entityIn.func_184582_a(EquipmentSlotType.LEGS).func_77973_b() instanceof ArmorItem;
        this.jacket.field_78806_j = !isWearingChestplateOrLeggings;
        this.arms.field_78806_j = flag = armpose == AbstractIllagerEntity.ArmPose.CROSSED;
        this.field_178724_i.field_78806_j = !flag;
        boolean bl = this.field_178723_h.field_78806_j = !flag;
        if (flag) {
            this.field_178724_i.field_78797_d = 3.0f;
            this.field_178724_i.field_78798_e = -1.0f;
            this.field_178724_i.field_78795_f = -0.75f;
            this.field_178723_h.field_78797_d = 3.0f;
            this.field_178723_h.field_78798_e = -1.0f;
            this.field_178723_h.field_78795_f = -0.75f;
        }
        switch (armpose) {
            case ATTACKING: {
                if (entityIn.func_184614_ca().func_190926_b() || entityIn.func_184614_ca().func_77973_b() instanceof ShootableItem || entityIn.func_184585_cz()) break;
                ModelHelper.func_239103_a_((ModelRenderer)this.field_178723_h, (ModelRenderer)this.field_178724_i, entityIn, (float)this.field_217112_c, (float)ageInTicks);
                break;
            }
            case CELEBRATING: {
                this.field_178723_h.field_78798_e = 0.0f;
                this.field_178723_h.field_78800_c = -5.0f;
                this.field_178723_h.field_78795_f = MathHelper.func_76134_b((float)(ageInTicks * 0.6662f)) * 0.05f;
                this.field_178723_h.field_78808_h = 2.670354f;
                this.field_178723_h.field_78796_g = 0.0f;
                this.field_178724_i.field_78798_e = 0.0f;
                this.field_178724_i.field_78800_c = 5.0f;
                this.field_178724_i.field_78795_f = MathHelper.func_76134_b((float)(ageInTicks * 0.6662f)) * 0.05f;
                this.field_178724_i.field_78808_h = -2.3561945f;
                this.field_178724_i.field_78796_g = 0.0f;
                break;
            }
            case SPELLCASTING: {
                this.field_178723_h.field_78798_e = 0.0f;
                this.field_178723_h.field_78800_c = -5.0f;
                this.field_178724_i.field_78798_e = 0.0f;
                this.field_178724_i.field_78800_c = 5.0f;
                this.field_178723_h.field_78795_f = MathHelper.func_76134_b((float)(ageInTicks * 0.6662f)) * 0.25f;
                this.field_178724_i.field_78795_f = MathHelper.func_76134_b((float)(ageInTicks * 0.6662f)) * 0.25f;
                this.field_178723_h.field_78808_h = 2.3561945f;
                this.field_178724_i.field_78808_h = -2.3561945f;
                this.field_178723_h.field_78796_g = 0.0f;
                this.field_178724_i.field_78796_g = 0.0f;
                break;
            }
        }
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

