/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.models.golem;

import com.google.common.collect.ImmutableList;
import com.infamous.dungeons_mobs.entities.golem.SquallGolemEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;

public class SquallGolemModel<T extends SquallGolemEntity>
extends SegmentedModel<T> {
    private final ModelRenderer body;
    private final ModelRenderer rightArm;
    private final ModelRenderer leftArm;
    private final ModelRenderer rightLeg;
    private final ModelRenderer leftLeg;

    public SquallGolemModel() {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
        this.body = new ModelRenderer((Model)this);
        this.body.func_78793_a(-18.0f, 22.0f, 0.0f);
        this.body.func_78784_a(0, 0).func_228303_a_(3.0f, -40.0f, -8.0f, 30.0f, 22.0f, 14.0f, 0.0f, true);
        this.body.func_78784_a(0, 36).func_228303_a_(10.0f, -18.0f, -6.0f, 16.0f, 5.0f, 9.0f, 0.0f, true);
        this.body.func_78784_a(76, 105).func_228303_a_(12.0f, -40.0f, -18.0f, 16.0f, 13.0f, 10.0f, 0.0f, true);
        this.body.func_78784_a(54, 121).func_228303_a_(19.0f, -40.0f, -20.0f, 2.0f, 5.0f, 2.0f, 0.0f, true);
        this.body.func_78784_a(62, 118).func_228303_a_(18.0f, -33.0f, -21.0f, 4.0f, 7.0f, 3.0f, 0.0f, false);
        ModelRenderer rightSpinner = new ModelRenderer((Model)this);
        rightSpinner.func_78793_a(8.0f, -43.0833f, -5.0f);
        this.body.func_78792_a(rightSpinner);
        rightSpinner.func_78784_a(112, 0).func_228303_a_(-2.0f, 1.0833f, -2.0f, 4.0f, 2.0f, 4.0f, 0.0f, true);
        rightSpinner.func_78784_a(120, 6).func_228303_a_(-1.0f, -8.9167f, -1.0f, 2.0f, 10.0f, 2.0f, 0.0f, true);
        rightSpinner.func_78784_a(108, 18).func_228303_a_(0.0f, -8.9167f, 1.0f, 0.0f, 8.0f, 5.0f, 0.0f, true);
        rightSpinner.func_78784_a(118, 18).func_228303_a_(-6.0f, -8.9167f, 0.0f, 5.0f, 8.0f, 0.0f, 0.0f, true);
        rightSpinner.func_78784_a(118, 18).func_228303_a_(1.0f, -8.9167f, 0.0f, 5.0f, 8.0f, 0.0f, 0.0f, true);
        rightSpinner.func_78784_a(108, 18).func_228303_a_(0.0f, -8.9167f, -6.0f, 0.0f, 8.0f, 5.0f, 0.0f, true);
        ModelRenderer leftSpinner = new ModelRenderer((Model)this);
        leftSpinner.func_78793_a(29.0f, -43.0833f, -5.0f);
        this.body.func_78792_a(leftSpinner);
        leftSpinner.func_78784_a(112, 0).func_228303_a_(-2.0f, 1.0833f, -2.0f, 4.0f, 2.0f, 4.0f, 0.0f, true);
        leftSpinner.func_78784_a(120, 6).func_228303_a_(-1.0f, -8.9167f, -1.0f, 2.0f, 10.0f, 2.0f, 0.0f, true);
        leftSpinner.func_78784_a(108, 18).func_228303_a_(0.0f, -8.9167f, 1.0f, 0.0f, 8.0f, 5.0f, 0.0f, true);
        leftSpinner.func_78784_a(118, 18).func_228303_a_(-6.0f, -8.9167f, 0.0f, 5.0f, 8.0f, 0.0f, 0.0f, true);
        leftSpinner.func_78784_a(118, 18).func_228303_a_(1.0f, -8.9167f, 0.0f, 5.0f, 8.0f, 0.0f, 0.0f, true);
        leftSpinner.func_78784_a(108, 18).func_228303_a_(0.0f, -8.9167f, -6.0f, 0.0f, 8.0f, 5.0f, 0.0f, true);
        this.rightArm = new ModelRenderer((Model)this);
        this.rightArm.func_78793_a(-17.0f, -7.0f, 2.5f);
        this.rightArm.func_78784_a(0, 53).func_228303_a_(-4.0f, -5.0f, -8.5f, 6.0f, 35.0f, 9.0f, 0.0f, false);
        this.rightArm.func_78784_a(0, 117).func_228303_a_(-4.0f, 26.0f, 0.5f, 6.0f, 4.0f, 7.0f, 0.0f, false);
        this.leftArm = new ModelRenderer((Model)this);
        this.leftArm.func_78793_a(18.0f, -7.0f, 2.5f);
        this.leftArm.func_78784_a(0, 53).func_228303_a_(-3.0f, -5.0f, -8.5f, 6.0f, 35.0f, 9.0f, 0.0f, false);
        this.leftArm.func_78784_a(0, 117).func_228303_a_(-3.0f, 26.0f, 0.5f, 6.0f, 4.0f, 7.0f, 0.0f, false);
        this.rightLeg = new ModelRenderer((Model)this);
        this.rightLeg.func_78793_a(-18.0f, 24.0f, 0.0f);
        this.rightLeg.func_78784_a(93, 39).func_228303_a_(7.0f, -15.0f, -5.0f, 8.0f, 15.0f, 7.0f, 0.0f, true);
        this.leftLeg = new ModelRenderer((Model)this);
        this.leftLeg.func_78793_a(-18.0f, 24.0f, 0.0f);
        this.leftLeg.func_78784_a(93, 39).func_228303_a_(21.0f, -15.0f, -5.0f, 8.0f, 15.0f, 7.0f, 0.0f, true);
    }

    public Iterable<ModelRenderer> func_225601_a_() {
        return ImmutableList.of((Object)this.body, (Object)this.rightArm, (Object)this.leftArm, (Object)this.rightLeg, (Object)this.leftLeg);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.leftLeg.field_78795_f = -0.5f * MathHelper.func_233021_e_((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.rightLeg.field_78795_f = 0.5f * MathHelper.func_233021_e_((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.leftLeg.field_78796_g = 0.0f;
        this.rightLeg.field_78796_g = 0.0f;
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        int i = ((SquallGolemEntity)((Object)entityIn)).getAttackTimer();
        if (i > 0) {
            this.rightArm.field_78795_f = -2.0f + 1.5f * MathHelper.func_233021_e_((float)((float)i - partialTick), (float)10.0f);
            this.leftArm.field_78795_f = -2.0f + 1.5f * MathHelper.func_233021_e_((float)((float)i - partialTick), (float)10.0f);
        } else {
            this.rightArm.field_78795_f = (-0.2f + 1.5f * MathHelper.func_233021_e_((float)limbSwing, (float)13.0f)) * limbSwingAmount;
            this.leftArm.field_78795_f = (-0.2f - 1.5f * MathHelper.func_233021_e_((float)limbSwing, (float)13.0f)) * limbSwingAmount;
        }
    }

    public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.func_225601_a_().forEach(part -> part.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay));
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

