/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.capabilities.teamable;

import com.infamous.dungeons_mobs.capabilities.teamable.ITeamable;
import com.infamous.dungeons_mobs.capabilities.teamable.TeamableProvider;
import javax.annotation.Nullable;
import net.minecraft.entity.MobEntity;
import net.minecraftforge.common.util.LazyOptional;

public class TeamableHelper {
    @Nullable
    public static ITeamable getTeamableCapability(MobEntity mob) {
        LazyOptional lazyCap = mob.getCapability(TeamableProvider.TEAMABLE_CAPABILITY);
        if (lazyCap.isPresent()) {
            return (ITeamable)lazyCap.orElseThrow(() -> new IllegalStateException("Couldn't get the teamable capability from the Entity!"));
        }
        return null;
    }

    public static void makeTeammates(MobEntity mob, MobEntity teammate) {
        ITeamable entityTeamableCap = TeamableHelper.getTeamableCapability(mob);
        ITeamable teammateTeamableCap = TeamableHelper.getTeamableCapability(teammate);
        if (entityTeamableCap != null && teammateTeamableCap != null) {
            entityTeamableCap.addTeammate(teammate.func_110124_au());
            teammateTeamableCap.addTeammate(mob.func_110124_au());
        }
    }

    public static boolean areTeammates(MobEntity mob, MobEntity teammate) {
        ITeamable entityTeamableCap = TeamableHelper.getTeamableCapability(mob);
        ITeamable teammateTeamableCap = TeamableHelper.getTeamableCapability(teammate);
        if (entityTeamableCap != null && teammateTeamableCap != null) {
            return entityTeamableCap.getTeammates().contains(teammate.func_110124_au()) || teammateTeamableCap.getTeammates().contains(mob.func_110124_au());
        }
        return false;
    }
}

