/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.capabilities.convertible;

import com.infamous.dungeons_mobs.DungeonsMobs;
import com.infamous.dungeons_mobs.capabilities.convertible.ConvertibleProvider;
import com.infamous.dungeons_mobs.capabilities.convertible.IConvertible;
import com.infamous.dungeons_mobs.entities.water.SunkenSkeletonEntity;
import com.infamous.dungeons_mobs.interfaces.IArmoredMob;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.tags.CustomTags;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ConvertibleHelper {
    @Nullable
    public static IConvertible getConvertibleCapability(Entity entity) {
        LazyOptional lazyCap = entity.getCapability(ConvertibleProvider.CONVERTIBLE_CAPABILITY);
        if (lazyCap.isPresent()) {
            return (IConvertible)lazyCap.orElseThrow(() -> new IllegalStateException("Couldn't get the convertible capability from the Entity!"));
        }
        return null;
    }

    public static void onDrownedAndConvertedTo(MobEntity original, MobEntity convertedTo) {
        if (original instanceof AbstractSkeletonEntity && convertedTo instanceof SunkenSkeletonEntity) {
            if (!original.func_174814_R()) {
                original.field_70170_p.func_217378_a((PlayerEntity)null, 1040, original.func_233580_cy_(), 0);
            }
            DungeonsMobs.LOGGER.info("Converted {} to {}", (Object)original, (Object)convertedTo);
        }
        if (original instanceof IArmoredMob && convertedTo instanceof IArmoredMob && ((IArmoredMob)original).hasStrongArmor()) {
            ((IArmoredMob)convertedTo).setStrongArmored(convertedTo);
        }
        if (original instanceof ZombieEntity && convertedTo instanceof ZombieEntity) {
            ZombieEntity originalZombie = (ZombieEntity)original;
            ZombieEntity convertedToZombie = (ZombieEntity)convertedTo;
            ConvertibleHelper.handleZombieAttributes(convertedToZombie);
            ConvertibleHelper.setZombieCanBreakDoors(originalZombie, convertedToZombie);
        }
        ForgeEventFactory.onLivingConvert((LivingEntity)original, (LivingEntity)convertedTo);
    }

    private static void setZombieCanBreakDoors(ZombieEntity originalZombie, ZombieEntity convertedToZombie) {
        Method supportsBreakDoorGoalMethod = ObfuscationReflectionHelper.findMethod(ZombieEntity.class, (String)"func_204900_dz", (Class[])new Class[0]);
        try {
            convertedToZombie.func_146070_a((Boolean)supportsBreakDoorGoalMethod.invoke((Object)convertedToZombie, new Object[0]) != false && originalZombie.func_146072_bX());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static void handleZombieAttributes(ZombieEntity convertedToZombie) {
        Method handleAttributesMethod = ObfuscationReflectionHelper.findMethod(ZombieEntity.class, (String)"func_207304_a", (Class[])new Class[]{Float.class});
        try {
            handleAttributesMethod.invoke((Object)convertedToZombie, Float.valueOf(convertedToZombie.field_70170_p.func_175649_E(convertedToZombie.func_233580_cy_()).func_180170_c()));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static EntityType<? extends MobEntity> getDrowningConvertTo(MobEntity mob) {
        EntityType convertToType = mob.func_200600_R();
        if (mob instanceof AbstractSkeletonEntity) {
            convertToType = mob instanceof IArmoredMob ? (EntityType)ModEntityTypes.ARMORED_SUNKEN_SKELETON.get() : (EntityType)ModEntityTypes.SUNKEN_SKELETON.get();
        } else if (mob instanceof ZombieEntity) {
            convertToType = mob instanceof IArmoredMob ? (EntityType)ModEntityTypes.ARMORED_DROWNED.get() : EntityType.field_204724_o;
        }
        return convertToType;
    }

    public static boolean convertsInWater(MobEntity mobEntity) {
        return mobEntity.func_200600_R().func_220341_a(CustomTags.CONVERTS_IN_WATER);
    }
}

