/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.rendering.splash.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.keksuccino.drippyloadingscreen.DrippyLoadingScreen;
import de.keksuccino.drippyloadingscreen.customization.rendering.splash.SplashCustomizationLayer;
import de.keksuccino.drippyloadingscreen.customization.rendering.splash.elements.SplashElementBase;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;

public class ProgressBarSplashElement
extends SplashElementBase {
    public String customBarColorHex = null;
    protected String lastCustomBarColorHex = null;
    public Color customBarColor;

    public ProgressBarSplashElement(SplashCustomizationLayer handler) {
        super(handler);
        if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().func_228018_at_() != null) {
            int screenWidth = this.mc.func_228018_at_().func_198107_o();
            int screenHeight = this.mc.func_228018_at_().func_198087_p();
            double d0 = Math.min((double)screenWidth * 0.75, (double)screenHeight) * 0.25;
            double d1 = d0 * 4.0;
            int k1 = (int)(d1 * 0.5);
            this.width = k1 * 2;
            this.height = 10;
        }
    }

    @Override
    public void onReloadCustomizations() {
        super.onReloadCustomizations();
        this.customBarColorHex = null;
        this.lastCustomBarColorHex = null;
        this.customBarColor = null;
    }

    @Override
    public void render(MatrixStack matrix, int scaledWidth, int scaledHeight, float partialTicks) {
        if (this.customBarColorHex != null && !this.customBarColorHex.equals(this.lastCustomBarColorHex)) {
            this.customBarColor = RenderUtils.getColorFromHexString((String)this.customBarColorHex);
        }
        this.lastCustomBarColorHex = this.customBarColorHex;
        if (this.visible) {
            this.renderProgressBar(matrix);
        }
    }

    protected void renderProgressBar(MatrixStack matrix) {
        long time = Util.func_211177_b();
        float f = this.handler.fadeOutStart > -1L ? (float)(time - this.handler.fadeOutStart) / 1000.0f : -1.0f;
        int screenWidth = this.mc.func_228018_at_().func_198107_o();
        int screenHeight = this.mc.func_228018_at_().func_198087_p();
        double d0 = Math.min((double)screenWidth * 0.75, (double)screenHeight) * 0.25;
        double d1 = d0 * 4.0;
        int k1 = (int)(d1 * 0.5);
        int l1 = (int)((double)screenHeight * 0.8325);
        float barTransparency = 1.0f - MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        this.width = k1 * 2;
        this.height = 10;
        this.renderProgressBarRaw(matrix, this.x, this.y, this.x + k1 * 2, this.y + 10, barTransparency);
    }

    protected void renderProgressBarRaw(MatrixStack matrix, int minX, int minY, int maxX, int maxY, float alpha) {
        float prog = this.handler.progress;
        if (this.handler.isEditor || SplashCustomizationLayer.isCustomizationHelperScreen()) {
            prog = 0.5f;
        }
        int i = MathHelper.func_76123_f((float)((float)(maxX - minX - 2) * prog));
        int j = Math.round(alpha * 255.0f);
        if (this.handler.isEditor || SplashCustomizationLayer.isCustomizationHelperScreen() || DrippyLoadingScreen.isFancyMenuLoaded()) {
            j = 255;
        }
        int k = ColorHelper.PackedColor.func_233006_a_((int)j, (int)255, (int)255, (int)255);
        if (this.customBarColor != null) {
            k = ColorHelper.PackedColor.func_233006_a_((int)j, (int)this.customBarColor.getRed(), (int)this.customBarColor.getGreen(), (int)this.customBarColor.getBlue());
        }
        ProgressBarSplashElement.func_238467_a_((MatrixStack)matrix, (int)(minX + 1), (int)minY, (int)(maxX - 1), (int)(minY + 1), (int)k);
        ProgressBarSplashElement.func_238467_a_((MatrixStack)matrix, (int)(minX + 1), (int)maxY, (int)(maxX - 1), (int)(maxY - 1), (int)k);
        ProgressBarSplashElement.func_238467_a_((MatrixStack)matrix, (int)minX, (int)minY, (int)(minX + 1), (int)maxY, (int)k);
        ProgressBarSplashElement.func_238467_a_((MatrixStack)matrix, (int)maxX, (int)minY, (int)(maxX - 1), (int)maxY, (int)k);
        ProgressBarSplashElement.func_238467_a_((MatrixStack)matrix, (int)(minX + 2), (int)(minY + 2), (int)(minX + i), (int)(maxY - 2), (int)k);
    }
}

