/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.rendering.splash.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.drippyloadingscreen.customization.rendering.splash.SplashCustomizationLayer;
import de.keksuccino.drippyloadingscreen.customization.rendering.splash.elements.SplashElementBase;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.loading.progress.StartupMessageManager;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL14;
import org.lwjgl.stb.STBEasyFont;
import org.lwjgl.system.MemoryUtil;

public class ForgeTextSplashElement
extends SplashElementBase {
    public String customTextColorHex = null;
    protected String lastCustomTextColorHex = null;
    public Color customTextColor;

    public ForgeTextSplashElement(SplashCustomizationLayer handler) {
        super(handler);
    }

    @Override
    public void onReloadCustomizations() {
        super.onReloadCustomizations();
        this.customTextColorHex = null;
        this.lastCustomTextColorHex = null;
        this.customTextColor = null;
    }

    @Override
    public void render(MatrixStack matrix, int scaledWidth, int scaledHeight, float partialTicks) {
        if (this.customTextColorHex != null && !this.customTextColorHex.equals(this.lastCustomTextColorHex)) {
            this.customTextColor = RenderUtils.getColorFromHexString((String)this.customTextColorHex);
        }
        this.lastCustomTextColorHex = this.customTextColorHex;
        if (this.visible) {
            this.renderForgeText();
        }
    }

    protected void renderForgeText() {
        this.width = (int)(300.0f * this.scale);
        this.height = (int)(50.0f * this.scale);
        List messages = StartupMessageManager.getMessages();
        for (int i = 0; i < messages.size(); ++i) {
            boolean noFade = i == 0;
            Pair pair = (Pair)messages.get(i);
            float fade = MathHelper.func_76131_a((float)((4000.0f - (float)((Integer)pair.getLeft()).intValue() - (float)(i - 4) * 1000.0f) / 5000.0f), (float)0.0f, (float)1.0f);
            if (fade < 0.01f && !noFade) continue;
            StartupMessageManager.Message msg = (StartupMessageManager.Message)pair.getRight();
            this.renderMessage(msg.getText(), msg.getTypeColour(), i, noFade ? 1.0f : fade);
        }
    }

    private void renderMessage(String message, float[] color, int line, float alpha) {
        GlStateManager.func_227770_y_((int)32884);
        ByteBuffer charBuffer = MemoryUtil.memAlloc((int)(message.length() * 270));
        int quads = STBEasyFont.stb_easy_font_print((float)0.0f, (float)0.0f, (CharSequence)message, null, (ByteBuffer)charBuffer);
        GL14.glVertexPointer((int)2, (int)5126, (int)16, (ByteBuffer)charBuffer);
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.disableCull();
        GL14.glBlendColor((float)0.0f, (float)0.0f, (float)0.0f, (float)alpha);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.CONSTANT_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_CONSTANT_ALPHA);
        if (this.customTextColor != null) {
            color = ForgeTextSplashElement.getColor(this.customTextColor);
        }
        RenderSystem.color3f((float)color[0], (float)color[1], (float)color[2]);
        RenderSystem.pushMatrix();
        int posY = this.y + this.height - (int)(10.0f * this.scale) - line * (int)(10.0f * this.scale);
        RenderSystem.translatef((float)this.x, (float)posY, (float)0.0f);
        RenderSystem.scalef((float)this.scale, (float)this.scale, (float)0.0f);
        RenderSystem.drawArrays((int)7, (int)0, (int)(quads * 4));
        RenderSystem.popMatrix();
        RenderSystem.enableCull();
        GlStateManager.func_227772_z_((int)32884);
        MemoryUtil.memFree((Buffer)charBuffer);
    }

    protected static float[] getColor(Color c) {
        float[] color = new float[]{0.0f, 0.0f, 0.0f};
        int i = c.getRGB();
        color[2] = (float)(i & 0xFF) / 255.0f;
        color[1] = (float)(i >> 8 & 0xFF) / 255.0f;
        color[0] = (float)(i >> 16 & 0xFF) / 255.0f;
        return color;
    }
}

