/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.rendering.splash.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.drippyloadingscreen.customization.rendering.splash.SplashCustomizationLayer;
import de.keksuccino.drippyloadingscreen.customization.rendering.splash.elements.SplashElementBase;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL14;
import org.lwjgl.stb.STBEasyFont;
import org.lwjgl.system.MemoryUtil;

public class ForgeMemoryInfoSplashElement
extends SplashElementBase {
    private static final float[] MEM_COLOR = new float[]{0.0f, 0.0f, 0.0f};
    public String customTextColorHex = null;
    protected String lastCustomTextColorHex = null;
    public Color customTextColor;

    public ForgeMemoryInfoSplashElement(SplashCustomizationLayer handler) {
        super(handler);
    }

    @Override
    public void onReloadCustomizations() {
        super.onReloadCustomizations();
        this.customTextColorHex = null;
        this.lastCustomTextColorHex = null;
        this.customTextColor = null;
    }

    @Override
    public void render(MatrixStack matrix, int scaledWidth, int scaledHeight, float partialTicks) {
        if (this.customTextColorHex != null && !this.customTextColorHex.equals(this.lastCustomTextColorHex)) {
            this.customTextColor = RenderUtils.getColorFromHexString((String)this.customTextColorHex);
        }
        this.lastCustomTextColorHex = this.customTextColorHex;
        if (this.visible) {
            this.renderMemoryInfo();
        }
    }

    protected void renderMemoryInfo() {
        MemoryUsage heapusage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        MemoryUsage offheapusage = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
        float pctmemory = (float)heapusage.getUsed() / (float)heapusage.getMax();
        String currentText = String.format("Memory Heap: %d / %d MB (%.1f%%)  OffHeap: %d MB", heapusage.getUsed() >> 20, heapusage.getMax() >> 20, (double)pctmemory * 100.0, offheapusage.getUsed() >> 20);
        this.width = (int)((float)STBEasyFont.stb_easy_font_width((CharSequence)currentText) * this.scale);
        this.height = (int)(10.0f * this.scale);
        int i = MathHelper.func_181758_c((float)((1.0f - (float)Math.pow(pctmemory, 1.5)) / 3.0f), (float)1.0f, (float)0.5f);
        ForgeMemoryInfoSplashElement.MEM_COLOR[2] = (float)(i & 0xFF) / 255.0f;
        ForgeMemoryInfoSplashElement.MEM_COLOR[1] = (float)(i >> 8 & 0xFF) / 255.0f;
        ForgeMemoryInfoSplashElement.MEM_COLOR[0] = (float)(i >> 16 & 0xFF) / 255.0f;
        this.renderMessage(currentText, MEM_COLOR, this.x, this.y, 1.0f);
    }

    protected void renderMessage(String message, float[] color, int x, int y, float alpha) {
        GlStateManager.func_227770_y_((int)32884);
        ByteBuffer charBuffer = MemoryUtil.memAlloc((int)(message.length() * 270));
        int quads = STBEasyFont.stb_easy_font_print((float)0.0f, (float)0.0f, (CharSequence)message, null, (ByteBuffer)charBuffer);
        GL14.glVertexPointer((int)2, (int)5126, (int)16, (ByteBuffer)charBuffer);
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.disableCull();
        GL14.glBlendColor((float)0.0f, (float)0.0f, (float)0.0f, (float)alpha);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.CONSTANT_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_CONSTANT_ALPHA);
        if (this.customTextColor != null) {
            color = ForgeMemoryInfoSplashElement.getColor(this.customTextColor);
        }
        RenderSystem.color3f((float)color[0], (float)color[1], (float)color[2]);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)0.0f);
        RenderSystem.scalef((float)this.scale, (float)this.scale, (float)0.0f);
        RenderSystem.drawArrays((int)7, (int)0, (int)(quads * 4));
        RenderSystem.popMatrix();
        RenderSystem.enableCull();
        GlStateManager.func_227772_z_((int)32884);
        MemoryUtil.memFree((Buffer)charBuffer);
    }

    protected static float[] getColor(Color c) {
        float[] color = new float[]{0.0f, 0.0f, 0.0f};
        int i = c.getRGB();
        color[2] = (float)(i & 0xFF) / 255.0f;
        color[1] = (float)(i >> 8 & 0xFF) / 255.0f;
        color[0] = (float)(i >> 16 & 0xFF) / 255.0f;
        return color;
    }
}

