/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.rendering.splash;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.drippyloadingscreen.DrippyLoadingScreen;
import de.keksuccino.drippyloadingscreen.api.item.CustomizationItemContainer;
import de.keksuccino.drippyloadingscreen.api.item.CustomizationItemRegistry;
import de.keksuccino.drippyloadingscreen.api.item.v2.CustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.CustomizationHandler;
import de.keksuccino.drippyloadingscreen.customization.CustomizationPropertiesHandler;
import de.keksuccino.drippyloadingscreen.customization.helper.CustomizationHelperScreen;
import de.keksuccino.drippyloadingscreen.customization.items.CustomizationItemBase;
import de.keksuccino.drippyloadingscreen.customization.items.ShapeCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.SlideshowCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.SplashTextCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.StringCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.TextureCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.WebStringCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.WebTextureCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.custombars.CustomProgressBarCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.vanilla.ForgeMemoryInfoSplashCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.vanilla.ForgeTextSplashCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.vanilla.LogoSplashCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.vanilla.ProgressBarSplashCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.placeholdervalues.PlaceholderTextValueHelper;
import de.keksuccino.drippyloadingscreen.customization.rendering.splash.elements.ForgeMemoryInfoSplashElement;
import de.keksuccino.drippyloadingscreen.customization.rendering.splash.elements.ForgeTextSplashElement;
import de.keksuccino.drippyloadingscreen.customization.rendering.splash.elements.LogoSplashElement;
import de.keksuccino.drippyloadingscreen.customization.rendering.splash.elements.ProgressBarSplashElement;
import de.keksuccino.drippyloadingscreen.events.CustomizationSystemReloadedEvent;
import de.keksuccino.drippyloadingscreen.events.OverlayOpenEvent;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSet;
import de.keksuccino.konkrete.rendering.CurrentScreenHandler;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import de.keksuccino.konkrete.resources.TextureHandler;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.resources.IAsyncReloader;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SplashCustomizationLayer
extends AbstractGui {
    protected static SplashCustomizationLayer instance;
    private static int backgroundColor;
    private static int backgroundColor2;
    public final LogoSplashElement logoSplashElement = new LogoSplashElement(this);
    public final ForgeTextSplashElement forgeTextSplashElement = new ForgeTextSplashElement(this);
    public final ForgeMemoryInfoSplashElement forgeMemoryInfoSplashElement = new ForgeMemoryInfoSplashElement(this);
    public final ProgressBarSplashElement progressBarSplashElement = new ProgressBarSplashElement(this);
    public String customBackgroundHex = null;
    protected String lastCustomBackgroundHex = null;
    public Color customBackgroundColor;
    public ExternalTextureResourceLocation backgroundImageSource = null;
    public ResourceLocation backgroundImage = null;
    public String backgroundImagePath = null;
    public boolean keepBackgroundAspectRatio = false;
    public boolean scaled = false;
    public boolean fadeOut = true;
    public final boolean isEditor;
    public boolean isNewLoadingScreen = true;
    public IAsyncReloader asyncReloader;
    public Consumer<Optional<Throwable>> completedCallback;
    public boolean reloading;
    public long fadeOutStart;
    public long fadeInStart;
    public float progress;
    public List<CustomizationItemBase> backgroundElements = new ArrayList<CustomizationItemBase>();
    public List<CustomizationItemBase> foregroundElements = new ArrayList<CustomizationItemBase>();
    protected Map<String, RandomLayoutContainer> randomLayoutGroups = new HashMap<String, RandomLayoutContainer>();
    protected Minecraft mc = Minecraft.func_71410_x();

    public SplashCustomizationLayer(boolean isEditor) {
        this.isEditor = isEditor;
        this.updateCustomizations();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onCustomizationSystemReloaded(CustomizationSystemReloadedEvent e) {
        for (RandomLayoutContainer c : this.randomLayoutGroups.values()) {
            c.lastLayoutPath = null;
        }
        PlaceholderTextValueHelper.randomTextIntervals.clear();
        this.updateCustomizations();
    }

    @SubscribeEvent
    public void onOverlayOpenEvent(OverlayOpenEvent e) {
        this.isNewLoadingScreen = true;
    }

    public void renderLayer() {
        ArrayList<Runnable> runs = new ArrayList<Runnable>();
        runs.addAll(CustomizationHandler.mainThreadTasks);
        for (Runnable r : runs) {
            try {
                r.run();
                CustomizationHandler.mainThreadTasks.remove(r);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.customBackgroundHex != null && !this.customBackgroundHex.equals(this.lastCustomBackgroundHex)) {
            this.customBackgroundColor = RenderUtils.getColorFromHexString((String)this.customBackgroundHex);
        }
        this.lastCustomBackgroundHex = this.customBackgroundHex;
        if (Minecraft.func_71410_x() == null || Minecraft.func_71410_x().func_228018_at_() == null) {
            return;
        }
        MatrixStack matrix = new MatrixStack();
        float partial = Minecraft.func_71410_x().func_184121_ak();
        int screenWidth = this.mc.func_228018_at_().func_198107_o();
        int screenHeight = this.mc.func_228018_at_().func_198087_p();
        float elementOpacity = 1.0f;
        if (!this.isEditor) {
            float f1;
            long time = Util.func_211177_b();
            float f = this.fadeOutStart > -1L ? (float)(time - this.fadeOutStart) / 1000.0f : -1.0f;
            float f2 = f1 = this.fadeInStart > -1L ? (float)(time - this.fadeInStart) / 500.0f : -1.0f;
            if (SplashCustomizationLayer.isCustomizationHelperScreen() || DrippyLoadingScreen.isFancyMenuLoaded() || !this.fadeOut) {
                f = 1.0f;
            }
            if (f >= 1.0f) {
                int l = MathHelper.func_76123_f((float)((1.0f - MathHelper.func_76131_a((float)(f - 1.0f), (float)0.0f, (float)1.0f)) * 255.0f));
                if (this.customBackgroundColor != null) {
                    SplashCustomizationLayer.func_238467_a_((MatrixStack)matrix, (int)0, (int)0, (int)screenWidth, (int)screenHeight, (int)SplashCustomizationLayer.withAlpha(this.customBackgroundColor.getRGB(), l));
                } else {
                    SplashCustomizationLayer.func_238467_a_((MatrixStack)matrix, (int)0, (int)0, (int)screenWidth, (int)screenHeight, (int)SplashCustomizationLayer.withAlpha(backgroundColor2, l));
                }
                elementOpacity = 1.0f - MathHelper.func_76131_a((float)(f - 1.0f), (float)0.0f, (float)1.0f);
            } else if (this.reloading) {
                int i2 = MathHelper.func_76143_f((double)(MathHelper.func_151237_a((double)f1, (double)0.15, (double)1.0) * 255.0));
                if (this.customBackgroundColor != null) {
                    SplashCustomizationLayer.func_238467_a_((MatrixStack)matrix, (int)0, (int)0, (int)screenWidth, (int)screenHeight, (int)SplashCustomizationLayer.withAlpha(this.customBackgroundColor.getRGB(), i2));
                } else {
                    SplashCustomizationLayer.func_238467_a_((MatrixStack)matrix, (int)0, (int)0, (int)screenWidth, (int)screenHeight, (int)SplashCustomizationLayer.withAlpha(backgroundColor2, i2));
                }
                elementOpacity = f1;
            } else {
                if (this.customBackgroundColor != null) {
                    SplashCustomizationLayer.func_238467_a_((MatrixStack)matrix, (int)0, (int)0, (int)screenWidth, (int)screenHeight, (int)this.customBackgroundColor.getRGB());
                } else {
                    SplashCustomizationLayer.func_238467_a_((MatrixStack)matrix, (int)0, (int)0, (int)screenWidth, (int)screenHeight, (int)backgroundColor);
                }
                elementOpacity = 1.0f;
            }
            if (elementOpacity > 1.0f) {
                elementOpacity = 1.0f;
            }
            if (elementOpacity < 0.0f) {
                elementOpacity = 0.0f;
            }
            if (this.backgroundImage != null) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.backgroundImage);
                RenderSystem.enableBlend();
                if (!SplashCustomizationLayer.isCustomizationHelperScreen()) {
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)elementOpacity);
                } else {
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                if (!this.keepBackgroundAspectRatio) {
                    SplashCustomizationLayer.func_238463_a_((MatrixStack)matrix, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)screenWidth, (int)screenHeight, (int)screenWidth, (int)screenHeight);
                } else {
                    int w = this.backgroundImageSource.getWidth();
                    int h = this.backgroundImageSource.getHeight();
                    double ratio = (double)w / (double)h;
                    int wfinal = (int)((double)screenHeight * ratio);
                    int screenCenterX = screenWidth / 2;
                    if (wfinal < screenWidth) {
                        SplashCustomizationLayer.func_238463_a_((MatrixStack)CurrentScreenHandler.getMatrixStack(), (int)0, (int)0, (float)1.0f, (float)1.0f, (int)(screenWidth + 1), (int)(screenHeight + 1), (int)(screenWidth + 1), (int)(screenHeight + 1));
                    } else {
                        SplashCustomizationLayer.func_238463_a_((MatrixStack)CurrentScreenHandler.getMatrixStack(), (int)(screenCenterX - wfinal / 2), (int)0, (float)1.0f, (float)1.0f, (int)(wfinal + 1), (int)(screenHeight + 1), (int)(wfinal + 1), (int)(screenHeight + 1));
                    }
                }
                RenderSystem.disableBlend();
            }
        }
        if (this.isEditor || SplashCustomizationLayer.isCustomizationHelperScreen() || DrippyLoadingScreen.isFancyMenuLoaded() || !this.fadeOut) {
            elementOpacity = 1.0f;
        }
        for (CustomizationItemBase i : this.backgroundElements) {
            i.opacity = elementOpacity;
        }
        for (CustomizationItemBase i : this.foregroundElements) {
            i.opacity = elementOpacity;
        }
        if (!this.isEditor) {
            for (CustomizationItemBase i : this.backgroundElements) {
                i.render(matrix);
            }
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableTexture();
        RenderSystem.enableCull();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.logoSplashElement.render(matrix, screenWidth, screenHeight, partial);
        this.forgeTextSplashElement.render(matrix, screenWidth, screenHeight, partial);
        this.forgeMemoryInfoSplashElement.render(matrix, screenWidth, screenHeight, partial);
        this.progressBarSplashElement.render(matrix, screenWidth, screenHeight, partial);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableTexture();
        RenderSystem.enableCull();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!this.isEditor) {
            for (CustomizationItemBase i : this.foregroundElements) {
                i.render(matrix);
            }
        }
    }

    public void updateCustomizations() {
        if (this.isEditor) {
            return;
        }
        try {
            this.logoSplashElement.onReloadCustomizations();
            this.forgeTextSplashElement.onReloadCustomizations();
            this.forgeMemoryInfoSplashElement.onReloadCustomizations();
            this.progressBarSplashElement.onReloadCustomizations();
            this.customBackgroundHex = null;
            this.lastCustomBackgroundHex = null;
            this.customBackgroundColor = null;
            this.backgroundImageSource = null;
            this.backgroundImage = null;
            this.backgroundImagePath = null;
            this.keepBackgroundAspectRatio = false;
            this.foregroundElements.clear();
            this.backgroundElements.clear();
            this.scaled = false;
            this.fadeOut = true;
            List<PropertiesSet> propsRaw = CustomizationPropertiesHandler.getProperties();
            ArrayList<PropertiesSet> normalLayouts = new ArrayList<PropertiesSet>();
            ArrayList<PropertiesSet> layouts = new ArrayList<PropertiesSet>();
            String randomDefaultGroup = "-100397";
            for (RandomLayoutContainer c : this.randomLayoutGroups.values()) {
                c.onlyFirstTime = false;
                c.clearLayouts();
            }
            boolean logoSet = false;
            boolean forgeTextSet = false;
            boolean forgeMemoryInfoSet = false;
            boolean progressBarSet = false;
            for (PropertiesSet propertiesSet : propsRaw) {
                List list = propertiesSet.getPropertiesOfType("customization-meta");
                if (list.isEmpty()) continue;
                String randomMode = ((PropertiesSection)list.get(0)).getEntryValue("randommode");
                if (randomMode != null && randomMode.equalsIgnoreCase("true")) {
                    RandomLayoutContainer c;
                    String group = ((PropertiesSection)list.get(0)).getEntryValue("randomgroup");
                    if (group == null) {
                        group = randomDefaultGroup;
                    }
                    if (!this.randomLayoutGroups.containsKey(group)) {
                        this.randomLayoutGroups.put(group, new RandomLayoutContainer(group, this));
                    }
                    if ((c = this.randomLayoutGroups.get(group)) == null) continue;
                    String randomOnlyFirstTime = ((PropertiesSection)list.get(0)).getEntryValue("randomonlyfirsttime");
                    if (randomOnlyFirstTime != null && randomOnlyFirstTime.equalsIgnoreCase("true")) {
                        c.setOnlyFirstTime(true);
                    }
                    c.addLayout(propertiesSet);
                    continue;
                }
                normalLayouts.add(propertiesSet);
            }
            ArrayList<String> trashLayoutGroups = new ArrayList<String>();
            for (Map.Entry<String, RandomLayoutContainer> entry : this.randomLayoutGroups.entrySet()) {
                if (!entry.getValue().getLayouts().isEmpty()) continue;
                trashLayoutGroups.add(entry.getKey());
            }
            for (String string : trashLayoutGroups) {
                this.randomLayoutGroups.remove(string);
            }
            for (RandomLayoutContainer randomLayoutContainer : this.randomLayoutGroups.values()) {
                PropertiesSet s = randomLayoutContainer.getRandomLayout();
                if (s == null) continue;
                layouts.add(s);
            }
            layouts.addAll(normalLayouts);
            for (PropertiesSet propertiesSet : layouts) {
                File f;
                String backgroundImageString;
                String keepAspect;
                String cusBackColorString;
                String fadeOutString;
                boolean renderInBackground = false;
                List metas = propertiesSet.getPropertiesOfType("customization-meta");
                if (metas.isEmpty()) continue;
                String roString = ((PropertiesSection)metas.get(0)).getEntryValue("renderorder");
                if (roString != null && roString.equalsIgnoreCase("background")) {
                    renderInBackground = true;
                }
                MainWindow w = Minecraft.func_71410_x().func_228018_at_();
                String scaleString = ((PropertiesSection)metas.get(0)).getEntryValue("scale");
                if (scaleString != null && (MathUtils.isInteger((String)scaleString.replace(" ", "")) || MathUtils.isDouble((String)scaleString.replace(" ", "")))) {
                    int newscale = (int)Double.parseDouble(scaleString.replace(" ", ""));
                    if (newscale <= 0) {
                        newscale = 1;
                    }
                    w.func_216525_a((double)newscale);
                    if (this.mc.field_71462_r != null) {
                        this.mc.field_71462_r.field_230708_k_ = w.func_198107_o();
                        this.mc.field_71462_r.field_230709_l_ = w.func_198087_p();
                    }
                    this.scaled = true;
                }
                int autoScaleBaseWidth = 0;
                int autoScaleBaseHeight = 0;
                String baseWidth = ((PropertiesSection)metas.get(0)).getEntryValue("autoscale_basewidth");
                String baseHeight = ((PropertiesSection)metas.get(0)).getEntryValue("autoscale_baseheight");
                if (baseWidth != null && baseHeight != null && MathUtils.isInteger((String)baseWidth) && MathUtils.isInteger((String)baseHeight)) {
                    autoScaleBaseWidth = Integer.parseInt(baseWidth);
                    autoScaleBaseHeight = Integer.parseInt(baseHeight);
                }
                if (autoScaleBaseWidth != 0 && autoScaleBaseHeight != 0) {
                    double guiWidth = w.func_198105_m();
                    double guiHeight = w.func_198083_n();
                    double percentX = guiWidth / (double)autoScaleBaseWidth * 100.0;
                    double percentY = guiHeight / (double)autoScaleBaseHeight * 100.0;
                    double newScaleX = percentX / 100.0 * w.func_198100_s();
                    double newScaleY = percentY / 100.0 * w.func_198100_s();
                    double newScale = Math.min(newScaleX, newScaleY);
                    w.func_216525_a(newScale);
                    if (this.mc.field_71462_r != null) {
                        this.mc.field_71462_r.field_230708_k_ = w.func_198107_o();
                        this.mc.field_71462_r.field_230709_l_ = w.func_198087_p();
                    }
                    this.scaled = true;
                }
                if ((fadeOutString = ((PropertiesSection)metas.get(0)).getEntryValue("fadeout")) != null && fadeOutString.equalsIgnoreCase("false")) {
                    this.fadeOut = false;
                }
                if ((cusBackColorString = ((PropertiesSection)metas.get(0)).getEntryValue("backgroundcolor")) != null) {
                    this.customBackgroundHex = cusBackColorString;
                }
                if ((keepAspect = ((PropertiesSection)metas.get(0)).getEntryValue("keepaspectratio")) != null && keepAspect.equalsIgnoreCase("true")) {
                    this.keepBackgroundAspectRatio = true;
                }
                if ((backgroundImageString = ((PropertiesSection)metas.get(0)).getEntryValue("backgroundimage")) != null && (f = new File(backgroundImageString)).isFile() && (f.getPath().toLowerCase().endsWith(".jpg") || f.getPath().toLowerCase().endsWith(".jpeg") || f.getPath().toLowerCase().endsWith(".png"))) {
                    this.backgroundImagePath = backgroundImageString;
                    ExternalTextureResourceLocation tex = TextureHandler.getResource((String)backgroundImageString);
                    tex.loadTexture();
                    this.backgroundImageSource = tex;
                    this.backgroundImage = tex.getResourceLocation();
                }
                for (PropertiesSection sec : propertiesSet.getPropertiesOfType("customization")) {
                    String cusId;
                    de.keksuccino.drippyloadingscreen.api.item.v2.CustomizationItemContainer cusItem;
                    CustomizationItemBase i;
                    String action = sec.getEntryValue("action");
                    if (action == null) continue;
                    if (!CustomizationHandler.isLightModeEnabled()) {
                        if (action.equalsIgnoreCase("editlogo")) {
                            this.backgroundElements.add(new LogoSplashCustomizationItem(this.logoSplashElement, sec, logoSet));
                            logoSet = true;
                        }
                        if (action.equalsIgnoreCase("editforgestatustext")) {
                            this.backgroundElements.add(new ForgeTextSplashCustomizationItem(this.forgeTextSplashElement, sec, forgeTextSet));
                            forgeTextSet = true;
                        }
                        if (action.equalsIgnoreCase("editforgememoryinfo")) {
                            this.backgroundElements.add(new ForgeMemoryInfoSplashCustomizationItem(this.forgeMemoryInfoSplashElement, sec, forgeMemoryInfoSet));
                            forgeMemoryInfoSet = true;
                        }
                        if (action.equalsIgnoreCase("editprogressbar")) {
                            this.backgroundElements.add(new ProgressBarSplashCustomizationItem(this.progressBarSplashElement, sec, progressBarSet));
                            progressBarSet = true;
                        }
                    }
                    if (action.equalsIgnoreCase("addtext")) {
                        if (renderInBackground) {
                            this.backgroundElements.add(new StringCustomizationItem(sec));
                        } else {
                            this.foregroundElements.add(new StringCustomizationItem(sec));
                        }
                    }
                    if (action.equalsIgnoreCase("addwebtext")) {
                        if (renderInBackground) {
                            this.backgroundElements.add(new WebStringCustomizationItem(sec));
                        } else {
                            this.foregroundElements.add(new WebStringCustomizationItem(sec));
                        }
                    }
                    if (action.equalsIgnoreCase("addtexture")) {
                        if (renderInBackground) {
                            this.backgroundElements.add(new TextureCustomizationItem(sec));
                        } else {
                            this.foregroundElements.add(new TextureCustomizationItem(sec));
                        }
                    }
                    if (action.equalsIgnoreCase("addwebtexture")) {
                        if (renderInBackground) {
                            this.backgroundElements.add(new WebTextureCustomizationItem(sec));
                        } else {
                            this.foregroundElements.add(new WebTextureCustomizationItem(sec));
                        }
                    }
                    if (action.equalsIgnoreCase("addshape")) {
                        if (renderInBackground) {
                            this.backgroundElements.add(new ShapeCustomizationItem(sec));
                        } else {
                            this.foregroundElements.add(new ShapeCustomizationItem(sec));
                        }
                    }
                    if (action.equalsIgnoreCase("addslideshow")) {
                        if (renderInBackground) {
                            this.backgroundElements.add(new SlideshowCustomizationItem(sec));
                        } else {
                            this.foregroundElements.add(new SlideshowCustomizationItem(sec));
                        }
                    }
                    if (action.equalsIgnoreCase("addsplash")) {
                        String file = sec.getEntryValue("splashfilepath");
                        String text = sec.getEntryValue("text");
                        if (file != null || text != null) {
                            i = new SplashTextCustomizationItem(sec);
                            if (renderInBackground) {
                                this.backgroundElements.add(i);
                            } else {
                                this.foregroundElements.add(i);
                            }
                        }
                    }
                    if (action.equalsIgnoreCase("addcustomprogressbar")) {
                        if (renderInBackground) {
                            this.backgroundElements.add(new CustomProgressBarCustomizationItem(sec));
                        } else {
                            this.foregroundElements.add(new CustomProgressBarCustomizationItem(sec));
                        }
                    }
                    if (action.startsWith("add_")) {
                        String id = action.split("[_]", 2)[1];
                        CustomizationItemContainer c = CustomizationItemRegistry.getInstance().getElement(id);
                        if (c != null) {
                            i = c.constructWithProperties(sec);
                            if (renderInBackground) {
                                this.backgroundElements.add(i);
                            } else {
                                this.foregroundElements.add(i);
                            }
                        }
                    }
                    if (!action.startsWith("custom_layout_element:") || (cusItem = de.keksuccino.drippyloadingscreen.api.item.v2.CustomizationItemRegistry.getItem(cusId = action.split("[:]", 2)[1])) == null) continue;
                    CustomizationItem cusItemInstance = cusItem.constructCustomizedItemInstance(sec);
                    if (renderInBackground) {
                        this.backgroundElements.add(cusItemInstance);
                        continue;
                    }
                    this.foregroundElements.add(cusItemInstance);
                }
            }
            PropertiesSection propertiesSection = new PropertiesSection("customization");
            if (!logoSet) {
                this.backgroundElements.add(new LogoSplashCustomizationItem(this.logoSplashElement, propertiesSection, false));
            }
            if (!forgeTextSet) {
                this.backgroundElements.add(new ForgeTextSplashCustomizationItem(this.forgeTextSplashElement, propertiesSection, false));
            }
            if (!forgeMemoryInfoSet) {
                this.backgroundElements.add(new ForgeMemoryInfoSplashCustomizationItem(this.forgeMemoryInfoSplashElement, propertiesSection, false));
            }
            if (!progressBarSet) {
                this.backgroundElements.add(new ProgressBarSplashCustomizationItem(this.progressBarSplashElement, propertiesSection, false));
            }
            for (CustomizationItemBase i : this.foregroundElements) {
                if (!i.orientation.equals("loading-progress") || i.orientationElementIdentifier == null) continue;
                i.orientationElement = this.getItemByActionId(i.orientationElementIdentifier);
            }
            for (CustomizationItemBase i : this.backgroundElements) {
                if (!i.orientation.equals("loading-progress") || i.orientationElementIdentifier == null) continue;
                i.orientationElement = this.getItemByActionId(i.orientationElementIdentifier);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.isNewLoadingScreen = false;
    }

    protected CustomizationItemBase getItemByActionId(String actionId) {
        for (CustomizationItemBase c : this.backgroundElements) {
            if (!c.getActionId().equals(actionId)) continue;
            return c;
        }
        for (CustomizationItemBase c : this.foregroundElements) {
            if (!c.getActionId().equals(actionId)) continue;
            return c;
        }
        return null;
    }

    private static int withAlpha(int color, int alpha) {
        return color & 0xFFFFFF | alpha << 24;
    }

    public static boolean isCustomizationHelperScreen() {
        if (Minecraft.func_71410_x().field_71462_r == null) {
            return false;
        }
        return Minecraft.func_71410_x().field_71462_r instanceof CustomizationHelperScreen;
    }

    public static SplashCustomizationLayer getInstance() {
        if (instance == null) {
            instance = new SplashCustomizationLayer(false);
        }
        return instance;
    }

    static {
        backgroundColor = ColorHelper.PackedColor.func_233006_a_((int)255, (int)239, (int)50, (int)61);
        backgroundColor2 = backgroundColor & 0xFFFFFF;
    }

    public static class RandomLayoutContainer {
        public final String id;
        protected List<PropertiesSet> layouts = new ArrayList<PropertiesSet>();
        protected boolean onlyFirstTime = false;
        protected String lastLayoutPath = null;
        public SplashCustomizationLayer parent;

        public RandomLayoutContainer(String id, SplashCustomizationLayer parent) {
            this.id = id;
            this.parent = parent;
        }

        public List<PropertiesSet> getLayouts() {
            return this.layouts;
        }

        public void addLayout(PropertiesSet layout) {
            this.layouts.add(layout);
        }

        public void addLayouts(List<PropertiesSet> layouts) {
            this.layouts.addAll(layouts);
        }

        public void clearLayouts() {
            this.layouts.clear();
        }

        public void setOnlyFirstTime(boolean b) {
            this.onlyFirstTime = b;
        }

        public boolean isOnlyFirstTime() {
            return this.onlyFirstTime;
        }

        public void resetLastLayout() {
            this.lastLayoutPath = null;
        }

        @Nullable
        public PropertiesSet getRandomLayout() {
            if (!this.layouts.isEmpty()) {
                String path;
                int i;
                PropertiesSet s;
                List metas;
                File f;
                if ((this.onlyFirstTime || !this.parent.isNewLoadingScreen) && this.lastLayoutPath != null && (f = new File(this.lastLayoutPath)).exists()) {
                    for (PropertiesSet s2 : this.layouts) {
                        String path2;
                        List metas2 = s2.getPropertiesOfType("customization-meta");
                        if (metas2.isEmpty()) {
                            metas2 = s2.getPropertiesOfType("type-meta");
                        }
                        if (metas2.isEmpty() || (path2 = ((PropertiesSection)metas2.get(0)).getEntryValue("path")) == null || !path2.equals(this.lastLayoutPath)) continue;
                        return s2;
                    }
                }
                if ((metas = (s = this.layouts.get(i = MathUtils.getRandomNumberInRange((int)0, (int)(this.layouts.size() - 1)))).getPropertiesOfType("customization-meta")).isEmpty()) {
                    metas = s.getPropertiesOfType("type-meta");
                }
                if (!metas.isEmpty() && (path = ((PropertiesSection)metas.get(0)).getEntryValue("path")) != null) {
                    this.lastLayoutPath = path;
                    return s;
                }
            }
            return null;
        }
    }
}

