/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.rendering.splash;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.keksuccino.drippyloadingscreen.DrippyLoadingScreen;
import de.keksuccino.drippyloadingscreen.customization.items.v2.audio.ACIHandler;
import de.keksuccino.drippyloadingscreen.customization.placeholdervalues.PlaceholderTextValueHelper;
import de.keksuccino.drippyloadingscreen.customization.rendering.splash.SplashCustomizationLayer;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ResourceLoadProgressGui;
import net.minecraft.resources.IAsyncReloader;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class CustomizableLoadingOverlay
extends ResourceLoadProgressGui {
    private IAsyncReloader asyncReloader;
    private Consumer<Optional<Throwable>> completedCallback;
    private boolean reloading;
    private float progress;
    private long fadeOutStart;
    private long fadeInStart;
    protected boolean isUpdated = false;
    protected int lastWidth = 0;
    protected int lastHeight = 0;

    public CustomizableLoadingOverlay(ResourceLoadProgressGui parent) {
        super(Minecraft.func_71410_x(), CustomizableLoadingOverlay.getReloadInstance(parent), CustomizableLoadingOverlay.getOnFinish(parent), CustomizableLoadingOverlay.getFadeIn(parent));
        this.asyncReloader = CustomizableLoadingOverlay.getReloadInstance(parent);
        this.completedCallback = CustomizableLoadingOverlay.getOnFinish(parent);
        this.reloading = CustomizableLoadingOverlay.getFadeIn(parent);
        this.progress = CustomizableLoadingOverlay.getCurrentProgress(parent);
        this.fadeOutStart = CustomizableLoadingOverlay.getFadeOutStart(parent);
        this.fadeInStart = CustomizableLoadingOverlay.getFadeInStart(parent);
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        float f1;
        Minecraft mc = Minecraft.func_71410_x();
        SplashCustomizationLayer handler = SplashCustomizationLayer.getInstance();
        ACIHandler.onRenderOverlay(handler);
        int screenWidth = mc.func_228018_at_().func_198107_o();
        int screenHeight = mc.func_228018_at_().func_198087_p();
        long time = Util.func_211177_b();
        if (this.lastWidth != screenWidth || this.lastHeight != screenHeight) {
            this.isUpdated = false;
        }
        this.lastWidth = screenWidth;
        this.lastHeight = screenHeight;
        if (!this.isUpdated) {
            handler.updateCustomizations();
            this.isUpdated = true;
        }
        if (this.reloading && (this.asyncReloader.func_219553_c() || mc.field_71462_r != null) && this.fadeInStart == -1L) {
            this.fadeInStart = time;
        }
        float f = this.fadeOutStart > -1L ? (float)(time - this.fadeOutStart) / 1000.0f : -1.0f;
        float f2 = f1 = this.fadeInStart > -1L ? (float)(time - this.fadeInStart) / 500.0f : -1.0f;
        if (f >= 1.0f) {
            if (mc.field_71462_r != null && !DrippyLoadingScreen.isFancyMenuLoaded() && handler.fadeOut) {
                mc.field_71462_r.func_230430_a_(matrices, 0, 0, delta);
            }
        } else if (this.reloading && mc.field_71462_r != null && f1 < 1.0f && !DrippyLoadingScreen.isFancyMenuLoaded() && handler.fadeOut) {
            mc.field_71462_r.func_230430_a_(matrices, mouseX, mouseY, delta);
        }
        float f3 = this.asyncReloader.func_219555_b();
        this.progress = MathHelper.func_76131_a((float)(this.progress * 0.95f + f3 * 0.050000012f), (float)0.0f, (float)1.0f);
        if (f >= 2.0f) {
            CustomizableLoadingOverlay.resetScale(handler);
            mc.func_213268_a(null);
        }
        if (this.fadeOutStart == -1L && this.asyncReloader.func_219554_d() && (!this.reloading || f1 >= 2.0f)) {
            this.fadeOutStart = Util.func_211177_b();
            try {
                this.asyncReloader.func_219556_e();
                this.completedCallback.accept(Optional.empty());
            }
            catch (Throwable throwable) {
                this.completedCallback.accept(Optional.of(throwable));
            }
            if (mc.field_71462_r != null) {
                mc.field_71462_r.func_231158_b_(mc, screenWidth, screenHeight);
            }
        }
        handler.asyncReloader = this.asyncReloader;
        handler.completedCallback = this.completedCallback;
        handler.reloading = this.reloading;
        handler.fadeOutStart = this.fadeOutStart;
        handler.fadeInStart = this.fadeInStart;
        handler.progress = this.progress;
        PlaceholderTextValueHelper.currentLoadingProgressValue = "" + (int)(this.progress * 100.0f);
        handler.renderLayer();
    }

    private static void resetScale(SplashCustomizationLayer handler) {
        if (handler.scaled) {
            Minecraft mc = Minecraft.func_71410_x();
            MainWindow w = mc.func_228018_at_();
            int mcScale = w.func_216521_a(mc.field_71474_y.field_74335_Z, mc.func_211821_e());
            w.func_216525_a((double)mcScale);
            int screenWidth = w.func_198107_o();
            int screenHeight = w.func_198087_p();
            if (mc.field_71462_r != null) {
                mc.field_71462_r.func_231158_b_(mc, screenWidth, screenHeight);
            }
            handler.scaled = false;
        }
    }

    private static IAsyncReloader getReloadInstance(ResourceLoadProgressGui from) {
        try {
            Field f = ObfuscationReflectionHelper.findField(ResourceLoadProgressGui.class, (String)"field_212975_c");
            return (IAsyncReloader)f.get(from);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Consumer<Optional<Throwable>> getOnFinish(ResourceLoadProgressGui from) {
        try {
            Field f = ObfuscationReflectionHelper.findField(ResourceLoadProgressGui.class, (String)"field_212976_d");
            return (Consumer)f.get(from);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean getFadeIn(ResourceLoadProgressGui from) {
        try {
            Field f = ObfuscationReflectionHelper.findField(ResourceLoadProgressGui.class, (String)"field_212977_e");
            return (Boolean)f.get(from);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static float getCurrentProgress(ResourceLoadProgressGui from) {
        try {
            Field f = ObfuscationReflectionHelper.findField(ResourceLoadProgressGui.class, (String)"field_212978_f");
            return ((Float)f.get(from)).floatValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    private static long getFadeOutStart(ResourceLoadProgressGui from) {
        try {
            Field f = ObfuscationReflectionHelper.findField(ResourceLoadProgressGui.class, (String)"field_212979_g");
            return (Long)f.get(from);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    private static long getFadeInStart(ResourceLoadProgressGui from) {
        try {
            Field f = ObfuscationReflectionHelper.findField(ResourceLoadProgressGui.class, (String)"field_212980_h");
            return (Long)f.get(from);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }
}

