/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.placeholdervalues;

import com.mojang.blaze3d.platform.PlatformDescriptors;
import de.keksuccino.drippyloadingscreen.api.PlaceholderTextValueRegistry;
import de.keksuccino.konkrete.Konkrete;
import de.keksuccino.konkrete.file.FileUtils;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.math.MathUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.versions.mcp.MCPVersion;

public class PlaceholderTextValueHelper {
    public static String currentLoadingProgressValue = "0";
    public static Map<String, RandomTextPackage> randomTextIntervals = new HashMap<String, RandomTextPackage>();
    private static final File MOD_DIRECTORY = new File("mods");
    private static int cachedTotalMods = -10;

    public static String convertFromRaw(String in) {
        try {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc == null) {
                return in;
            }
            in = StringUtils.convertFormatCodes((String)in, (String)"&", (String)"\u00a7");
            in = in.replace("%guiwidth%", "" + Minecraft.func_71410_x().func_228018_at_().func_198107_o());
            in = in.replace("%guiheight%", "" + Minecraft.func_71410_x().func_228018_at_().func_198087_p());
            in = in.replace("%playername%", mc.func_110432_I().func_111285_a());
            in = in.replace("%playeruuid%", mc.func_110432_I().func_148255_b());
            in = in.replace("%mcversion%", MCPVersion.getMCVersion());
            in = PlaceholderTextValueHelper.replaceModVersionPlaceholder(in);
            in = in.replace("%loadedmods%", "" + PlaceholderTextValueHelper.getLoadedMods());
            if ((in = in.replace("%totalmods%", "" + PlaceholderTextValueHelper.getTotalMods())).contains("%realtime")) {
                Calendar c = Calendar.getInstance();
                in = in.replace("%realtimeyear%", "" + c.get(1));
                in = in.replace("%realtimemonth%", PlaceholderTextValueHelper.formatToFancyDateTime(c.get(2) + 1));
                in = in.replace("%realtimeday%", PlaceholderTextValueHelper.formatToFancyDateTime(c.get(5)));
                in = in.replace("%realtimehour%", PlaceholderTextValueHelper.formatToFancyDateTime(c.get(11)));
                in = in.replace("%realtimeminute%", PlaceholderTextValueHelper.formatToFancyDateTime(c.get(12)));
                in = in.replace("%realtimesecond%", PlaceholderTextValueHelper.formatToFancyDateTime(c.get(13)));
            }
            if (in.contains("%fps%")) {
                in = in.replace("%fps%", mc.field_71426_K.split("[ ]", 2)[0]);
            }
            if (in.contains("ram%")) {
                long i = Runtime.getRuntime().maxMemory();
                long j = Runtime.getRuntime().totalMemory();
                long k = Runtime.getRuntime().freeMemory();
                long l = j - k;
                in = in.replace("%percentram%", l * 100L / i + "%");
                in = in.replace("%usedram%", "" + PlaceholderTextValueHelper.bytesToMb(l));
                in = in.replace("%maxram%", "" + PlaceholderTextValueHelper.bytesToMb(i));
            }
            in = in.replace("%loadingprogress%", currentLoadingProgressValue);
            in = in.replace("%cpuinfo%", PlatformDescriptors.func_227775_b_());
            in = in.replace("%gpuinfo%", PlatformDescriptors.func_227776_c_());
            String javaVersion = System.getProperty("java.version");
            if (javaVersion == null) {
                javaVersion = "0";
            }
            in = in.replace("%javaversion%", javaVersion);
            String osName = System.getProperty("os.name");
            if (osName == null) {
                osName = "unknown";
            }
            in = in.replace("%osname%", osName);
            in = in.replace("%openglversion%", PlatformDescriptors.func_227777_d_());
            in = PlaceholderTextValueHelper.replaceRandomTextValue(in);
            for (PlaceholderTextValueRegistry.PlaceholderValue v : PlaceholderTextValueRegistry.getInstance().getValuesAsList()) {
                in = in.replace(v.getPlaceholder(), v.get());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return in;
    }

    public static boolean containsPlaceholderValues(String in) {
        String s = PlaceholderTextValueHelper.convertFromRaw(in);
        return !s.equals(in);
    }

    private static String replaceModVersionPlaceholder(String in) {
        try {
            for (String s : PlaceholderTextValueHelper.getReplaceablesWithValue(in, "%version:")) {
                Optional o;
                if (!s.contains(":")) continue;
                String blank = s.substring(1, s.length() - 1);
                String mod = blank.split(":", 2)[1];
                if (!ModList.get().isLoaded(mod) || !(o = ModList.get().getModContainerById(mod)).isPresent()) continue;
                ModContainer c = (ModContainer)o.get();
                String version = c.getModInfo().getVersion().toString();
                in = in.replace(s, version);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return in;
    }

    private static String replaceRandomTextValue(String in) {
        try {
            for (String s : PlaceholderTextValueHelper.getReplaceablesWithValue(in, "%randomtext:")) {
                RandomTextPackage p;
                String blank;
                String value;
                if (!s.contains(":") || !(value = (blank = s.substring(1, s.length() - 1)).split(":", 2)[1]).contains(":")) continue;
                String pathString = value.split(":", 2)[0];
                File path = new File(pathString);
                String intervalString = value.split(":", 2)[1];
                if (!MathUtils.isLong((String)intervalString) || !path.isFile() || !path.getPath().toLowerCase().endsWith(".txt")) continue;
                long interval = Long.parseLong(intervalString) * 1000L;
                if (interval < 0L) {
                    interval = 0L;
                }
                long currentTime = System.currentTimeMillis();
                if (randomTextIntervals.containsKey(path.getPath())) {
                    p = randomTextIntervals.get(path.getPath());
                } else {
                    p = new RandomTextPackage();
                    randomTextIntervals.put(path.getPath(), p);
                }
                if ((interval > 0L || p.currentText == null) && p.lastChange + interval <= currentTime) {
                    p.lastChange = currentTime;
                    List txtLines = FileUtils.getFileLines((File)path);
                    p.currentText = !txtLines.isEmpty() ? (String)txtLines.get(MathUtils.getRandomNumberInRange((int)0, (int)(txtLines.size() - 1))) : null;
                }
                if (p.currentText != null) {
                    in = in.replace(s, p.currentText);
                    continue;
                }
                in = in.replace(s, "");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return in;
    }

    protected static List<String> getReplaceablesWithValue(String in, String placeholderBase) {
        ArrayList<String> l = new ArrayList<String>();
        try {
            if (in.contains(placeholderBase)) {
                int index = -1;
                for (int i = 0; i < in.length(); ++i) {
                    String s = "" + in.charAt(i);
                    if (!s.equals("%")) continue;
                    if (index == -1) {
                        index = i;
                        continue;
                    }
                    String sub = in.substring(index, i + 1);
                    if (sub.startsWith(placeholderBase) && sub.endsWith("%")) {
                        l.add(sub);
                    }
                    index = -1;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return l;
    }

    private static int getTotalMods() {
        if (cachedTotalMods == -10) {
            if (MOD_DIRECTORY.exists()) {
                int i = 0;
                for (File f : MOD_DIRECTORY.listFiles()) {
                    if (!f.isFile() || !f.getName().toLowerCase().endsWith(".jar")) continue;
                    ++i;
                }
                cachedTotalMods = i + 2;
            } else {
                cachedTotalMods = -1;
            }
        }
        return cachedTotalMods;
    }

    private static int getLoadedMods() {
        try {
            int i = 0;
            if (Konkrete.isOptifineLoaded) {
                ++i;
            }
            return ModList.get().getMods().size() + i;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private static String formatToFancyDateTime(int in) {
        String s = "" + in;
        if (s.length() < 2) {
            s = "0" + s;
        }
        return s;
    }

    private static long bytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }

    public static class RandomTextPackage {
        public String currentText = null;
        public long lastChange = 0L;
    }
}

