/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.items.v2.audio.editor;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.auudio.audio.AudioClip;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.UIBase;
import de.keksuccino.drippyloadingscreen.customization.items.v2.audio.AudioCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.v2.audio.editor.AudioLayoutEditorElement;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollArea;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollAreaEntry;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class SelectAudioScreen
extends Screen {
    protected static final Color ENTRY_BACKGROUND_COLOR = new Color(92, 92, 92);
    protected static final Color SCREEN_BACKGROUND_COLOR = new Color(54, 54, 54);
    protected static final Color HEADER_FOOTER_COLOR = new Color(33, 33, 33);
    protected AudioLayoutEditorElement element;
    protected ScrollArea audiosScrollList;
    protected Screen parent;
    protected AdvancedButton backButton;
    protected Consumer<AudioCustomizationItem.MenuAudio> callback;

    public SelectAudioScreen(Screen parent, AudioLayoutEditorElement element, Consumer<AudioCustomizationItem.MenuAudio> callback) {
        super((ITextComponent)new StringTextComponent(""));
        this.parent = parent;
        this.callback = callback;
        this.element = element;
        this.audiosScrollList = new ScrollArea(0, 50, 300, 0);
        this.audiosScrollList.backgroundColor = ENTRY_BACKGROUND_COLOR;
        this.backButton = new AdvancedButton(0, 0, 200, 20, Locals.localize((String)"drippyloadingscreen.back", (String[])new String[0]), true, press -> {
            this.onCancel();
            Minecraft.func_71410_x().func_147108_a(this.parent);
        });
        UIBase.colorizeButton(this.backButton);
    }

    protected AudioCustomizationItem getItem() {
        return (AudioCustomizationItem)this.element.object;
    }

    protected void func_231160_c_() {
        this.updateEntries();
        this.audiosScrollList.x = this.field_230708_k_ / 2 - 150;
        this.audiosScrollList.height = this.field_230709_l_ - 100;
    }

    protected void updateEntries() {
        if (this.audiosScrollList != null) {
            ArrayList l = new ArrayList();
            l.addAll(this.audiosScrollList.getEntries());
            for (ScrollAreaEntry e : l) {
                this.audiosScrollList.removeEntry(e);
            }
            for (AudioCustomizationItem.MenuAudio c : this.getItem().audios) {
                this.audiosScrollList.addEntry((ScrollAreaEntry)new AudioScrollAreaEntry(this.audiosScrollList, c, this));
            }
        }
    }

    protected void onCancel() {
        if (this.callback != null) {
            this.callback.accept(null);
        }
    }

    public void func_231175_as__() {
        this.onCancel();
        Minecraft.func_71410_x().func_147108_a(this.parent);
    }

    public boolean func_231178_ax__() {
        return true;
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        int xCenter = this.field_230708_k_ / 2;
        RenderSystem.enableBlend();
        SelectAudioScreen.func_238467_a_((MatrixStack)matrix, (int)0, (int)0, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)SCREEN_BACKGROUND_COLOR.getRGB());
        this.audiosScrollList.render(matrix);
        SelectAudioScreen.func_238467_a_((MatrixStack)matrix, (int)0, (int)0, (int)this.field_230708_k_, (int)50, (int)HEADER_FOOTER_COLOR.getRGB());
        SelectAudioScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)Locals.localize((String)"drippyloadingscreen.audio.choose", (String[])new String[0]), (int)(this.field_230708_k_ / 2), (int)20, (int)-1);
        SelectAudioScreen.func_238467_a_((MatrixStack)matrix, (int)0, (int)(this.field_230709_l_ - 50), (int)this.field_230708_k_, (int)this.field_230709_l_, (int)HEADER_FOOTER_COLOR.getRGB());
        this.backButton.setX(xCenter - this.backButton.func_230998_h_() / 2);
        this.backButton.setY(this.field_230709_l_ - 35);
        this.backButton.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        for (ScrollAreaEntry e : this.audiosScrollList.getEntries()) {
            if (!(e instanceof AudioScrollAreaEntry) || !e.isHovered()) continue;
            String sourceTypeString = Locals.localize((String)"drippyloadingscreen.audio.sourcetype.external_local", (String[])new String[0]);
            if (((AudioScrollAreaEntry)e).audio.soundType == AudioClip.SoundType.EXTERNAL_WEB) {
                sourceTypeString = Locals.localize((String)"drippyloadingscreen.audio.sourcetype.external_web", (String[])new String[0]);
            }
            String indexString = "" + ((AudioScrollAreaEntry)e).audio.index;
            String volumeString = "" + ((AudioScrollAreaEntry)e).audio.volume;
            String[] desc = StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.audio.choose.info", (String[])new String[]{sourceTypeString, indexString, volumeString}), (String)"%n%");
            SelectAudioScreen.renderDescription(matrix, Arrays.asList(desc), mouseX, mouseY);
        }
    }

    protected static void renderDescription(MatrixStack matrix, List<String> desc, int mouseX, int mouseY) {
        if (desc != null) {
            int width = 10;
            int height = 10;
            for (String s : desc) {
                int i = Minecraft.func_71410_x().field_71466_p.func_78256_a(s) + 10;
                if (i > width) {
                    width = i;
                }
                height += 10;
            }
            mouseY += 5;
            if (Minecraft.func_71410_x().field_71462_r.field_230708_k_ < (mouseX += 5) + width) {
                mouseX -= width + 10;
            }
            if (Minecraft.func_71410_x().field_71462_r.field_230709_l_ < mouseY + height) {
                mouseY -= height + 10;
            }
            RenderUtils.setZLevelPre((MatrixStack)matrix, (int)600);
            SelectAudioScreen.renderDescriptionBackground(matrix, mouseX, mouseY, width, height);
            RenderSystem.enableBlend();
            int i2 = 5;
            for (String s : desc) {
                SelectAudioScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)s, (int)(mouseX + 5), (int)(mouseY + i2), (int)Color.WHITE.getRGB());
                i2 += 10;
            }
            RenderUtils.setZLevelPost((MatrixStack)matrix);
            RenderSystem.disableBlend();
        }
    }

    protected static void renderDescriptionBackground(MatrixStack matrix, int x, int y, int width, int height) {
        SelectAudioScreen.func_238467_a_((MatrixStack)matrix, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)new Color(26, 26, 26, 250).getRGB());
    }

    protected static void colorizeButton(AdvancedButton b) {
        b.setBackgroundColor(new Color(100, 100, 100), new Color(130, 130, 130), new Color(180, 180, 180), new Color(199, 199, 199), 1);
    }

    public static class AudioScrollAreaEntry
    extends ScrollAreaEntry {
        protected AudioCustomizationItem.MenuAudio audio;
        protected FontRenderer font;
        protected SelectAudioScreen parentScreen;
        protected boolean isMouseDown;

        public AudioScrollAreaEntry(ScrollArea parent, AudioCustomizationItem.MenuAudio audio, SelectAudioScreen parentScreen) {
            super(parent);
            this.font = Minecraft.func_71410_x().field_71466_p;
            this.isMouseDown = false;
            this.audio = audio;
            this.parentScreen = parentScreen;
        }

        public void renderEntry(MatrixStack matrix) {
            int center = this.x + this.getWidth() / 2;
            if (!this.isHovered()) {
                AudioScrollAreaEntry.func_238467_a_((MatrixStack)matrix, (int)this.x, (int)this.y, (int)(this.x + this.getWidth()), (int)(this.y + this.getHeight()), (int)ENTRY_BACKGROUND_COLOR.getRGB());
            } else {
                AudioScrollAreaEntry.func_238467_a_((MatrixStack)matrix, (int)this.x, (int)this.y, (int)(this.x + this.getWidth()), (int)(this.y + this.getHeight()), (int)ENTRY_BACKGROUND_COLOR.brighter().brighter().getRGB());
            }
            String sourceString = this.audio.path;
            if (this.font.func_78256_a(sourceString) > this.getWidth() - 30) {
                sourceString = new StringBuilder(sourceString).reverse().toString();
                sourceString = this.font.func_238412_a_(sourceString, this.getWidth() - 30);
                sourceString = new StringBuilder(sourceString).reverse().toString();
                sourceString = ".." + sourceString;
            }
            AudioScrollAreaEntry.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.font, (String)sourceString, (int)center, (int)(this.y + 10), (int)-1);
            this.handleSelection();
        }

        protected void handleSelection() {
            if (!PopupHandler.isPopupActive() && !this.parentScreen.backButton.func_230449_g_()) {
                if (MouseInput.isLeftMouseDown() && !this.isMouseDown) {
                    if (this.isHovered() && this.parentScreen.callback != null) {
                        this.parentScreen.callback.accept(this.audio);
                    }
                    this.isMouseDown = true;
                }
                if (!MouseInput.isLeftMouseDown()) {
                    this.isMouseDown = false;
                }
            } else if (MouseInput.isLeftMouseDown()) {
                this.isMouseDown = true;
            }
        }

        public int getHeight() {
            return 26;
        }
    }
}

