/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.items.v2.audio.editor;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.keksuccino.auudio.audio.AudioClip;
import de.keksuccino.auudio.util.UrlUtils;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.UIBase;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.popup.ChooseFilePopup;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.popup.FHNotificationPopup;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.popup.FHTextInputPopup;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.screens.ScrollableScreen;
import de.keksuccino.drippyloadingscreen.customization.items.v2.audio.AudioCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.v2.audio.editor.AudioLayoutEditorElement;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedTextField;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollAreaEntry;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.math.MathUtils;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;

public class EditAudioScreen
extends ScrollableScreen {
    protected AudioCustomizationItem.MenuAudio audio;
    protected AudioLayoutEditorElement parentElement;
    protected Consumer<AudioCustomizationItem.MenuAudio> callback;
    protected boolean isNewAudio = false;
    protected AdvancedButton doneButton;
    protected AdvancedButton cancelButton;

    public EditAudioScreen(Screen parent, AudioLayoutEditorElement parentElement, @Nullable AudioCustomizationItem.MenuAudio audioToEdit, Consumer<AudioCustomizationItem.MenuAudio> callback) {
        super(parent, Locals.localize((String)"drippyloadingscreen.audio.add_or_edit", (String[])new String[0]));
        this.parentElement = parentElement;
        this.audio = audioToEdit;
        if (this.audio == null) {
            this.isNewAudio = true;
            this.audio = new AudioCustomizationItem.MenuAudio(null, AudioClip.SoundType.EXTERNAL_LOCAL, (AudioCustomizationItem)this.parentElement.object);
        }
        this.callback = callback;
    }

    @Override
    public boolean isOverlayButtonHovered() {
        if (this.doneButton != null && this.doneButton.func_230449_g_()) {
            return true;
        }
        return this.cancelButton != null && this.cancelButton.func_230449_g_();
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        ArrayList oldEntries = new ArrayList();
        oldEntries.addAll(this.scrollArea.getEntries());
        for (ScrollAreaEntry e : oldEntries) {
            this.scrollArea.removeEntry(e);
        }
        this.scrollArea.addEntry((ScrollAreaEntry)new ScrollableScreen.EmptySpaceEntry(this.scrollArea, 10));
        AdvancedButton chooseSourceButton = new AdvancedButton(0, 0, 200, 20, Locals.localize((String)"drippyloadingscreen.audio.choosesource", (String[])new String[0]), true, press -> {
            if (this.audio.soundType == AudioClip.SoundType.EXTERNAL_LOCAL) {
                ChooseFilePopup p = new ChooseFilePopup(call -> {
                    if (call != null) {
                        File f = new File((String)call);
                        if (f.isFile() && f.getPath().toLowerCase().endsWith(".ogg")) {
                            this.audio.path = call;
                        } else {
                            FHNotificationPopup p2 = new FHNotificationPopup(300, new Color(0, 0, 0, 0), 240, null, StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.audio.choosesource.file.invalid", (String[])new String[0]), (String)"%n%"));
                            PopupHandler.displayPopup((Popup)p2);
                        }
                    }
                }, "ogg");
                if (this.audio.path != null) {
                    p.setText(this.audio.path);
                }
                PopupHandler.displayPopup((Popup)p);
            } else if (this.audio.soundType == AudioClip.SoundType.EXTERNAL_WEB) {
                FHTextInputPopup p = new FHTextInputPopup(new Color(0, 0, 0, 0), Locals.localize((String)"drippyloadingscreen.audio.choosesource.url", (String[])new String[0]), null, 240, call -> {
                    if (call != null) {
                        if (UrlUtils.isValidUrl((String)call)) {
                            this.audio.path = call;
                        } else {
                            FHNotificationPopup p2 = new FHNotificationPopup(300, new Color(0, 0, 0, 0), 240, null, StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.audio.choosesource.url.invalid", (String[])new String[0]), (String)"%n%"));
                            PopupHandler.displayPopup((Popup)p2);
                        }
                    }
                });
                if (this.audio.path != null) {
                    p.setText(this.audio.path);
                }
                PopupHandler.displayPopup((Popup)p);
            }
        });
        this.scrollArea.addEntry((ScrollAreaEntry)new ScrollableScreen.ButtonEntry(this.scrollArea, chooseSourceButton));
        ScrollableScreen.TextEntry indexLabelEntry = new ScrollableScreen.TextEntry(this.scrollArea, Locals.localize((String)"drippyloadingscreen.audio.index", (String[])new String[0]), true);
        indexLabelEntry.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.audio.index.desc", (String[])new String[0]), (String)"%n%"));
        this.scrollArea.addEntry((ScrollAreaEntry)indexLabelEntry);
        AdvancedTextField indexTextField = new AdvancedTextField(Minecraft.func_71410_x().field_71466_p, 0, 0, 200, 20, true, CharacterFilter.getIntegerCharacterFiler()){

            public void func_230430_a_(MatrixStack p_93657_, int p_93658_, int p_93659_, float p_93660_) {
                super.func_230430_a_(p_93657_, p_93658_, p_93659_, p_93660_);
                if (MathUtils.isInteger((String)this.func_146179_b().replace(" ", ""))) {
                    EditAudioScreen.this.audio.index = Integer.parseInt(this.func_146179_b().replace(" ", ""));
                }
            }
        };
        indexTextField.func_146203_f(10000);
        indexTextField.func_146180_a("" + this.audio.index);
        ScrollableScreen.TextFieldEntry indexFieldEntry = new ScrollableScreen.TextFieldEntry(this.scrollArea, indexTextField);
        indexFieldEntry.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.audio.index.desc", (String[])new String[0]), (String)"%n%"));
        this.scrollArea.addEntry((ScrollAreaEntry)indexFieldEntry);
        ScrollableScreen.TextEntry volumeLabelEntry = new ScrollableScreen.TextEntry(this.scrollArea, Locals.localize((String)"drippyloadingscreen.audio.volume", (String[])new String[0]), true);
        volumeLabelEntry.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.audio.volume.desc", (String[])new String[0]), (String)"%n%"));
        this.scrollArea.addEntry((ScrollAreaEntry)volumeLabelEntry);
        AdvancedTextField volumeTextField = new AdvancedTextField(Minecraft.func_71410_x().field_71466_p, 0, 0, 200, 20, true, CharacterFilter.getIntegerCharacterFiler()){

            public void func_230430_a_(MatrixStack p_93657_, int p_93658_, int p_93659_, float p_93660_) {
                super.func_230430_a_(p_93657_, p_93658_, p_93659_, p_93660_);
                if (MathUtils.isInteger((String)this.func_146179_b().replace(" ", ""))) {
                    EditAudioScreen.this.audio.volume = Integer.parseInt(this.func_146179_b().replace(" ", ""));
                }
            }
        };
        volumeTextField.func_146203_f(10000);
        volumeTextField.func_146180_a("" + this.audio.volume);
        ScrollableScreen.TextFieldEntry volumeFieldEntry = new ScrollableScreen.TextFieldEntry(this.scrollArea, volumeTextField);
        volumeFieldEntry.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.audio.volume.desc", (String[])new String[0]), (String)"%n%"));
        this.scrollArea.addEntry((ScrollAreaEntry)volumeFieldEntry);
        this.doneButton = new AdvancedButton(0, 0, 95, 20, Locals.localize((String)"drippyloadingscreen.done", (String[])new String[0]), true, press -> {
            this.onDone();
            Minecraft.func_71410_x().func_147108_a(this.parent);
        });
        UIBase.colorizeButton(this.doneButton);
        this.cancelButton = new AdvancedButton(0, 0, 95, 20, Locals.localize((String)"drippyloadingscreen.cancel", (String[])new String[0]), true, press -> {
            this.onCancel();
            Minecraft.func_71410_x().func_147108_a(this.parent);
        });
        UIBase.colorizeButton(this.cancelButton);
    }

    protected AudioCustomizationItem getItem() {
        return (AudioCustomizationItem)this.parentElement.object;
    }

    @Override
    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        int xCenter = this.field_230708_k_ / 2;
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        if (!this.isNewAudio) {
            this.doneButton.setX(xCenter - this.doneButton.func_230998_h_() / 2);
        } else {
            this.doneButton.setX(xCenter + 5);
        }
        this.doneButton.setY(this.field_230709_l_ - 35);
        this.doneButton.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        if (this.isNewAudio) {
            this.cancelButton.setX(xCenter - this.cancelButton.func_230998_h_() - 5);
            this.cancelButton.setY(this.field_230709_l_ - 35);
            this.cancelButton.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void func_231175_as__() {
        if (!PopupHandler.isPopupActive()) {
            if (this.isNewAudio) {
                this.onCancel();
            } else {
                this.onDone();
            }
            super.func_231164_f_();
        }
    }

    protected void onDone() {
        if (this.callback != null) {
            this.callback.accept(this.audio);
        }
    }

    protected void onCancel() {
        if (this.callback != null) {
            this.callback.accept(null);
        }
    }

    public AudioCustomizationItem.MenuAudio getAudio() {
        return this.audio;
    }
}

