/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.items.v2.audio;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.auudio.audio.AudioClip;
import de.keksuccino.auudio.util.UrlUtils;
import de.keksuccino.drippyloadingscreen.api.item.v2.CustomizationItem;
import de.keksuccino.drippyloadingscreen.api.item.v2.CustomizationItemContainer;
import de.keksuccino.drippyloadingscreen.audio.AudioHandler;
import de.keksuccino.drippyloadingscreen.customization.CustomizationHandler;
import de.keksuccino.drippyloadingscreen.customization.items.v2.audio.ACIHandler;
import de.keksuccino.drippyloadingscreen.utils.SoundSourceUtils;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AudioCustomizationItem
extends CustomizationItem {
    private static final ResourceLocation AUDIO_ELEMENT_TEXTURE = new ResourceLocation("drippyloadingscreen", "textures/audio_element.png");
    private static final Logger LOGGER = LogManager.getLogger((String)"drippyloadingscreen/AudioCustomizationItem");
    public List<MenuAudio> audios;
    public SoundCategory channel;
    public boolean loop;
    public boolean oncePerSession;
    public volatile boolean isLoadingNextAudio;
    public volatile MenuAudio currentAudio;
    public volatile List<String> alreadyPlayed;
    public float cachedMasterChannelVolume;
    public float cachedItemChannelVolume;

    public AudioCustomizationItem(CustomizationItemContainer parentContainer, PropertiesSection item) {
        String oncePerSessionString;
        block28: {
            super(parentContainer, item);
            this.audios = new ArrayList<MenuAudio>();
            this.channel = SoundCategory.MASTER;
            this.loop = true;
            this.oncePerSession = false;
            this.isLoadingNextAudio = false;
            this.currentAudio = null;
            this.alreadyPlayed = new ArrayList<String>();
            this.cachedMasterChannelVolume = -1.0f;
            this.cachedItemChannelVolume = -1.0f;
            String channelString = item.getEntryValue("channel");
            if (channelString != null) {
                try {
                    SoundCategory soundSource = SoundSourceUtils.getSourceForName(channelString);
                    if (soundSource != null) {
                        this.channel = soundSource;
                        break block28;
                    }
                    LOGGER.warn("WARNING: Channel was NULL after parsing! Channel set to MASTER! (" + channelString + ")");
                }
                catch (Exception e) {
                    LOGGER.warn("WARNING: Unable to parse channel! Channel set to MASTER! (" + channelString + ")");
                    e.printStackTrace();
                }
            } else {
                LOGGER.warn("WARNING: Channel is NULL! Channel set to MASTER!");
            }
        }
        String loopString = item.getEntryValue("loop");
        if (loopString != null && loopString.equalsIgnoreCase("false")) {
            this.loop = false;
        }
        if ((oncePerSessionString = item.getEntryValue("once_per_session")) != null && oncePerSessionString.equalsIgnoreCase("true")) {
            this.oncePerSession = true;
        }
        for (Map.Entry entry : item.getEntries().entrySet()) {
            if (!((String)entry.getKey()).startsWith("audio_source:")) continue;
            String audioIdentifier = ((String)entry.getKey()).split(":", 2)[1];
            if (((String)entry.getValue()).contains(";")) {
                String[] audioProps = ((String)entry.getValue()).split("[;]", -1);
                if (audioProps.length >= 4) {
                    AudioClip.SoundType type;
                    String sourceString;
                    block29: {
                        sourceString = audioProps[0];
                        if (sourceString == null) {
                            LOGGER.error("ERROR: Source is NULL! (" + (String)entry.getValue() + ")");
                            continue;
                        }
                        String typeString = audioProps[1];
                        if (typeString == null) {
                            LOGGER.error("ERROR: Type is NULL! (" + (String)entry.getValue() + ")");
                            continue;
                        }
                        try {
                            type = AudioClip.SoundType.valueOf((String)typeString);
                            if (type == null) {
                                LOGGER.error("ERROR: Sound type was NULL after parsing! (" + (String)entry.getValue() + ")");
                            }
                            break block29;
                        }
                        catch (Exception e) {
                            LOGGER.error("ERROR: Unable to parse sound type! (" + (String)entry.getValue() + ")");
                            e.printStackTrace();
                        }
                        continue;
                    }
                    String volString = audioProps[2];
                    int vol = 100;
                    if (MathUtils.isInteger((String)volString)) {
                        vol = Integer.parseInt(volString);
                    } else {
                        LOGGER.warn("WARNING: Unable to parse volume! Volume set to 100! (" + (String)entry.getValue() + ")");
                    }
                    String indexString = audioProps[3];
                    int index = 0;
                    if (indexString != null && MathUtils.isInteger((String)indexString)) {
                        index = Integer.parseInt(indexString);
                        if (index < 0) {
                            index = 0;
                            LOGGER.warn("WARNING: Tried to use negative index! Index corrected to 0! (" + (String)entry.getValue() + ")");
                        }
                    } else {
                        LOGGER.warn("WARNING: Unable to parse index! Index set to 0! (" + (String)entry.getValue() + ")");
                    }
                    MenuAudio ma = new MenuAudio(sourceString, type, this);
                    ma.volume = vol;
                    if (audioIdentifier != null && audioIdentifier.length() >= 7) {
                        ma.audioIdentifier = audioIdentifier;
                    }
                    ma.index = index;
                    this.audios.add(ma);
                    continue;
                }
                LOGGER.error("ERROR: Unable to parse audio source properties string! (" + (String)entry.getValue() + ")");
                continue;
            }
            LOGGER.error("ERROR: Invalid audio source properties string! (" + (String)entry.getValue() + ")");
        }
        if (this.oncePerSession && ACIHandler.startedOncePerSessionItems.containsKey(this.actionId)) {
            this.alreadyPlayed = ACIHandler.startedOncePerSessionItems.get((Object)this.actionId).alreadyPlayed;
        }
        if (this.oncePerSession) {
            this.loop = false;
            ACIHandler.startedOncePerSessionItems.put(this.actionId, this);
        }
        if (!this.oncePerSession) {
            if (!this.loop && ACIHandler.currentNonLoopItems.containsKey(this.actionId)) {
                this.alreadyPlayed = ACIHandler.currentNonLoopItems.get((Object)this.actionId).alreadyPlayed;
            }
            if (!this.loop) {
                ACIHandler.currentNonLoopItems.put(this.actionId, this);
            }
        }
        if (!AudioCustomizationItem.isEditorActive() && (this.loop || this.alreadyPlayed.size() < this.audios.size())) {
            for (MenuAudio menuAudio : this.audios) {
                if (!ACIHandler.lastPlayingAudioSources.contains(menuAudio.path)) continue;
                this.startAsynchronous(menuAudio, false);
                ACIHandler.lastPlayingAudioSources.remove(menuAudio.path);
                break;
            }
        }
    }

    @Override
    public void render(MatrixStack poseStack) {
        if (this.shouldRender()) {
            if (AudioCustomizationItem.isEditorActive()) {
                RenderSystem.enableBlend();
                Minecraft.func_71410_x().field_71446_o.func_110577_a(AUDIO_ELEMENT_TEXTURE);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                AudioCustomizationItem.func_238463_a_((MatrixStack)poseStack, (int)this.getPosX(), (int)this.getPosY(), (float)1.0f, (float)1.0f, (int)this.width, (int)this.height, (int)this.width, (int)this.height);
            }
            this.tickAudio();
        }
    }

    public void tickAudio() {
        if (!AudioCustomizationItem.isEditorActive() && !this.audios.isEmpty()) {
            MenuAudio nextAudio = null;
            if (this.currentAudio == null) {
                if (!this.isLoadingNextAudio) {
                    nextAudio = this.pickNextAudio();
                }
            } else if (!this.currentAudio.isPlaying()) {
                nextAudio = this.pickNextAudio();
            }
            if (nextAudio != null) {
                this.startAsynchronous(nextAudio, true);
            }
            float masterVol = Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.MASTER);
            float itemChannelVol = Minecraft.func_71410_x().field_71474_y.func_186711_a(this.channel);
            if (this.cachedMasterChannelVolume != masterVol || this.cachedItemChannelVolume != itemChannelVol) {
                for (MenuAudio a : this.audios) {
                    a.setVolume(a.volume);
                }
            }
            this.cachedMasterChannelVolume = masterVol;
            this.cachedItemChannelVolume = itemChannelVol;
        }
    }

    protected MenuAudio pickNextAudio() {
        if (!this.audios.isEmpty()) {
            if (this.alreadyPlayed.size() >= this.audios.size()) {
                if (this.loop) {
                    this.alreadyPlayed.clear();
                } else {
                    return null;
                }
            }
            List<Object> nextAudios = new ArrayList();
            if (this.currentAudio != null) {
                nextAudios = this.getRemainingAudiosWithIndex(this.currentAudio.index);
                if (nextAudios.isEmpty()) {
                    int nextIndex = this.getNextAudioIndex();
                    if (nextIndex == -1) {
                        return null;
                    }
                    nextAudios = this.getRemainingAudiosWithIndex(nextIndex);
                }
            } else {
                int nextIndex = this.getNextAudioIndex();
                if (nextIndex == -1) {
                    return null;
                }
                nextAudios = this.getRemainingAudiosWithIndex(nextIndex);
            }
            if (!nextAudios.isEmpty()) {
                return (MenuAudio)nextAudios.get(MathUtils.getRandomNumberInRange((int)0, (int)(nextAudios.size() - 1)));
            }
        }
        return null;
    }

    protected void startAsynchronous(MenuAudio audio, boolean restart) {
        if (!(this.isLoadingNextAudio || this.currentAudio != null && this.currentAudio.isPlaying())) {
            if (this.currentAudio != null) {
                ACIHandler.lastPlayingAudioSources.remove(this.currentAudio.path);
            }
            this.isLoadingNextAudio = true;
            this.currentAudio = null;
            if (!this.alreadyPlayed.contains(audio.audioIdentifier)) {
                this.alreadyPlayed.add(audio.audioIdentifier);
            }
            if (audio.soundType == AudioClip.SoundType.EXTERNAL_LOCAL) {
                File f = new File(audio.path);
                if (!f.isFile() || !f.getPath().toLowerCase().endsWith(".ogg")) {
                    this.isLoadingNextAudio = false;
                    LOGGER.error("ERROR: Unable to start next audio! Invalid audio file! (" + audio.path + ")");
                    return;
                }
            } else if (audio.soundType == AudioClip.SoundType.EXTERNAL_WEB && !UrlUtils.isValidUrl((String)audio.path)) {
                this.isLoadingNextAudio = false;
                LOGGER.error("ERROR: Unable to start next audio! Invalid audio URL! (" + audio.path + ")");
                return;
            }
            new Thread(() -> {
                AudioClip clip = audio.getClip();
                if (clip != null) {
                    audio.setVolume(audio.volume);
                    clip.setLooping(false);
                    if (restart) {
                        clip.stop();
                    }
                    clip.play();
                    long startTime = System.currentTimeMillis();
                    while (!clip.playing()) {
                        if (!ACIHandler.canPlaySounds()) {
                            this.isLoadingNextAudio = false;
                            return;
                        }
                        long now = System.currentTimeMillis();
                        if (startTime + 10000L > now) continue;
                        LOGGER.error("ERROR: Unable to start next audio! Timeout while starting clip! (" + audio.path + ")");
                        this.isLoadingNextAudio = false;
                        return;
                    }
                    if (!ACIHandler.lastPlayingAudioSources.contains(audio.path)) {
                        ACIHandler.lastPlayingAudioSources.add(audio.path);
                    }
                    this.currentAudio = audio;
                } else {
                    LOGGER.error("ERROR: Unable to start next audio! Clip is NULL! (" + audio.path + ")");
                }
                this.isLoadingNextAudio = false;
            }).start();
        }
    }

    protected List<MenuAudio> getRemainingAudiosWithIndex(int index) {
        ArrayList<MenuAudio> l = new ArrayList<MenuAudio>();
        for (MenuAudio a : this.audios) {
            if (this.alreadyPlayed.contains(a.audioIdentifier) || a.index != index) continue;
            l.add(a);
        }
        return l;
    }

    protected List<Integer> getSortedAudioIndexes() {
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (MenuAudio a : this.audios) {
            if (l.contains(a.index)) continue;
            l.add(a.index);
        }
        Collections.sort(l);
        return l;
    }

    protected int getNextAudioIndex() {
        List<Integer> indexes = this.getSortedAudioIndexes();
        if (!indexes.isEmpty()) {
            if (this.currentAudio == null) {
                return indexes.get(0);
            }
            for (int i : indexes) {
                if (i <= this.currentAudio.index) continue;
                return i;
            }
        }
        return -1;
    }

    public void reload() {
        if (this.currentAudio != null) {
            this.currentAudio.clip.stop();
        }
        this.currentAudio = null;
    }

    public static class MenuAudio {
        public volatile String audioIdentifier = CustomizationHandler.generateRandomActionId();
        public volatile int index = 0;
        public volatile String path;
        public volatile AudioClip.SoundType soundType;
        public volatile AudioClip clip = null;
        public volatile int volume = 100;
        public final AudioCustomizationItem parent;

        public MenuAudio(@Nonnull String source, @Nonnull AudioClip.SoundType soundType, @Nonnull AudioCustomizationItem parent) {
            this.path = source;
            this.soundType = soundType;
            this.parent = parent;
        }

        @Nullable
        public AudioClip getClip() {
            if (this.clip == null) {
                this.clip = AudioHandler.getAudio(this.path, this.soundType);
            }
            return this.clip;
        }

        public boolean isPlaying() {
            if (this.clip == null) {
                return false;
            }
            return this.clip.playing();
        }

        public void setVolume(int volume) {
            this.volume = volume;
            float newVolFloat = this.volume;
            if (this.parent.channel != SoundCategory.MASTER) {
                float mcVol = Minecraft.func_71410_x().field_71474_y.func_186711_a(this.parent.channel) * 100.0f;
                float clipVolOnePercent = (float)this.volume / 100.0f;
                newVolFloat = clipVolOnePercent * mcVol;
            }
            if (this.clip != null) {
                this.clip.setVolume((int)newVolFloat);
            }
        }
    }
}

